/***************************************************************************
                          knccursortoolbar.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlabel.h>
#include <ktoolbarbutton.h>
#include <kiconloader.h>
#include "knccursortoolbar.h"

KNCCursorToolBar::KNCCursorToolBar(QWidget *parent, const char *name )
 : KToolBar(parent,name)
{
  _Left = new QLabel(this);
	_Left->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  _Left->setLineWidth(1);
  insertWidget(2, 500, _Left);//, 200, 100);

  insertButton(UserIcon("calcsize"), 0);

  _Right = new QLabel(this);
	_Right->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  _Right->setLineWidth(1);
  insertWidget(3, 500, _Right); //, 200, 101);
  insertButton(UserIcon("calcsize"), 1);

  getButton(0)->setEnabled(false);
  getButton(1)->setEnabled(false);

  setFullSize();
}

KNCCursorToolBar::~KNCCursorToolBar()
{
 delete _Left;
 delete _Right;
}

void KNCCursorToolBar::setLeftSide(QString Message, bool ShowSizeButton)
{
 _Left->setText(Message);
 getButton(0)->setEnabled(ShowSizeButton);
}

void KNCCursorToolBar::setRightSide(QString Message, bool ShowSizeButton)
{
 _Right->setText(Message);
 getButton(1)->setEnabled(ShowSizeButton);
}

void KNCCursorToolBar::layoutComponents (QSize size)
{
 int w = (size.width() / 2) - 12;
 int lw = w;
 int rw = w;
 int lwlabel = lw - 17; //getButton(0)->width();

 _Left->resize(lwlabel, _Left->height());
 _Left->setMinimumWidth(lwlabel);
 _Left->setMaximumWidth(lwlabel);

 int rwlabel = rw - 17; //getButton(1)->width();

 _Right->resize(rwlabel, _Right->height());
 _Right->move(lw+15, _Right->y());
 _Right->setMinimumWidth(rwlabel);
 _Right->setMaximumWidth(rwlabel);
}

void KNCCursorToolBar::resizeEvent ( QResizeEvent * e)
{
 layoutComponents(e->size());
}

/*
void KNCCursorToolBar::paintEvent (QPaintEvent * e)
{
// layoutComponents(size());
}
*/