/***************************************************************************
                          knclistviewitem.cpp  -  description
                             -------------------
    begin                : Tue Aug 29 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfont.h>

#include <kfileitem.h>

#include "knclistviewitem.h"
#include "helpfuncs.h"

KNCListViewItem::KNCListViewItem ( KFileItem* Item, KNCListView *parent, QString q1, QString q2,
                                  QString q3, QString q4, QString q5, QString q6, QString q7,
                                  QString q8 )
 : QListViewItem (parent, q1, q2, q3, q4, q5, q6, q7, q8), _DirSize(0), _ListView(parent)
{
 _FileItem = new KFileItem(*Item);
}

KNCListViewItem::~KNCListViewItem()
{
 delete _FileItem;
}

void KNCListViewItem::setDirSize(long DirSize)
{
  _DirSize = DirSize;
  setText(1, formatLong(_DirSize));
}

void KNCListViewItem :: paintCell (QPainter * p, const QColorGroup & cg, int column, int width, int align)
{
 if ((_FileItem->isLink()) && (column == 0))
 {
   QFont font = p->font();
   font.setItalic(true);
   p->setFont(font);
 }

 QListViewItem::paintCell(p, cg, column, width, align);
}

void KNCListViewItem :: paintFocus( QPainter * p, const QColorGroup & cg, const QRect & r )
{
  //Draw Focus
  p->setPen(_ListView->getFocusColor());
  p->setClipping(false);
  int contentsX = listView()->contentsX();
  QRect FocusRect(0,r.top(),r.width()+contentsX,r.height());

  p->drawLine(FocusRect.left(), FocusRect.top(), FocusRect.right(),FocusRect.top());
  p->drawLine(FocusRect.left(), FocusRect.bottom(), FocusRect.right(),FocusRect.bottom());

  //Draw Cursor
  p->setPen(_ListView->getFocusCursorColor());
  QFontMetrics FMetrics(p->font());
  QFont f = p->font();
  QString FName = f.rawName();
  if (_ListView->_SubString != NULL)
  {
     QRect CRect = r;
     if (pixmap(0)) contentsX -= pixmap(0)->width();
     CRect.setLeft (1+FMetrics.width(_ListView->_SubString, _ListView->_SubString.length())-contentsX);
     CRect.setRight (1+FMetrics.width(_ListView->_SubString, _ListView->_SubString.length())-contentsX);
     p->drawRect(CRect);
  }
}


QString makeKey (long l)
{
  QString LLength;
  LLength.setNum(l);

  QString MKey;
  MKey = QString().setNum(LLength.length()) + " " + QString().setNum(l);
  return MKey;
}


QString KNCListViewItem::key(int column, bool ascending) const
{
  _ListView->_SortColumn = column;
  _ListView->_SortAscending = ascending;

  static QString MKey;
  if (column == 0)
  {
     MKey = _FileItem->name();
     if (_FileItem->isDir())
     {
        MKey = MKey.upper();
        MKey.prepend("!");
     }
     else MKey = MKey.lower();
  }
  if (column == 1) //size ausgewaehlt
  {
    QString SLength;
    if (_FileItem->isDir()) SLength = "";
    else SLength = QString().setNum(_FileItem->size());
    MKey = QString().setNum(SLength.length()) + " " + QString().setNum(_FileItem->size());
  }
  if (column == 2) return text(2); //attrib
  if (column == 3) return text(3); //owner
  if (column == 4) return text(4); //group
  if (column == 5) return makeKey(_FileItem->time(KIO::UDS_MODIFICATION_TIME));
  if (column == 6) return makeKey(_FileItem->time(KIO::UDS_ACCESS_TIME));
  if (column == 7) return makeKey(_FileItem->time(KIO::UDS_CREATION_TIME));

  return MKey;
}
