  /*

  knetfilter v. 2.0.3

  Copyright (C) 2000 Luigi Genoni
  		     venom@DarkStar.sns.it
  */


#ifndef KNETFILTER_H
#define KNETFILTER_H

#include <qlistbox.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qwidget.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qcheckbox.h>

#include <kapp.h>
#include <ktmainwindow.h>
#include <kpopupmenu.h>
#include <klocale.h>
#include <kprocess.h>
#include <kstatusbar.h>

#include "knat_gui.h"
#include "knat_debug.h"

#define PROGRAM_NAME	"knetfilter"


#define ID_HINTTEXT 1

class knetfilter : public KTMainWindow
{

  Q_OBJECT

protected:
  /* setup functions */
  void setupMenuBar();
  void setupToolBar();
  void setupStatusBar();
  void setupknetfilterWidget(); 

  void setupConnect();

  /* check for iptables function */
  void checkIptables();

  /* check for masqurading function */
  void checkMasquerade();

public:
  knetfilter( QWidget *parent=0, const char *name=0 );
  ~knetfilter();

  void closeEvent (QCloseEvent *);

  /* defines some processes */
  KProcess addp;
  KProcess addp2;
  KProcess addp3;
  KProcess delp;
  KProcess delp2;
  KProcess delp3;
  KProcess save;
  KProcess load;
  KProcess stop;
  KProcess stop_nat;
  KProcess stop_mangle;
  KProcess polrules;
  KProcess natpolrules;
  KProcess natrules;
  KProcess masqon; 
  KProcess masqoff; 
  KProcess rules;
  KProcess fetchIp;
  KProcess fetchNetmask;
  KProcess entries;
  KProcess tcpdump;
  KProcess nmap;
  KProcess addredirect;
  KProcess delredirect;
  KProcess addmangle;
  KProcess delmangle;
  KProcess manglepolrules;

public slots:
  void addRule();
  void delRule();
  void addRule_tcp();
  void delRule_tcp();
  void addRule_udp();
  void delRule_udp();
  void addRule_icmp();
  void delRule_icmp();
  void stopAll();
  void saveAll();
  void loadAll();
  void stopNAT();
  void stopMangle();
  void slotExit();
  void addDone_tcp();
  void delDone_tcp();
  void addDone_udp();
  void delDone_udp();
  void addDone_icmp();
  void delDone_icmp();
  void saveDone();
  void loadDone();
  void stopDone();
  void stop_natDone();
  void stop_mangleDone();
  void masqonDone();
  void masqoffDone();
  void clearLog();

   /* interface functions */
  void startprobeInterface();
  void probeInterface(KProcess *, char *, int);
  void probeInterface2(KProcess *, char *, int); 
  void probeInterfaceDone();
  void starttcpDump();
  void closetcpDump();
  void tcpDump();
  void listDump(KProcess *, char *, int);
  void startNMap();
  void closeNMap();
  void nmapoptActivated(int);
  void nmapoptActivated_icmp(int);
  void NMap();
  void portDump(KProcess *, char *, int);

  /* list rules functions */
  void iptablesRules();
  void closeiptablesRules();
  void startlistRules();
  void listRulesDone();
  void listRules(KProcess *, char *, int);

  void interfaceActivated(int);
  void interfacenrActivated(int);
  void chainActivated(int);
  void policyActivated(int);
  void flagsActivated(int);
  void polchainActivated(int);

  /* chain policy options */
  void polRules();
  void closepolRules();
  void startpolRules();
  void polRulesDone();
  void setpolRules(KProcess *, char *, int);
  void chainpolicyActivated(int);


  /* nat redirections options */
  void natRules();
  void closenatRules();
  void startnatRules();
  void stopnatRules();
  void setnatRules(KProcess *, char *, int);
  void natchainActivated(int);
  void natprotocolActivated(int);


  /* nat chain policy options */
  void natpolRules();
  void closenatpolRules();
  void startnatpolRules();
  void natpolRulesDone();
  void natpolchainActivated(int);
  void setnatpolRules(KProcess *, char *, int);
  void natpolicyActivated(int);
  

   /* list masq functions */
  void masqRules();
  void closemasqRules();
  void startmasqRules();
  void stopmasqRules();
  void setmasqRules(KProcess *, char *, int);
  void masqinterfaceActivated(int);
  void masqinterfacenrActivated(int);
  void masqprotocolActivated(int);
  void startmasqEntries();
  void userEntries(KProcess *, char *, int);
  void userEntriesDone();


  /* list mangle functions */
  void mangleRules();
  void manglepolRules();
  void closemangleRules();
  void closemanglepolRules();
  void startmangleRules();
  void startmanglepolRules();
  void stopmangleRules();
  void manglepolRulesDone();
  void startmangleEntries();
  void setmangleRules(KProcess *, char *, int);
  void setmanglepolRules(KProcess *, char *, int);
  void mangleprotocolActivated(int);
  void manglechainActivated(int);
  void mangletosActivated(int);
  void manglepolchainActivated(int);
  void mangleactionActivated(int);
  void manglepolicyActivated(int); 
  void manglelogLevel(int);
  void log1Mode();
  void log2Mode();
  void log3Mode();


private:
  /* some global objects */
  QPushButton *startBtn;
  QPushButton *stopBtn;
  QPushButton *helpBtn;
  QPushButton *exitBtn; 
  QListBox *messageLog;
  QPopupMenu *file;
  QPopupMenu *tables;
  QPopupMenu *nat_tables;
  QPopupMenu *mangle;
  QPopupMenu *options;
  QPopupMenu *help;
  QLineEdit *ipAddr;
  QLineEdit *netmaskAddr;
  QLineEdit *addSourcePort;
  QLineEdit *addDestinationPort;
  QLineEdit *addIcmpType;
  QLineEdit *addRuleNumber;
  QLineEdit *extraNet;
  QLineEdit *extraNetMask;
  QLineEdit *firstNet;
  QLineEdit *firstNetMask;
  QLineEdit *firstPort;
  QLineEdit *secondNet;
  QLineEdit *secondNetMask;
  QLineEdit *secondPort;
  QLineEdit *thirdNet;
  QLineEdit *thirdNetMask;
  QLineEdit *thirdPort;
  QLineEdit *addnatRuleNumber;
  QLineEdit *addmasqRuleNumber;
  QLineEdit *masqSPortNumber;
  QLineEdit *masqDPortNumber;
  QLineEdit *firstmasqNet;
  QLineEdit *firstmasqNetMask;
  QLineEdit *secondmasqNet;
  QLineEdit *secondmasqNetMask;
  QLineEdit *addmangleSourcePort;
  QLineEdit *addmangleDestinationPort;
  QLineEdit *addmangleRuleNumber;
  QLineEdit *firstmangleNet;
  QLineEdit *firstmangleNetMask;
  QLineEdit *firstmanglePort;
  QLineEdit *secondmangleNet;
  QLineEdit *secondmangleNetMask;
  QLineEdit *secondmanglePort;
  QLineEdit *mangleMark;
  QLineEdit *logName;
  QLineEdit *mapNet;
  QLineEdit *mapNetMask;

  KNFWidget *polList;
  KNFWidget *natList;
  KNFWidget *natpolList;
  KNFWidget *masqList;
  KNFWidget *mangleList;
  KNFWidget *manglepolList;
  KNFWidget *dumpList;
  KNFWidget *mapList;
  KNFWidget *masqWin;
  QListBox *polBox;
  QListBox *natpolBox;
  QListBox *manglepolBox;
  QListBox *masqBox;
  QListBox *dumpBox;
  QListBox *mapBox;
  QComboBox *interface;
  QComboBox *interfacenr;
  QComboBox *chain;
  QComboBox *policy;
  QComboBox *nat;
  QComboBox *natinterface;
  QComboBox *natinterfacenr;
  QComboBox *natprotocol;
  QComboBox *masqinterface;
  QComboBox *masqinterfacenr;
  QComboBox *masqprotocol;
  QComboBox *flags;
  QComboBox *polchain;
  QComboBox *polchainpolicy;
  QComboBox *natchain;
  QComboBox *natchainpolicy;
  QComboBox *natpolchain;
  QComboBox *natpolchainpolicy;
  QComboBox *manglechain;
  QComboBox *manglechainpolicy;
  QComboBox *manglepolchain;
  QComboBox *manglepolchainpolicy;
  QComboBox *mangleprotocol;
  QComboBox *mangleaction;
  QComboBox *mangletos;
  QComboBox *loglevel;
  QComboBox *nmapoptions;
  QComboBox *nmapoptions_icmp;
  QCheckBox *mapopt1;
  QCheckBox *mapopt2;
  QCheckBox *mapopt3;
  QCheckBox *manglelog1;
  QCheckBox *manglelog2;
  QCheckBox *manglelog3;

  /* the menubar, toolbar and statusbar */
  KMenuBar *menubar;
  KToolBar *toolbar;
  KStatusBar *statusbar;

  QWidget *masqWidget;

  /* checking for files */
  FILE *sbin;
  FILE *ip_masquerade;
  
  int toolbar1;
	
  int useMasq;
  char *use;
	
  char *interfaceChoice;
  int interfacenrChoice;
  char *interfaceChoicedmp;
  char *interfacenrChoicedmp;
  char *interfaceChoicemasq;
  char *ruleaction;
  char *chainChoice;
  char *policyChoice;
  char *flagChoice;
  char *natprotocolChoice;
  char *polchainChoice;
  char *chainpolicyChoice;
  char *natruleaction;
  char *natchainChoice;
  char *natchainResult;
  char *natpolchainChoice;
  char *natchainpolicyChoice;
  char *masqinterfaceChoice;
  int masqinterfacenrChoice;
  char *masqinterfacenrChoicedmp;
  char *masqruleaction;
  char *masqprotocolChoice;
  char *manglechainChoice;
  char *manglepolchainChoice;
  char *mangleactionChoice;
  char *manglechainpolicyChoice;
  char *mangleprotocolChoice;
  char *mangletosChoice;
  char *mangleruleaction;
  char *mangleSyn;
  char *nmapopt;
  char *nmapopt_icmp;
  char* logLevel;
  char *log1;
  char *log2;
  char *log3;

   
  int add;
  int del; 

/*-------- REMOVE LATER --------
  int polcheck;
  int rulecheck;
  int dumpcheck;
  int natpolcheck;
  int natcheck;
  int masqcheck;
  ------------------------------*/

};

#endif
