/**
 * classpreview.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include "classpreview.h"

#include "kcfgcoptions.h"
#include "applicationtoken.h"
#include "grouptoken.h"
#include "entrytoken.h"
#include "kcfgcreator.h"
#include "kconfig_compiler.h"

#include <kdebug.h>

#include <qstylesheet.h>
#include <qtextstream.h>
#include <qptrlist.h>

using namespace KCfgCreator;

QString ClassPreview::previewGroup( KCfgCreator::GroupToken* group, bool )
{
    CreatorKCfg parser( 0 );

    QDomImplementation impl;
    QDomDocumentType docType = impl.createDocumentType(
        "kcfg",
        QString::null,
        "http://www.kde.org/standards/kcfg/1.0/kcfg.dtd" );

    QDomDocument doc( docType );
    QDomElement el = parser.createGroup( doc, group );
    return QStyleSheet::escape( createGroup( el ) );
}

QString ClassPreview::previewClass( KCfgCreator::ApplicationToken* app )
{
    CreatorKCfg parser( 0 );
    QString str = parser.configAsString( app );
    QString ret = createHeader( str );

    return QStyleSheet::escape( ret );
}

QString ClassPreview::previewEntry( KCfgCreator::EntryToken* token )
{
    GroupToken *group = token->parent();
    return previewClass( group->parent() );
}
