// Emacs-Mode: -*-C++-*-
/***************************************************************************
                          filemanager.h  -  Filemanagement for LogBooks
                             -------------------
    begin                : Son Apr 7 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
    version              : $Revision: 1.3 $
    date                 : $Date: 2002/04/12 23:17:08 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILEMANAGER_H
#define FILEMANAGER_H


// forward declarations
class LogBook;
class QString;


//! Class for reading / writing logbooks to / from disk
/*! Class for reading / writing logbooks to / from disk

  \author Martin Habbecke
 */
class FileManager {

public: 
    //! Default Constructor
    FileManager();

    //! Default Destructor
    ~FileManager();


    //! Function to write a logbook to disk
    bool writeLogBook( const QString &filename, LogBook *logBook );

    //! Function to read a logbook from disk
    bool readLogBook( const QString &filename, LogBook *logBook );
};

#endif
