// Emacs-Mode: -*-C++-*-
/***************************************************************************
                          logbookwidget.h  -  description
                             -------------------
    begin                : Son Apr 7 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
    version              : $Revision: 1.5 $
    date                 : $Date: 2002/04/14 09:24:11 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef LOGBOOKWIDGET_H
#define LOGBOOKWIDGET_H


#include <qwidget.h>

#include <klistview.h>

#include "dive.h"
#include "logbookwidgetgui.h"


// forward declarations
class KActionCollection;
class LogBook;


//! Widget to display a logbook
/*! Widget that displays a logbook.

  \author Martin Habbecke
*/
class LogBookWidget : public LogBookWidgetGUI  {

    Q_OBJECT

public: 
    //! Default Constructor
    LogBookWidget(QWidget *parent=0, const char *name=0);
    
    //! Default Destructor
    ~LogBookWidget();

    //! Function to set a LogBook that should be displayed
    void setLogBook( LogBook *logBook );

    //! Function to get a list of the numbers of the currently selected dives
    void getSelectedDives( QPtrList< int > &selectionList );
    
    //! Function that returns the number of currnetly selected dives
    int getNumberOfSelectedDives( void );


public slots:
    //! Slot that is called whenever the selection in the ListView changes
    void slotSelectionChanged( void );


signals:
    //! Signal that is emitted whenever the selection in the ListView chnges
    void signalSelectionChanged( int numberOfSelectedDives );


protected:
    //! KListViewItem for displaying a dive in the LogBookWidget
    /*! LogBookListViewItem is a private class of class LogBookWidget and
      is a KListViewItem. Its purpose is simply to display a dive from
      a logbook in the KListView of the LogBookWidget.
    */
    class LogBookListViewItem : public KListViewItem {
	
    public:
	//! Contsructor
	LogBookListViewItem( const Dive &dive, KListView *parent );

	//! Access to the number of the dive that this item displays
	inline int diveNumber( void ) const;

	//! Overloaded key()-function for better sorting
	virtual QString key( int column, bool ascending ) const;

    protected:
	//! Number of the dive which this item displays
	int _number;
    };

};



inline int LogBookWidget::LogBookListViewItem::diveNumber( void ) const
{ return _number; }



#endif
