/***************************************************************************
                          kaspaline.h  -  description                              
                             -------------------                                         
    begin                : Mon Nov 1 1999                                           
    copyright            : (C) 1999 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KASPALINE_H
#define KASPALINE_H

#include <qwidget.h>
#include <krestrictedline.h>
#include <qvalidator.h>
#include <qstring.h>

class KaspaValidator: public QValidator {
	Q_OBJECT

private:
	KaspaValidator(const KaspaValidator&);
	KaspaValidator& operator=(KaspaValidator&);

public:
	KaspaValidator(QWidget * parent, const char * name = 0 ):
		QValidator(parent, name) {};

	virtual State validate(QString& s, int& pos) {
		if(s.find('a')==-1) {
//			debug("KaspaValidator::validate(): Valid, %s", s.data());
			return Valid;
		}
		else {
//			debug("KaspaValidator::validate(): Invalid, %s", s.data());
			return Invalid;
		}
	};
};

/**
  *@author Jan Mueller
  */
class KaspaLine : public QLineEdit  {
   Q_OBJECT
private:
	KaspaLine(const KaspaLine&);
	KaspaLine& operator=(const KaspaLine&);
public: 
	KaspaLine(QWidget *parent=0, const char *name=0);
	~KaspaLine();
	void keyPressEvent(QKeyEvent *e);
};

#endif




