#include <qmenudta.h>
#include <qpopmenu.h>
#include <qfile.h>
#include <qfileinf.h>
#include <qtextstream.h> 
#include <qlayout.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qtextview.h>
#include <qregexp.h>
#include <qkeycode.h>

#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kapp.h>
#include <klocale.h>
#include <kmenubar.h>

#include <fstream>
#include <iostream>
#include <string>

#include "sqlscript.h"
#include "my_sql.h"
#include "kmysqladmin/helpers/stringlist.h"
#include "stringres.h"
#include "scriptsplit.h"
#include "TextInput.h"
#include "kmysqladmin/setup/settings.h"

#define Inherited CSqlScriptData

using namespace std;

#ifndef rcs_id
static const char rcs_id[]="$Id: sqlscript.cpp,v 2.17 2003/02/09 17:54:35 ral Exp $";
#endif

CSqlScript::CSqlScript(smart_pointer<CMySql>& _sql_server,QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    //    QBoxLayout*MainLayout = Q_CHILD(this,QBoxLayout,"MainLayout");
    ResultText = "";
    ScriptText = "";
    ErrorText = "";
    search_text = "";
    m_FileName = "";
    modified = false;
    if (_sql_server)
        sql_server = new CMySql(*_sql_server);
    else
        sql_server = 0;
    status_Timer = NULL;
    if (sql_server)
        sql_server->set_message_call_back(this);
    CloseButton->setText(CStringRes::get_string(113));
    std::string desc = "&";
    desc+=CStringRes::get_string(132);
    SubmitButton->setText(desc.c_str());
    if (MainLayout) {
	MenuBar = new QMenuBar(this);
	CHECK_PTR(MenuBar);
	QPopupMenu*file = new QPopupMenu;
	CHECK_PTR(file);
        file->insertItem(GET_TEXT(135),this,SLOT(new_script()),CTRL+Key_N);
	file->insertItem(GET_TEXT(134),this,SLOT(load_script()),CTRL+Key_O);
	file->insertItem(GET_TEXT(133),this,SLOT(save_script()),CTRL+Key_S);
        file->insertItem(GET_TEXT(152),this,SLOT(save_script_as()));
	file->insertSeparator();
	file->insertItem(GET_TEXT(140),this,SLOT(saveResult()));
	file->insertSeparator();
	file->insertItem(GET_TEXT(113),this,SLOT(close_You()));
	MenuBar->insertItem(GET_TEXT(109),file);
	file = new QPopupMenu;
	file->insertItem(GET_TEXT(98),this,SLOT(searchText()),CTRL+Key_F);
	file->insertItem(GET_TEXT(141),this,SLOT(searchAgain()),Key_F3);
	QString text = "&";
	text+=GET_TEXT(142);
	MenuBar->insertItem(text,file);
	MainLayout->setMenuBar(MenuBar);
    }
    resultEdit->setReadOnly(true);
    errorEdit->setReadOnly(true);
    if (sql_server)
        sql_server->set_message_call_back(this);
    StatusText->setText(GET_TEXT(136));
    connect(&GlobalSettings,SIGNAL(fixfont_changed()),this,SLOT(FixFontChanged()));
    FixFontChanged();
    connect(resultEdit,SIGNAL(cursormove()),SLOT(set_cursor_info()));
    connect(errorEdit,SIGNAL(cursormove()),SLOT(set_cursor_info()));
    connect(scriptEdit,SIGNAL(cursormove()),SLOT(set_cursor_info()));
    TabSelected(0);
}

CSqlScript::~CSqlScript()
{
}

void CSqlScript::close_You()
{
    QDialog::hide();
}

void CSqlScript::TabSelected(int i)
{
    last_tab = i;
    switch (i) {
    case 0:
	SubmitButton->setEnabled(true);
	break;
    case 1:
	SubmitButton->setEnabled(false);
	break;
    case 2:
    default:
	SubmitButton->setEnabled(false);
	break;
    }
    set_cursor_info();
}

void CSqlScript::submit()
{
    if (!sql_server)
        return;
    ScriptText=scriptEdit->text();
    ResultText = "";
    ErrorText = "";
    TabBar->setCurrentPage(1);
    stringlist target,sizes,headers;
    stringlist commands;

    std::string _temp_result = "";
    StatusText->setText(GET_TEXT(139));
    KApplication::kApplication()->processEvents(100);

    split_commands(commands);
    if (commands.size() > 200) {
        resultEdit->setAutoUpdate(false);
    }
    bool had_errors = false;
    for (unsigned int i = 0; i < commands.size();++i) {
	target.resize(0);
	sizes.resize(0);
	headers.resize(0);
	int update_counter = 0;
	KApplication::kApplication()->processEvents(100);
	if (!sql_server->do_statement(commands[i].c_str(),target,sizes,headers,true)) {
	    had_errors = true;
	    break;
	}
	if (target.size()==0) {
	    _temp_result+="\n";
	}
	std::string _temp="";
	unsigned underline = 0;
	if (headers.size() > 0) {
	    _temp+="| ";
	    for (unsigned int j = 0;j < headers.size();++j) {
		_temp+=headers[j];
		if (j < headers.size()-1)
		    _temp+=" | ";
	    }
	    _temp+=" |"; underline = _temp.size();_temp+="\n";_temp_result += _temp;_temp="";
	    _temp.resize(underline,'-');_temp+="\n";_temp_result+=_temp;_temp_result.insert(0,_temp);
	    commands[i]+=":\n";_temp_result.insert(0,commands[i]);
	}
	if (target.size()>0) {
	    std::string t;
	    for (unsigned int j = 0;j < target.size();++j) {
		t = "| ";t+=target[j];
		size_t pos = t.find("\t");
		while (pos !=std::string::npos) {
		    t.insert(pos,1,' ');
		    ++pos;
		    t.replace(pos,1,"|");
		    t.insert(pos+1,1,' ');
		    pos = t.find("\t");
		}
		_temp_result+=t;_temp_result+=" |\n";_temp_result+=_temp;
	    }
	}
	if (ResultText.size()==0) {
	    resultEdit->setText(_temp_result.c_str());
	} else {
	    _temp_result+="\n";
	    resultEdit->append(_temp_result.c_str());
	    if (++update_counter == 500) {
		update_counter = 0;
		resultEdit->repaint();
		KApplication::kApplication()->processEvents(10);
	    }
	}
	ResultText+=_temp_result;
	_temp_result="";
    }
    if (commands.size() > 200) {
	resultEdit->setAutoUpdate(true);
	resultEdit->repaint();
    }
    errorEdit->setText(ErrorText.c_str());
    if (had_errors) {
	setStatusText(GET_TEXT(137),5000);
	TabBar->setCurrentPage(2);
    } else {
	setStatusText(GET_TEXT(138),3000);
    }
    ScriptText.resize(0);
}

void CSqlScript::split_commands(stringlist&target)
{
    target.resize(0);
    std::string _temp_str="";
    std::string _temp_str2 = ScriptText;
    CScriptSplit splitter(&target,&_temp_str2);
    splitter.convert();
}

void CSqlScript::save_string(std::string*contents,bool text_only)
{
    QString file_name;
    if (!text_only) 
	file_name = KFileDialog::getSaveFileName(0,"*.sql *.txt");
    else
	file_name = KFileDialog::getSaveFileName(0,"*.txt");
    QString message;
    QFileInfo finfo;
    int i;

    if (file_name.isEmpty())
	return;
    finfo.setFile(file_name);
    if (finfo.isDir()) {
        KMessageBox::error(this,GET_TEXT(84),GET_TEXT(83));
	return;
    }

    if (QFile::exists(file_name)) {
	message = CStringRes::get_string(85);
	message+="\n\n";
	message+=file_name;message+="\n\n";
	message+=GET_TEXT(86);
	message+="\n";
	i = KMessageBox::questionYesNo( this, GET_TEXT(87),
                                        message);
	if (i != KMessageBox::Yes )
	    return;

	if (!finfo.isWritable()) {
	    KMessageBox::error(this,GET_TEXT(88),GET_TEXT(83));
	    return;
	}
    }
    QFile outfile(file_name);
    outfile.open(IO_WriteOnly|IO_Truncate);
    if (!outfile.isOpen()) 
	return;
    QTextStream st(&outfile);
    st << contents->c_str();
    outfile.close();
}

void CSqlScript::load_script()
{
    QString file_name = KFileDialog::getOpenFileName(0,"*.sql *.txt");
    QFile ifs(file_name);
    if (!ifs.open(IO_ReadOnly) )
	return;
    ScriptText = "";
    m_FileName = file_name.latin1();
    QTextStream t(&ifs);
    while (!t.eof()) {
	ScriptText+=t.readLine();ScriptText+="\n";
    }
    ifs.close();
    TabBar->setCurrentPage(0);
    scriptEdit->setText(ScriptText.c_str());
}

void CSqlScript::new_script()
{
    ScriptText = "";
    ResultText = "";
    ErrorText = "";
    TabBar->setCurrentPage(0);
    scriptEdit->setText(ScriptText.c_str());
}

void CSqlScript::append_message(const std::string&message)
{
    ErrorText+="\n";
    ErrorText+=message;
}

void CSqlScript::append_message(const char*message)
{
    if (message && strlen(message)) {
	ErrorText+="\n";
	ErrorText+=message;
    }
}

void CSqlScript::setStatusText(const char*text,unsigned int timeout)
{
    unsigned int iTimer = timeout;
    if (iTimer == 0)
	iTimer = 2000;
    if (!status_Timer) {
	status_Timer = new QTimer(this);
	connect( status_Timer, SIGNAL(timeout()), SLOT(statusTimeout()) );
    }
    if (text && strlen(text)>0)
	StatusText->setText(text);
    status_Timer->start(iTimer,TRUE);
}

void CSqlScript::statusTimeout()
{
    StatusText->setText(GET_TEXT(136));
}

void CSqlScript::saveResult()
{
    TabBar->setCurrentPage(1);
    save_string(&ResultText,true);
}

void CSqlScript::searchText()
{
    CTextInput textdlg(this);
    QString title = GET_TEXT(125);
    title+=GET_TEXT(143);
    textdlg.setCaption(title);
    textdlg.set_label_text(GET_TEXT(144));
    if (textdlg.exec()) {
	title = textdlg.get_text();
	if (title.isEmpty()) {
	    return;
	}
	search_text = title;
	search_forward();
    }
}

void CSqlScript::searchAgain()
{
    if (search_text.size() == 0)
	return;
    search_forward();
}

void CSqlScript::search_forward()
{
    int i;
    CEdit * curEdit = currentWindow();
    if (!curEdit)
	return;
    if (curEdit->numLines() <=1)
	return;
    int current_line, current_pos;

    QRegExp reg(search_text.c_str(),FALSE);

    curEdit->getCursorPosition(&current_line,&current_pos);
    int pos,length;
    pos = 0;
    for (i = current_line; i < curEdit->numLines(); ++i) {
	std::string _search = curEdit->textLine(i).latin1();
	pos = reg.match(_search.c_str(),current_pos,&length);
	current_pos = 0;
	if (pos > -1)
	    break;
    }
    if (pos != -1) {
        curEdit->setCursorPosition(i,pos);
	curEdit->setCursorPosition(i,pos+search_text.size(),TRUE);
    }
    set_cursor_info();
}

void CSqlScript::keyPressEvent(QKeyEvent*e)
{
    CSqlScriptData::keyPressEvent(e);
    set_cursor_info();
}

void CSqlScript::set_cursor_info()
{
    int line,col;
    CEdit * curEdit = currentWindow();
    if (!curEdit)
	return;
    curEdit->getCursorPosition(&line,&col);
    QString text;
    text.sprintf("Line: %i Col: %i",line,col);
    CursorPosText->setText(text);
}

CEdit*CSqlScript::currentWindow()
{
    int i = TabBar->currentPageIndex();
    switch (i) {
    case 0:
	return scriptEdit;
	break;
    case 1:
	return resultEdit;
	break;
    case 2:
	return errorEdit;
	break;
    default:
	return 0;
    }
    return 0;
}

void CSqlScript::FixFontChanged()
{
    QFont font = GlobalSettings.get_fixed_font();
    resultEdit->setFont(font);
    errorEdit->setFont(font);
    scriptEdit->setFont(font);
}

void CSqlScript::save_script()
{
    if (m_FileName.size() < 1) {
        return save_script_as();
    }
    ScriptText = scriptEdit->text();
    ofstream outfile(m_FileName.c_str());
    if (!outfile) 
	return;
    outfile<<ScriptText.c_str();
    outfile.close();
    ScriptText.resize(0);
}

void CSqlScript::save_script_as()
{
    ScriptText = scriptEdit->text();
    QString file_name;
    QString message;
    QFileInfo finfo;
    int i;

    if (file_name.isEmpty())
	return;
    finfo.setFile(file_name);
    if (finfo.isDir()) {
        KMessageBox::error(this,GET_TEXT(84),GET_TEXT(83));
	return;
    }

    if (QFile::exists(file_name)) {
	message = CStringRes::get_string(85);
	message+="\n\n";
	message+=file_name;message+="\n\n";
	message+=GET_TEXT(86);
	message+="\n";
	i = KMessageBox::questionYesNo( this, GET_TEXT(87),
                                        message);
	if (i != KMessageBox::Yes )
	    return;

	if (!finfo.isWritable()) {
	    KMessageBox::error(this,GET_TEXT(88),GET_TEXT(83));
	    return;
	}
    }
    ofstream outfile(file_name.latin1());
    m_FileName = file_name.latin1();
    if (!outfile) 
	return;
    outfile << ScriptText.c_str();
    outfile.close();
    ScriptText.resize(0);
}
