// -*-Mode: C++;-*-

#ifndef CSqlScript_included
#define CSqlScript_included

#include <kmenubar.h>
#include "sqlscriptdata.h"
#include <string>
#include "kmysqladmin/helpers/stringlist.h"
#include "sendmessage.h"
#include "kstatusbar.h"
#include <qtimer.h>
#include "kmysqladmin/helpers/smart_pointer.h"
#include "edit.h"

class CMySql;

class CSqlScript : public CSqlScriptData, virtual public CSendMessage
{
    Q_OBJECT
public:
 
    CSqlScript(smart_pointer<CMySql>& _sql_server,QWidget* parent = NULL,const char* name = NULL );
    virtual ~CSqlScript();
    virtual void append_message(const char*text);
    virtual void append_message(const std::string&message);

protected slots:
    virtual void close_You();
    virtual void TabSelected(int);
    virtual void submit();
    virtual void save_script();
    virtual void save_script_as();
    virtual void load_script();
    virtual void new_script();
    virtual void statusTimeout();
    virtual void saveResult();
    virtual void searchText();
    virtual void searchAgain();
    void keyPressEvent ( QKeyEvent * e );
    void set_cursor_info();
    void FixFontChanged();

protected:
    std::string ResultText;
    std::string ScriptText;
    std::string ErrorText;
    std::string search_text;
    std::string m_FileName;
    
    bool modified; 
    void search_forward();
    smart_pointer<CMySql> sql_server;
    void split_commands(stringlist & target);
    void setStatusText(const char*text,unsigned int timeout=0);
    int last_tab;
    QMenuBar*MenuBar;
    QTimer*status_Timer;
    void save_string(std::string*contents,bool textonly);
    CEdit * currentWindow();
};
#endif // CSqlScript_included
