#include <kapp.h>
#include "MainWindow.h"
#include "Login.h"
#include "createtable.h"
#include "TextInput.h"
#include "tableview.h"
#include "StatusView.h"
#include "granttable.h"
#include "my_sql.h"
#include "ThreadView.h"
#include "globals.h"
#include "deltabledlg.h"
#include <qmsgbox.h>
#include "altertable.h"
#include "changetablename.h"
#include "stringres.h"
#include <kmessagebox.h>
#include <klocale.h>
#include "sqlscript.h"
#include "kmysqladmin/setup/settings.h"
#include "kglobal.h"
#include "kconfig.h"
#include "qtextview.h"
#include <iostream>

using namespace std;

#ifndef rcsid
static const char rcsid[]="$Id: MainWindow.cpp,v 2.27 2003/02/04 00:08:53 ral Exp $";
//const char*mainwindow_rcs(){return rcsid;}
#endif

#define Inherited CMainWindowData

CMainWindow::CMainWindow( QWidget* parent, const char* name )
    :Inherited( parent, name )
{
    TableView = 0;
    StatusView = 0;
    ThreadView = 0;
    sql_server = 0;
    Grants = 0;
    sql_script = 0;
    msg_ptr = 0;
}

CMainWindow::~CMainWindow()
{
    if (sql_server && sql_server->success_connect()) {
	GlobalSettings.SaveLastLogin(sql_server->User(),sql_server->Host(),
				     sql_server->Port(),sql_server->Pass());
    }
}

void CMainWindow::connectSql()
{
    CLogin login;
    QString host;
    QString User;
    QString pass;
    QString port;
    if (login.exec()) {
	host = login.get_host();
	User = login.get_user();
	pass = login.get_pass();
	port = login.get_port();
	_connect(login.get_user(),login.get_host(),
		 login.get_port(),login.get_pass());
    }
}

bool CMainWindow::connected()
{
    return ( sql_server && sql_server->success_connect());
}

void CMainWindow::disconnectSql()
{
    if (!sql_server)
	return;
    if (sql_server && sql_server->success_connect()) {
	GlobalSettings.SaveLastLogin(sql_server->User(),sql_server->Host(),
				     sql_server->Port(),sql_server->Pass());
    }
    sql_server->sql_disconnect();
    append_message("Disconnected");
    CloseAllDialogs();
    emit disconnected();
}

void CMainWindow::browseTables()
{
    if (!TableView) {
	TableView = new CTableView(sql_server,0,"TableView");
    }
    if (!TableView->isVisible()) {
	TableView->show();
    }
}

void CMainWindow::append_message(const char*text)
{
    if (!text)
	return;
    OutputArea->append(text);
    //    OutputArea->setCursorPosition(OutputArea->numLines(),0);
}

void CMainWindow::createTable()
{
    if (!sql_server)
	return;
    CCreateTable tablec(sql_server,0);
    tablec.exec();
}

void CMainWindow::alterTable()
{
    if (!sql_server)
	return;
    CAlterTable tablec(sql_server,0);
    tablec.exec();
}

void CMainWindow::createDB()
{
    int i;
    QString s;
    CTextInput input;
    i = input.exec();
    if (!i)
	return;
    s = input.get_text();
    if (s.isEmpty())
	return;
    i = sql_server->create_db(input.get_text());
}

void CMainWindow::dispStatus()
{
    if (!StatusView)
	StatusView = new CStatusView(sql_server,0,"StatusView");
    if (!StatusView->isVisible())
	StatusView->show();
}

void CMainWindow::view_threads()
{
    if (!sql_server || !sql_server->success_connect())
        return;
    if (!ThreadView)
	ThreadView = new CThreadView(sql_server,0,"ThreadView");
    if (!ThreadView->isVisible())
        ThreadView->show();
}

void CMainWindow::clearOutput()
{
    OutputArea->setText("");
    // OutputArea->clear();
}

void CMainWindow::accessControl()
{
    if (!Grants)
	Grants = new CGrantTable(sql_server);
    if (!Grants->isVisible())
	Grants->show();
}

void CMainWindow::reload_grants()
{
    if (sql_server)
	sql_server->refresh_grants();
}

void CMainWindow::flush_cache()
{
    if (sql_server)
	sql_server->refresh_cache();
}

void CMainWindow::close_tables()
{
    if (sql_server)
	sql_server->refresh_tables();
}

void CMainWindow::new_log()
{
    if (sql_server)
	sql_server->refresh_log();
}

void CMainWindow::shutdown()
{
    int i;
    i = KMessageBox::questionYesNo(this,CStringRes::get_string(56),
                                   CStringRes::get_string(130));//,
    //		   KMsgBox::DB_SECOND|KMsgBox::QUESTION,
    //	   CStringRes::get_string(16),CStringRes::get_string(17));
    if (i != KMessageBox::Yes) 
	return;
    if (sql_server) {
	i = sql_server->shutdown();
	if (i < 0)
	    return;
	disconnectSql();
    }
}

void CMainWindow::drop_table()
{
    int i = 0;
    CDeleteTableDlg drop_table_dlg(sql_server,0,"Delete Table");
    i = drop_table_dlg.exec();
}

void CMainWindow::drop_db()
{
}

void CMainWindow::set_msg_ptr(CSendMessage*ptr)
{
    msg_ptr = ptr;
    if (sql_server)
	sql_server->set_message_call_back(ptr);
}

void CMainWindow::rename_table()
{
    if (!sql_server || !sql_server->success_connect())
        return;
    CChangeTableName dlg(sql_server,0);
    dlg.exec();
}

void CMainWindow::sql_Edit()
{
    if (!sql_server)
        return;
    if (!sql_server->success_connect())
        return;
    if (!sql_script) {
	sql_script = new CSqlScript(sql_server,0,"SQL_Editor");
    }
    if (!sql_script->isVisible()) 
	sql_script->show();
}

bool CMainWindow::close()
{
    CloseAllDialogs();
    return CMainWindowData::close();
}

void CMainWindow::CloseAllDialogs()
{
    if (TableView) {
	TableView->close(true);
	//delete TableView;
        TableView = 0;
    }
    if (StatusView) {
	StatusView->close(true);
	//delete StatusView;
	StatusView = 0;
    }
    if (ThreadView) {
	ThreadView->close(true);
	//delete ThreadView;
	ThreadView = 0;
    }
    if (Grants) {
	Grants->close(true);
        //	delete Grants;
	Grants = 0;
    }
    if (sql_script) {
	sql_script->close(true);
	//delete sql_script;
	sql_script = 0;
    }
}

void CMainWindow::RestoreLastConnect()
{
    string user,host,port,pass;
    GlobalSettings.RetrieveLastLogin(user,host,port,pass);
    _connect(user,host,port,pass);
}

void CMainWindow::_connect(const std::string&user,const std::string&host,
			   const std::string&port,const std::string&pass)
{
    if (!sql_server)
	sql_server = new CMySql;
    if (!sql_server)
	return;
    sql_server->set_message_call_back(msg_ptr);
    if (StatusView) {
	delete StatusView;StatusView = 0L;
    }
    if (TableView) {
	delete TableView;TableView = 0L;
    }
    if (ThreadView) {
        delete ThreadView;ThreadView = 0L;
    }
    if (Grants) {
	delete Grants;Grants = 0;
    }
    KConfig * k = KGlobal::config();
    k->setGroup("last_login");
    k->writeEntry("user",user.c_str());
    k->writeEntry("host",host.c_str());
    k->writeEntry("port",port.c_str());
    sql_server->sql_connect(host,user,pass,port);
    if (sql_server->success_connect()) {
	string head=user;
	head+="@";
	if (host.size()==0) {
	    head+= "localhost";
	} else {
	    head+=host;
	}
	emit connected(head.c_str());
	append_message(sql_server->get_info().c_str());
    } else {
	QString msg = CStringRes::get_string(61);
	msg+="\n";
	msg+=CStringRes::get_string(62);
	QMessageBox::critical(this,
			      CStringRes::get_string(63),
			      msg);
	emit disconnected();

    }
}
