#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <fstream>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <string>
#include "helpers.h"

#ifndef _WIN32
#include <unistd.h>
#include "qfont.h"
#endif
#include <iostream>

#include <fstream>

using namespace std;

#ifndef rcsid
static const char rcsid[]="$Id: helpers.cpp,v 2.8 2003/02/12 16:52:20 ral Exp $";
#endif



int copy_datei(const char*source, const char*target,bool lock_it)
{
    std::string lockfile;
    if (lock_it) {
        lockfile = target;
        lockfile+=".LOCK";
        std::ofstream l(lockfile.c_str(),std::ios::in);
        if (l) l << getpid();
    }
    std::ifstream s(source,std::ios::in);
    if (!s) {
        if (lock_it)unlink(lockfile.c_str());
        return -1;
    }
    std::ofstream d(target,ios::out | ios::trunc);
    if (!d) {
        if (lock_it)unlink(lockfile.c_str());
        cout << "Copy file, open output failed" << endl;
        return -1;
    }
    for (char Byte=s.get(); Byte != EOF; Byte=s.get())
        if (!d.put(Byte))
            return -1;
    if (lock_it)unlink(lockfile.c_str());
    return 0;
}

int move_file(const char*source, const char*target,bool lock_it)
{
    if (copy_datei(source,target,lock_it) == -1)
        return -1;
    unlink(source);
    return 0;
}

int select_file(const std::string & aFile)
{
    struct stat buf;
    int n = stat(aFile.c_str(),&buf);
    if (n < 0)
        return 0;
    if (S_ISREG(buf.st_mode) && !S_ISDIR(buf.st_mode) ) {
        return 1;
    }
    return 0;
}

int get_dir_files(const std::string&directory,vector<string>&target,bool check_lock)
{
    target.resize(0);
    if (directory.size()==0)
        return -1;
    struct dirent **namelist;
    int n;

    n = scandir(directory.c_str(), &namelist, 0, alphasort);
    if (n < 1)
        return 0;
    string _d = directory;
    if (_d[_d.size()-1]!='/')
        _d+="/";
    string complete;
    while(n--) {
        complete = _d;
        complete += string(namelist[n]->d_name);
        if (select_file(complete)) {
            if (!check_lock || !is_locked(_d,namelist[n]->d_name))
                target.push_back(complete);
        }
        free(namelist[n]);
    }
    free(namelist);
    return target.size();
}

int is_locked(const std::string&directory,const std::string&file_name)
{
    if (file_name.size()==0) 
        return 1;
    if (file_name.rfind(".LOCK")!=string::npos)
        return 1;
    string whole = directory;
    whole+=file_name;whole+=".LOCK";
    struct stat buf;
    int n = stat(whole.c_str(),&buf);
    if (n == 0 && S_ISREG(buf.st_mode) && !S_ISDIR(buf.st_mode) ) {
        return 1;
    }
    return 0;
}

#ifndef _WIN32
void FontToParameter(const QFont&fnt,std::string&name,int&size,int&weight,
		     bool&italic)
{
    name = fnt.family();
    size = fnt.pointSize();
    weight = fnt.weight();
    italic = fnt.italic();
}

void ParameterToFont(QFont&fnt,const std::string name,int size, int weight, bool italic)
{
    fnt = QFont(name.c_str(),size,weight,italic);
}
#endif
