#include "sqlite-plugin.h"
#include <sqlite.h>


extern "C" {
int countAffected(void *pArg, int , char **, char **);
}

//This is just a helper function
//TODO: right now, in a multithreaded app, there can be
//a race condition because two querys could modify affected
//that is a global int. I have no idea on how to fix that
int affected;
int countAffected(void *pArg, int , char **, char **)
{
	qDebug ("countaffected");
	affected=*((int *)pArg);
	return 0;
}




SqliteDriver::SqliteDriver (QObject * parent, const char *name): QSqlDriver(parent,name)
{
}
bool SqliteDriver::open ( const QString & db, const QString &,
		const QString &, const QString &, int)
{
	char *errmsg=0;
	bool ok=false;
	_db=sqlite_open(db.latin1(),0,&errmsg);
	if (db) //no error
	{
		if (SQLITE_OK==sqlite_exec(_db,"PRAGMA empty_result_callbacks = ON;",
					NULL,NULL,NULL))
		{
			if (SQLITE_OK==sqlite_exec(_db,"PRAGMA count_changes = ON;",
						countAffected,NULL,NULL))
			{
				ok=true;
			}
		}
				
	}
	if (!ok)
	{
		setOpen (false);
		setOpenError(true);
		setLastError(QSqlError(errmsg,QString::null,QSqlError::Unknown));
		return false;
	}
	else
	{
		setOpen (true);
		setOpenError(false);
		return true;
	}
}

void SqliteDriver::close ()
{
	if (_db)
		sqlite_close(_db);
}

bool SqliteDriver::hasFeature ( QSqlDriver::DriverFeature ) const
{
	return TRUE; 
	//Oh, well, it probably should refuse to take blobs,
	//since they make the thing slow as molasses, but
	//it DOES do blobs, since it's frigging typeless ;-)
}

bool SqliteDriver::beginTransaction ()
{
	int err=sqlite_exec(_db,"BEGIN TRANSACTION;",NULL,NULL,NULL);
	if (SQLITE_OK==err)
		return true;
	else
		return false;
}
bool SqliteDriver::commitTransaction ()
{
	int err=sqlite_exec(_db,"COMMIT TRANSACTION;",NULL,NULL,NULL);
	if (SQLITE_OK==err)
		return true;
	else
		return false;
}
bool SqliteDriver::rollbackTransaction ()
{
	int err=sqlite_exec(_db,"ROLLBACK TRANSACTION;",NULL,NULL,NULL);
	if (SQLITE_OK==err)
		return true;
	else
		return false;
}


QSqlQuery SqliteDriver::createQuery () const
{
	qDebug ("sqlitedriver::createquery");
	return QSqlQuery(new SqliteResult(this));
}

QSqlRecord SqliteDriver::record ( const QString & tableName ) const
{
	qDebug ("sqlitedriver::record tablename=%s",tableName.latin1());
	return recordInfo(tableName).toRecord();
}

QSqlRecordInfo SqliteDriver::recordInfo ( const QString & tablename ) const
{
	qDebug ("SqliteDriver::recordInfo tablename=%s",tablename.latin1());
	QSqlFieldInfoList l;

        char **res;
	char *err;
	int r,c;
	QString query;
	query="PRAGMA table_info("+tablename+");";

	if (SQLITE_OK == sqlite_get_table (_db,query,&res,&r,&c,&err))
	{
		qDebug ("got record info for  %d columns",r);
		for (int i=1;i<=r;i++)
		{
			QString cname=res[i*c+1];
			QVariant::Type t;
			QVariant defval;
			
			QString t1=res[i*c+2];
			//Check for integers
			if ((t1.find ("int")==0) ||
			    (t1.find ("tinyint")==0) ||
			    (t1.find ("bit")==0) ||
			    (t1.find ("bool")==0) ||
			    (t1.find ("smallint")==0) ||
			    (t1.find ("mediumint")==0) ||
			    (t1.find ("integer")==0) ||
			    (t1.find ("bigint")==0))
			     
			{
				t=QVariant::Int;
			}
			else if ((t1.find ("float")==0) ||
				 (t1.find ("double")==0) ||
				 (t1.find ("real")==0) ||
				 (t1.find ("dec")==0) ||
				 (t1.find ("numeric")==0))
			{
				t=QVariant::Double;
			} //TODO The date/time types are broken
			else if ((t1.find ("datetime")==0) ||
				 (t1.find ("time")==0) ||
				 (t1.find ("date")==0))
			{
				t=QVariant::DateTime;
			}
			else
			{
				t=QVariant::String;
			}

			defval=QString(res[i*c+3]);
			defval.cast(t);
						
			qDebug ("adding info for column %d: %s, %s",
					i,cname.latin1(),QVariant::typeToName(t));
			l << QSqlFieldInfo (cname,t,-1,-1,-1,defval);
		}
	}

	return QSqlRecordInfo (l);
}

//TODO clean this and make it simpler
QStringList SqliteDriver::tables( const QString& ) const
{
	qDebug ("Getting list of tables");
	char **res;
	int ntab,ncol;
	QStringList r;
	int err=sqlite_get_table (_db,"SELECT name FROM sqlite_master WHERE type='table' ORDER BY name;", &res,&ntab,&ncol,NULL);
	if (SQLITE_OK == err)
	{
		for (int i=0 ;;i++)
		{
			if (i>=ntab)
				break;
			r << res[0];
		}
	}
	else
	{
		qDebug ("could not get list of tables: %d",err);
	}
	return r;
}


SqliteResult::SqliteResult (const QSqlDriver *db): QSqlResult(db)
{
	_db=(SqliteDriver *) (db);
	nrows=0;
	ncols=0;
	affected=0;
}


void SqliteResult::setQuery ( const QString &query )
{
	qDebug ("sqliteresult::setquery: %s",query.latin1());
	q=query.stripWhiteSpace()+";";
	if (query.find("select",0,false)==0)
		setSelect(true);
	else
		setSelect(false);
}

bool SqliteResult::reset ( const  QString &query )
{
	qDebug ("sqliteresult::reset query: %s",query.latin1());
	setQuery(query);
	char *errmsg=0;
	if (SQLITE_OK == sqlite_get_table (_db->_db,q.latin1(),&results,&nrows,&ncols,&errmsg))
	{
		affected=::affected;
		qDebug ("affected %d rows",affected);
		qDebug ("got %d results for this query",nrows);
		if (nrows >0)
		{
			setActive(true);
		}
		else
		{
			qDebug ("got no results");
			setActive(false);
		}
		//This below here dumps all data returned
	/*
		for (int i=0;i<nrows;i++)
		{
			for (int j=0;j<ncols;j++)
			{
				printf ("%d:%d:%s , ",i,j,results[i*ncols+j]);
			}
			printf ("\n");
		}
		*/
		return true;
	}
	else
	{
		qDebug ("error making query in reset()");
		setActive(false);
		return false;
	}
}

bool SqliteResult::fetch (int i)
{
	if (i<nrows)
	{
		setAt(i);
		return true;
	}
	else
	{
		return false;
	}
}

QVariant SqliteResult::data (int i)
{
	return QVariant(results[(at()+1)*ncols+i]);
}

bool SqliteResult::isNull (int i)
{
	if (results[at()][i]==0)
		return true;
	else
		return false;
}

int SqliteResult::numRowsAffected ()
{
	return affected;
}

