/*
 *
 *  Kepas - KDE Easy Publish and Share
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kepas.
 *
 *  kepas is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kepas is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kepas; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

#ifndef BUDDYLIST_H
#define BUDDYLIST_H

#include <QMainWindow>
#include <QtGui>
#include <QtNetwork>
#include <QtDBus>
#include <kconfig.h>



#include "ui_buddylist.h"
#include "sender.h"
#include "requestClipboard.h"
#include "buddycontent.h"



class KDE_EXPORT BuddyList : public QMainWindow,
		 	  private Ui_BuddyList
{
Q_OBJECT


public:

	 BuddyList(QObject* parent = 0);
	 ~BuddyList(); 

	 void initDefaultBuddyList(QString name);
	 void initSendClipBuddyList(QString clipEntry, QString name);
	 void initSendFileBuddyList(QString file, QString name);

	
	 QVBoxLayout* buddyLayout;
	 QListWidgetItem* buddy;

private:
	
	 QObject* m_parent;
	 KConfig* m_config;	
	 int count;

	 QMenu* popupMenu;
	 QMenu* sendClipMenu;
	 QAction* sendFileAction;
	 QAction* sendDirAction;
	 QAction* getClipAction;
	 QAction* clipAction;

	 QListWidgetItem* buddyItemOld;

	 Sender* sendHandler;
	 RequestClipboard* getClipHandler;

	 QVector<BuddyContent*>* buddyVector;
	 BuddyContent* newBuddyContent;
	 BuddyContent* tmpBuddyContent;

	 QString m_fileName;
	 QString m_clipEntry;

	 QString m_userName;
	 QString icqID;
	
	 QDBusConnection* dbus;


	 void addClipEntries();
	 void checkICQStatus();
	 QString getContactName(QString);
	 bool isOnline(QString);

	 QListWidget* buddyListWidget;
	 QListWidget* icqListWidget;


public slots:
	 void addService(QMap<QString, QByteArray>);
	 void delService(QString);
	 void slotSendFile(bool);
	 void slotSendClip(QListWidgetItem*);
	 void slotSendFileDirect(QListWidgetItem*);
	 void slotSendFileDirectICQ(QListWidgetItem*);
	 void slotSendDir(bool);
	 void slotGetClip(bool);
	 void slotItemEntered(QListWidgetItem* buddyItem);
	 void slotPopupMenu(QListWidgetItem* buddyItem);
	 void slotItemSelectionChanged();
	 void slotSendClipEntry(QAction* action);
	 void slotSendFinished();
	 void fillIcqTab();
	 void slotPopupKopeteMenu(QListWidgetItem*);

};

#endif
