// Copyright (C) 2008, 2009, 2010 EPITA Research and Development
// Laboratory (LRDE)
//
// This file is part of Olena.
//
// Olena is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, version 2 of the License.
//
// Olena is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Olena.  If not, see <http://www.gnu.org/licenses/>.
//
// As a special exception, you may use this file as part of a free
// software project without restriction.  Specifically, if other files
// instantiate templates or use macros or inline functions from this
// file, or you compile this file and link it with other files to produce
// an executable, this file does not by itself cause the resulting
// executable to be covered by the GNU General Public License.  This
// exception does not however invalidate any other reasons why the
// executable file might be covered by the GNU General Public License.

#ifndef MLN_IO_FLD_WRITE_HEADER_HH
# define  MLN_IO_FLD_WRITE_HEADER_HH

/// \file
/// \brief Write AVS headers in a file.

# include <cstdlib>

# include <iostream>

# include <mln/io/fld/header.hh>

namespace mln
{

  namespace io
  {

    namespace fld
    {
      /// Write the AVS header in a file.
      ///
      /// \param file The file to write.
      /// \param h The AVS header.
      ///
      void write_header(std::ostream& file, const fld_header& h);

# ifndef MLN_INCLUDE_ONLY

      inline
      void
      write_header(std::ostream& file, const fld_header& h)
      {
	file << "# AVS field file" << std::endl;
	file << "# Generated by Milena 1.0  http://olena.lrde.epita.fr" << std::endl;
	file << "# EPITA Research and Development Laboratory (LRDE)" << std::endl;

	file << "ndim=" << h.ndim << std::endl;
	for (int i = 0; i < h.ndim; i++)
	  file << "dim" << (i + 1) << "=" << h.dim[i] << std::endl;
	file << "nspace=" << h.nspace << std::endl
	     << "veclen=" << h.veclen << std::endl;

	switch (h.data)
	  {
	    case data_type::BYTE :
	      file << "data=byte" << std::endl;
	      break;
	    case data_type::SHORT :
	      file << "data=short" << std::endl;
	      break;
	    case data_type::INTEGER :
	      file << "data=integer" << std::endl;
	      break;
	    case data_type::FLOAT :
	      file << "data=float" << std::endl;
	      break;
	    case data_type::DOUBLE :
	      file << "data=double" << std::endl;
	      break;
	    default:
	      std::cerr << "Data type not supported: abort().";
	      std::abort();
	  }

	switch (h.field)
	  {
	    case field_type::UNIFORM :
	      file << "field=uniform" << std::endl;
	      break;
	    case field_type::IRREGULAR :
	      file << "field=irregular" << std::endl;
	      break;
	    case field_type::RECTILINEAR :
	      file << "field=rectilinear" << std::endl;
	      break;
	    default:
	      std::cerr << "Field type not suported: abort().";
	      std::abort();
	  }

	file << "min_ext=";
	for (int i = 0; i < h.nspace; i++)
	  file << h.min_ext[i] << " ";
	file << std::endl;

	file << "max_ext=";
	for (int i = 0; i < h.nspace; i++)
	  file << h.max_ext[i] << " ";
	file << std::endl;

	file << "\f\f";
      }

#endif // !MLN_INCLUDE_ONLY

    }  // end of namespace mln::io::fld

  } // end of namespace mln::io

} // end of namespace mln

#endif // !MLN_IO_FLD_WRITE_HEADER_HH
