/*
    SPDX-FileCopyrightText: 2007 John Tapsell <tapsell@kde.org>

    SPDX-License-Identifier: LGPL-2.0-only
*/

#pragma once

#include <Plasma5Support/DataEngine>

#include <ksgrd/SensorClient.h>

#include <QList>
#include <QStringList>

class QTimer;

/**
 * This class evaluates the basic expressions given in the interface.
 */
class SystemMonitorEngine : public Plasma5Support::DataEngine, public KSGRD::SensorClient
{
    Q_OBJECT

public:
    /** Inherited from Plasma5Support::DataEngine.  Returns a list of all the sensors that ksysguardd knows about. */
    QStringList sources() const override;
    SystemMonitorEngine(QObject *parent);
    ~SystemMonitorEngine() override;

protected:
    bool sourceRequestEvent(const QString &name) override;
    /** inherited from SensorClient */
    void answerReceived(int id, const QList<QByteArray> &answer) override;
    void sensorLost(int) override;
    bool updateSourceEvent(const QString &sensorName) override;

protected Q_SLOTS:
    void updateSensors();
    void updateMonitorsList();

private:
    QList<QString> m_sensors;
    QTimer *m_timer;
    int m_waitingFor;
};
