#ifndef __mditoplevel_h__
#define __mditoplevel_h__

#include <qptrlist.h>
#include <qtabwidget.h>

#include <kmainwindow.h>

class QLabel;

class MDITopLevel : public KMainWindow
{
    Q_OBJECT
public:
    MDITopLevel();
    virtual ~MDITopLevel();

    void addWidget( QWidget *widget, bool show );

    void removeWidget( QWidget *widget );

    QTabWidget *tabWidget() const { return m_tab; }
	void next();
	void previous();

    QPtrList<QWidget> &widgets() { return m_tabWidgets; }

    virtual bool eventFilter( QObject *obj, QEvent *ev );
    bool closing() const { return m_closing; }

protected:
    void removeFromAddressedList( const QWidget* w );
    virtual void closeEvent( QCloseEvent *ev );

private slots:
    void slotWidgetDestroyed();
    void slotCurrentChanged( QWidget *page );
    void slotMarkPageDirty( bool );
    void slotChangeChannelName( const QString &, const QString &newName );

private:
    QTabWidget *m_tab;
    QPtrList<QWidget> m_tabWidgets;
    QPtrList<QWidget> m_addressed;
    QPixmap m_dirtyIcon;
    QPixmap m_addressedIcon;
    bool m_closing;
};

#endif
