<?php
// $Horde: imp/config/prefs.php.dist,v 1.176 2003/08/20 20:03:58 jan Exp $

// Make sure that constants are defined.
@define('IMP_BASE', dirname(__FILE__) . '/..');
require_once IMP_BASE . '/lib/IMP.php';

// Changes you make to this file will not be reflected until the user
// logs out and logs in again.
//
// $prefGroups are for display purposes when you press the options button.
// The options choice will appear when you set your preferences driver
// in the horde/config/conf.php file.
// $prefGroups array definition:
//   column: What column head this group will go under
//    label: Label for the group of settings
//     desc: Description that will show under label
//  members: list of preferences supported by this group
//
// The $_prefs array's are listed in the same order as listed in the
// members element of $prefGroups

$prefGroups['personal'] = array(
    'column' => _("Your Information"),
    'label' => _("Personal Information"),
    'desc' => _("Change the name, address, and signature that people see when they read and reply to your email."),
    'members' => array('identityselect', 'default_identity', 'identity'));

$prefGroups['server'] = array(
    'column' => _("Your Information"),
    'label' => _("Server Information"),
    'desc' => _("Change mail server settings."),
    'members' => array('subscribe'));

$prefGroups['language'] = array(
    'column' => _("Your Information"),
    'label' => _("Language"),
    'desc' => _("Set the language that menu items, explanations, and help are in."),
    'members' => array('language'));

$prefGroups['timezone'] = array(
    'column' => _("Your Information"),
    'label' => _("Time Zone"),
    'desc' => _("Set the current time zone."),
    'members' => array('timezone'));

if (!empty($GLOBALS['conf']['mailbox']['show_preview'])) {
    $prefGroups['mailpreview'] = array(
        'column' => _("Your Information"),
        'label' => _("Mail Previews"),
        'desc' => _("Configure mail preview options."),
        'members' => array('preview_enabled', 'preview_maxlen', 'preview_strip_nl', 'preview_show_unread', 'preview_show_tooltip'));
}

$prefGroups['filters'] = array(
    'column' => _("Mail Management"),
    'label' => _("Filters"),
    'desc' => _("Create filtering rules to organize your incoming mail, sort it into folders, and delete spam."),
    'url' => 'filterprefs.php');

$prefGroups['viewing'] = array(
    'column' => _("Mail Management"),
    'label' => _("Message Viewing"),
    'desc' => _("Set preferences for filtering messages for unwanted content."),
    'members' => array('filtering', 'strip_attachments',
                       'delete_spam_after_report', 'html_image_replacement',
                       'html_image_addrbook', 'highlight_text', 'highlight_simple_markup',
                       'dim_signature', 'attachment_display'));

$prefGroups['delmove'] = array(
    'column' => _("Mail Management"),
    'label' => _("Deleting and Moving Messages"),
    'desc' => _("Set preferences for what happens when you move and delete messages."),
    'members' => array('mailbox_return', 'use_trash', 'trashselect',
                       'empty_trash_menu'));

$prefGroups['monthlytasks'] = array(
    'column' => _("Mail Management"),
    'label' => _("Maintenance Operations"),
    'desc' => sprintf(_("Customize maintenance operations run upon login to %s."),
                      $GLOBALS['registry']->getParam('name')),
    'members' => array('do_maintenance', 'confirm_maintenance',
                       'rename_sentmail_monthly', 'delete_sentmail_monthly',
                       'delete_sentmail_monthly_keep', 'purge_trash',
                       'purge_trash_interval', 'purge_trash_keep'));

$prefGroups['fetchmail'] = array(
    'column' => _("Mail Management"),
    'label' => _("Fetch Mail"),
    'desc' => _("Customize accounts for fetching mail from other POP3/IMAP accounts."),
    'members' => array('fetchmail_link', 'fetchmail_popup', 'fetchmail_menu'));

if (isset($_SESSION['imp']['acl'])) {
    $prefGroups['acl'] = array(
        'column' => _("Mail Management"),
        'label' => _("Share Folders"),
        'desc' => _("Share your mail folders with other users."),
        'url' => 'acl.php');
}

$prefGroups['display'] = array(
    'column' => _("Other Options"),
    'label' => _("Display Options"),
    'desc' => _("Change display options such as how many messages you see on each page and how messages are sorted."),
    'members' => array('mailbox_start', 'sortby', 'sortdir', 'max_msgs',
                       'num_words', 'max_from_chars', 'max_subj_chars',
                       'from_link', 'date_format', 'time_format',
                       'nav_expanded', 'show_legend'));

$prefGroups['compose'] = array(
    'column' => _("Other Options"),
    'label' => _("Message Composition"),
    'desc' => _("Customize how you send mail and where drafts are saved."),
    'members' => array('compose_popup', 'wrap_width', 'compose_html', 'compose_confirm',
                       'reply_quote', 'reply_headers', 'quote_prefix', 'attrib_text',
                       'folderselect', 'close_draft', 'unseen_drafts', 'set_priority',
                       'sending_charset', 'encryptselect', 'self_bcc'));

if (!empty($GLOBALS['conf']['compose']['allow_receipts'])) {
    $prefGroups['disposition_notifications'] = array(
        'column' => _("Other Options"),
        'label' => _("Mail Disposition Notification"),
        'desc' => _("Configure options for message disposition notifications."),
        'members' => array('disposition_request_read', 'disposition_request_delivery'));
}

$prefGroups['logintasks'] = array(
    'column' => _("Other Options"),
    'label' => _("Login Tasks"),
    'desc' => sprintf(_("Customize tasks to run upon logon to %s."), $GLOBALS['registry']->getParam('name')),
    'members' => array('initialpageselect'));

$prefGroups['newmail'] = array(
    'column' => _("Other Options"),
    'label' => _("New Mail"),
    'desc' => _("Control when new mail will be checked for, and whether or not to notify you when it arrives."),
    'members' => array('refresh_time', 'nav_popup'));

$prefGroups['addressbooks'] = array(
    'column' => _("Other Options"),
    'label' => _("Address Books"),
    'desc' => _("Select address book sources for adding and searching for addresses."),
    'members' => array('auto_expand', 'display_contact', 'sourceselect'));

$prefGroups['pgp'] = array(
    'column' => _("Other Options"),
    'label' => _("PGP Options"),
    'desc' => sprintf(_("Control PGP support for %s."), $GLOBALS['registry']->getParam('name')),
    'url' => 'pgp.php');

if (extension_loaded('openssl')) {
    $prefGroups['smime'] = array(
        'column' => _("Other Options"),
        'label' => _("S/MIME Options"),
        'desc' => sprintf(_("Control S/MIME support for %s."), $GLOBALS['registry']->getParam('name')),
        'url' => 'smime.php');
}

// If you change these preferences in a production system, you will need
// to delete any horde_prefs in your preferences database
//
// Descpription of the $_prefs arrays:
// value:  This entry will either hold a number or a text value based on the
//         preference type:
//      implicit:  See Preference type
//          text:  Text value
//        number:  Number value
//      checkbox:  Value should be 0 for unchecked, 1 for checked
//        select:  Value associated with that selection list
//
// locked: Allow preference to be changed from UI
//          true:  Do not show this preference in the UI
//         false:  Show this preference in the UI and allow changing
//
// shared: Share with other horde apps
//          true:  Share this pref with other Horde apps
//         false:  Keep this pref local to IMP
//
//   type: Preference type
//       special:  Provides a UI widget
//        select:  Provides a selection list in the UI
//      checkbox:  Provides a checkbox
//      implicit:  Provides storage for 'special' types
//          enum:  Use static list of elements...similar to 'select'
//
//   enum: Static list of elements.
//


// Personal Information preferences

// default identity selection widget
$_prefs['identityselect'] = array('type' => 'special');

// default identity
// Set locked to true if you don't want the users to have multiple identities.
$_prefs['default_identity'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// link to the identities ui
$_prefs['identity'] = array(
    'type' => 'link',
    'url' => 'identities.php',
    'img' => 'personal.gif',
    'desc' => _("Edit your identities"));

// identities array
// Don't change anything here.
$_prefs['identities'] = array(
    'value' => 'a:0:{}',
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// user signature
$_prefs['signature'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// precede the signature with dashes ('-- ')?
$_prefs['sig_dashes'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// signature before replies and forwards?
$_prefs['sig_first'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// user full name for From: line
$_prefs['fullname'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// user preferred email address for From: line
$_prefs['from_addr'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// user preferred email address for Reply-To:, if different from From:
$_prefs['replyto_addr'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// user preferred alias addresses
$_prefs['alias_addr'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// user preferred 'tie to' addresses
$_prefs['tieto_addr'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// save a copy of sent messages?
// a value of 0 = no, 1 = yes
$_prefs['save_sent_mail'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// sent mail folder
$_prefs['sent_mail_folder'] = array(
    'value' => 'sent-mail',
// For Exchange server uncomment the line below and delete the line above
//    'value' => 'Sent Items',
    'locked' => false,
    'shared' => true,
    'type' => 'implicit');

// End Personal Information preferences


// Server Information preferences

// use IMAP subscribe?
// value of 0 = no, 1 = yes
$_prefs['subscribe'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Use IMAP folder subscriptions?"));

// End Server Information preferences


// Language Functions

// user language
// valid values can be found in horde/config/lang.php

$_prefs['language'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'select',
    'desc' => _("Select your preferred language:"));

// End Language Functions


// Time Zone Functions

// user time zone
// valid values can be found in horde/config/lang.php

$_prefs['timezone'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'select',
    'desc' => _("Your current time zone:"));

// End Timezone Functions

// Message Preview Preferences

$_prefs['preview_enabled'] = array(
    'value' => '0',
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Enable message previews?")
);

$_prefs['preview_maxlen'] = array(
    'value' => 250,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(100 => _("100 characters"),
                    250 => _("250 characters"),
                    500 => _("500 characters"),
                    1000 => _("1000 characters"),
                    -1 => _("All")),
    'desc' => _("Characters to display:")
);

$_prefs['preview_strip_nl'] = array(
    'value' => '1',
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Strip linebreaks?")
);

$_prefs['preview_show_unread'] = array(
    'value' => '1',
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Show previews for unread messages only?")
);

$_prefs['preview_show_tooltip'] = array(
    'value' => '0',
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Show previews in tooltips?")
);

// End Message Preview

// Disposition Notification Preferences

$_prefs['disposition_request_read'] = array(
    'value' => 'ask',
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array('never' => _("Never"),
                    'ask' => _("Ask"),
                    'always' => _("Always")),
    'desc' => _("Request read receipts?"),
    'help' => 'prefs-disposition_request_read'
);

$_prefs['disposition_request_delivery'] = array(
    'value' => 'ask',
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array('never' => _("Never"),
                    'ask' => _("Ask"),
                    'always' => _("Always")),
    'desc' => _("Request delivery confirmation?"),
    'help' => 'prefs-disposition_request_delivery'
);

// End Disposition Notification Preferences

// Filter preferences
// a value of 0 = no, 1 = yes

// run filters on login?
$_prefs['filter_on_login'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// run filters with INBOX display?
$_prefs['filter_on_display'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// show filter icon on the menubar?
$_prefs['filter_menuitem'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// End Filter preferences

// Folder sharing preferences

// folder sharing options
// set 'locked' => true to disable folder sharing
$_prefs['acl'] = array(
    'value' => '',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// End folder sharing preferences

// Message Viewing preferences

// filter message content?
// a value of 0 = no, 1 = yes
$_prefs['filtering'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Filter message content for profanity?"));

// Should we display an icon to strip attachments?
// a value of 0 = no, 1 = yes
$_prefs['strip_attachments'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Show an icon to allow stripping of attachments from messages?"));

// Should we delete spam messages after reporting them?
// a value of 0 = no, 1 = yes
$_prefs['delete_spam_after_report'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Delete SPAM messages after they have been reported as spam?")
);

// Replace image tags in HTML messages with blank images?
// a value of 0 = no, 1 = yes
$_prefs['html_image_replacement'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Block images in HTML messages unless they are specifically requested?"),
    'help' => 'prefs-html_image_replacement'
);

// By default, automatically show images in HTML messages if the sender is in
// the user's addressbook?
// a value of 0 = no, 1 = yes
$_prefs['html_image_addrbook'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Automatically show images in HTML messages when the sender is in my addressbook?"),
    'help' => 'prefs-html_image_addrbook'
);

// should we try to mark different conversations with different colors?
$_prefs['highlight_text'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Mark different levels of quoting with different colors?"));

// should we try to mark simple markup with html tags?
$_prefs['highlight_simple_markup'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Mark simple markup?"));

// should we dim signatures?
$_prefs['dim_signature'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Dim signatures?"));

// how do we display attachments?
$_prefs['attachment_display'] = array(
    'value' => 'list',
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array('list'   => _("Listing in the Header"),
                    'inline' => _("Display in Body of Message"),
                    'both'   => _("Both Header Listing and Body of Message")),
    'desc' => _("How do you want to display attachments?"));

// End Message Viewing preferences

// Deleting and Moving Messages preferences

// should we return to the mailbox listing after deleting a message?
// a value of 0 = no, 1 = yes
$_prefs['mailbox_return'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Return to the mailbox listing after deleting, moving, or copying a message?"));

// should we move messages to a trash folder instead of just marking
// them as deleted?
// a value of 0 = no, 1 = yes
$_prefs['use_trash'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("When deleting messages, move them to your Trash folder instead of marking them as deleted?"));

// trash folder selection widget. includes some javascript, so it's
// specific to IMP.
$_prefs['trashselect'] = array('type' => 'special');

// trash folder
$_prefs['trash_folder'] = array(
// for Exchange, uncomment the entry below and remove the default value entry
//    'value' => 'Deleted Items',
    'value' => 'trash',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// display the 'Empty Trash' link in the menubar?
// 1 = yes, 0 = no
$_prefs['empty_trash_menu'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Display the 'Empty Trash' link in the menubar?"));

// hide deleted
// a value of 0 = no, 1 = yes
$_prefs['delhide'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// End Deleting and Moving Messages preferences


// Maintenance preferences

// To disable maintenance entirely, set 'value' = 0 and
// 'locked' = true for all of these. To just turn it off by default,
// set 'value' 0 for do_maintenance.

// perform maintenance operations?
$_prefs['do_maintenance'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => true,
    'type' => 'checkbox',
    'desc' => _("Perform maintenance operations on login?"),
    'help' => 'prefs-do_maintenance');

// confirm when doing maintenance operations? If false (0), they will
// be performed with no input from/check with the user.
$_prefs['confirm_maintenance'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => true,
    'type' => 'checkbox',
    'desc' => _("Ask for confirmation before doing maintenance operations?"),
    'help' => 'prefs-confirm_maintenance');

// rename sent-mail folder every month?
$_prefs['rename_sentmail_monthly'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Rename sent-mail folder at beginning of month?"),
    'help' => 'prefs-rename_sentmail_monthly');

// purge sent-mail folders every month?
$_prefs['delete_sentmail_monthly'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Delete old sent-mail folders at beginning of month?"),
    'help' => 'prefs-delete_sentmail_monthly');

// how many old sent-mail folders to keep every month?
$_prefs['delete_sentmail_monthly_keep'] = array(
    'value' => 12,
    'locked' => false,
    'shared' => false,
    'type' => 'number',
    'desc' => _("Number of old sent-mail folders to keep if deleting monthly."),
    'help' => 'prefs-delete_sentmail_monthly_keep');

// purge Trash folder?
$_prefs['purge_trash'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Purge old message in the Trash folder?"),
    'help' => 'prefs-purge_trash');

// how often to purge the Trash folder?
// 'value': yearly = 1, monthly = 2, weekly = 3, daily = 4, every login = 5
$_prefs['purge_trash_interval'] = array(
    'value' => '2',
    'locked' => false,
    'shared' => false,
    'type' => 'select',
    'desc' => _("Purge Trash how often:"),
    'help' => 'prefs-purge_trash_interval');

// when purging Trash folder, purge messages older than how many days?
$_prefs['purge_trash_keep'] = array(
    'value' => 30,
    'locked' => false,
    'shared' => false,
    'type' => 'number',
    'desc' => _("Purge messages in Trash folder older than this amount of days."),
    'help' => 'prefs-purge_trash_keep');

// show tos agreement?
// a value of 0 = no, 1 = yes
$_prefs['tos_agreement'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// End Maintenance preferences


// Fetch Mail preferences

// Change this if you want to customize how fetchmailprefs.php works.
$_prefs['fetchmail_link'] = array(
    'type' => 'link',
    'url' => 'fetchmailprefs.php',
    'img' => 'fetchmail.gif',
    'desc' => _("Edit your IMAP/POP3 accounts."));

// Fetch mail on separate window?
// a value of 0 = no, 1 = yes
$_prefs['fetchmail_popup'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Fetch Mail in a separate window?"));

// Show the Fetch mail icon on the menubar?
// a value of 0 = no, 1 = yes
$_prefs['fetchmail_menu'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Show the Fetch Mail icon on the menubar?"));

// Don't change anything here.
$_prefs['accounts'] = array(
    'value' => 'a:0:{}',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

$_prefs['fetchmail_login'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// End Fetch Mail preferences


// Display Options preferences

// which page to start on when opening mailbox
$_prefs['mailbox_start'] = array(
    'value' => IMP_MAILBOXSTART_FIRSTUNSEEN,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(IMP_MAILBOXSTART_FIRSTUNSEEN => _("Page with the First Unseen Message"),
                    IMP_MAILBOXSTART_LASTUNSEEN => _("Page with the Last Unseen Message"),
                    IMP_MAILBOXSTART_FIRSTPAGE => _("First Mailbox Page"),
                    IMP_MAILBOXSTART_LASTPAGE => _("Last Mailbox Page")),
    'desc' => _("When opening a new mailbox, which page do you want to start on?"),
    'help' => 'prefs-mailbox_start');

// user preferred sorting column
$_prefs['sortby'] = array(
    'value' => SORTARRIVAL,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(SORTARRIVAL => _("Arrival Time"),
                    SORTDATE => _("Message Date"),
                    SORTFROM => _("From Address"),
                    SORTTO => _("To Address"),
                    SORTSUBJECT => _("Subject Field"),
                    SORTSIZE => _("Message Size"),
                    SORTTHREAD => _("Thread View")),
    'desc' => _("Default sorting criteria:"));

// user preferred sorting direction
$_prefs['sortdir'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(0 => _("Ascending"),
                    1 => _("Descending")),
    'desc' => _("Default sorting direction:"));

// mailbox constraints
$_prefs['max_msgs'] = array(
    'value' => 20,
    'locked' => false,
    'shared' => false,
    'type' => 'number',
    'desc' => _("Messages per page in the mailbox view."));

// number of spelling corrections per screen
$_prefs['num_words'] = array(
    'value' => 3,
    'locked' => false,
    'shared' => false,
    'type' => 'number',
    'desc' => _("Spelling errors per screen when spell checking."));

// Maximum length of the 'From:" column
$_prefs['max_from_chars'] = array(
    'value' => 40,
    'locked' => false,
    'shared' => false,
    'type' => 'number',
    'desc' => _("In the Mailbox view, 'From:' columns longer than this value will be truncated."));

// Maximum length of the 'Subject:" column
$_prefs['max_subj_chars'] = array(
    'value' => 60,
    'locked' => false,
    'shared' => false,
    'type' => 'number',
    'desc' => _("In the Mailbox view, 'Subject:' columns longer than this value will be truncated."));

// How the from field should be displayed on the mailbox screen
$_prefs['from_link'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(
        0 => _("Clicking on the address will compose a new message to the sender"),
        1 => _("Clicking on the address will open the message to be read"),
        2 => _("Do not generate a link in the From: column")
    ),
    'desc' => _("The From: column of the message should be linked:"));

// Date format for messages not dated today
$_prefs['date_format'] = array(
    'value' => '%x',
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(
        '%x' => strftime('%x'),
        '%a, %b %e, %Y' => strftime('%a, %b %e, %Y'),
        '%a, %b %e, %y' => strftime('%a, %b %e, %y'),
        '%a, %b %e' => strftime('%a,%b %e'),
        '%a, %e %b, %Y' => strftime( '%a, %e %b %Y'),
        '%a, %e %b, %y' => strftime( '%a, %e %b %y'),
        '%e %b %Y' => strftime('%e %b %Y'),
        '%e. %b %Y' => strftime('%e. %b %Y'),
        '%e. %m %Y' => strftime('%e %m %Y'),
        '%e. %m.' => strftime('%e. %m.'),
        '%e. %B' => strftime('%e. %B'),
        '%e. %B %Y' => strftime('%e. %B %Y'),
        '%e. %B %y' => strftime('%e. %B %y'),
        '%B %e , %Y' => strftime('%B %e, %Y')
    ),
    'desc' => _("Format of message dates in the mailbox view for messages not dated today"));

// Date format for messages dated today (essentially the time)
$_prefs['time_format'] = array(
    'value' => '%X',
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(
        '%X' => strftime('%X'),
        '%H:%M:%S' => strftime('%H:%M:%S'),
        '%I:%M:%S %p' => strftime('%I:%M:%S %p'),
        '%H:%M' => strftime('%H:%M'),
        '%I:%M%p' => strftime('%I:%M%p')
    ),
    'desc' => _("Format of message dates in the mailbox view for messages dated today"));

// expand folder tree by default
$_prefs['nav_expanded'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(0 => _("No"),
                    1 => _("Yes"),
                    2 => _("Remember the last view")),
    'desc' => _("Expand the entire folder tree by default in the folders view?"));

// list of folders to expand by default
$_prefs['expanded_folders'] = array(
    'value' => 'a:0:{}',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// list of folders to poll for new mail
$_prefs['nav_poll'] = array(
    'value' => '',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// show mailbox legend?
// a value of 0 =no, 1 = yes
$_prefs['show_legend'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Show legend in the mailbox view?"));

// End Display Options preferences


// Message Composition preferences

// compose in a separate window?
$_prefs['compose_popup'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Compose messages in a separate window?"));

// wrap text at this many characters
$_prefs['wrap_width'] = array(
    'value' => 80,
    'locked' => false,
    'shared' => false,
    'type' => 'number',
    'desc' => _("Wrap text at this many characters."));

// If using MSIE 5.5+, should we compose in HTML mode by default?
$_prefs['compose_html'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Compose messages with an HTML GUI by default (IE 5.5+ only)?"));

// confirm successful sending of messages?
$_prefs['compose_confirm'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Display confirmation after sending a message?"));

// Should the original message be included?
$_prefs['reply_quote'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Include original message in a reply?"));

// Reply to header summary - leave a brief summary of the header inside
// the message.
// Value of 0 = no, 1 = yes
$_prefs['reply_headers'] = array(
    'desc' => _("Include a brief summary of the header in a reply?"),
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox');

// How should we prefix quoted lines in a reply?
$_prefs['quote_prefix'] = array(
    'value' => '> ',
    'locked' => false,
    'shared' => false,
    'type' => 'text',
    'desc' => _("How to prefix quoted lines in a reply:"));

// How should we attribute quoted lines in a reply
$_prefs['attrib_text'] = array(
    'value' => _("Quoting") . ' %f:',
    'locked' => false,
    'shared' => false,
    'type' => 'text',
    'desc' => _("How to attribute quoted lines in a reply"),
    'help' => 'prefs-attrib_text');

// folder selection widget. includes some javascript, so it's specific
// to IMP.
$_prefs['folderselect'] = array('type' => 'special');

// drafts folder
$_prefs['drafts_folder'] = array(
    'value' => 'drafts',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// closing window after saving a draft?
$_prefs['close_draft'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Should the compose window be closed after saving a draft?"));

// save drafts as seen or unseen
$_prefs['unseen_drafts'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Save drafts as unseen."));

// allow the user to add a "X-Priority" header when composing messages?
// a value of 0 = no, 1 = yes
$_prefs['set_priority'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Set the X-Priority header when composing messages?"));

// Select widget for the possible charsets
$_prefs['sending_charset'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'enum',
    'enum' => $GLOBALS['nls']['encodings'],
    'desc' => _("Your default charset for sending messages:"));

// Select widget for the 'default_encrypt' preference
$_prefs['encryptselect'] = array('type' => 'special');

// The default encryption method to use when sending messages
$_prefs['default_encrypt'] = array(
    'value' => IMP_ENCRYPT_NONE,
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// Automatically Bcc self when composing?
$_prefs['self_bcc'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Automatically Bcc yourself when composing a message?"));

// End Message Composition preferences


// Login Tasks preferences

// select widget for the initial_page preference
$_prefs['initialpageselect'] = array('type' => 'special');

// the page to display. Either a filename like 'folders.php'
// or a mailbox name.
$_prefs['initial_page'] = array(
    'value' => 'INBOX',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// user default mailbox
$_prefs['mailbox'] = array(
    'value' => 'INBOX',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// End Login Tasks preferences


// New Mail preferences

// time before reloading the navigator or mailbox page
$_prefs['refresh_time'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(0 => _("Never"),
                    30 => _("Every 30 seconds"),
                    60 => _("Every minute"),
                    300 => _("Every 5 minutes"),
                    900 => _("Every 15 minutes"),
                    1800 => _("Every half hour")),
    'desc' => _("Refresh Folder Views:"));

// javascript popup if there's new mail?
$_prefs['nav_popup'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Display pop-up notification of new mail?"));

// End New Mail preferences


// Address book preferences

// Should names in the compose window be expanded automagically?
$_prefs['auto_expand'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'checkbox',
    'desc' => _("Expand names in the compose window automatically in the background?"));

// By default, display all contacts in the address book when loading
// the contacts screen.  If your default address book is large and
// slow to display, you may want to disable and lock this option.
$_prefs['display_contact'] = array(
    'value' => 1,
    'locked' => false,
    'shared' => true,
    'type' => 'checkbox',
    'desc' => _("List all contacts when loading the contacts screen? (if disabled, you will only see contacts that you search for explicitly)"));

// address book selection widget
$_prefs['sourceselect'] = array('type' => 'special');

// address book(s) to use when expanding addresses
// You can provide default values this way (note the \t and the double quotes):
// 'value' => "source_one\tsource_two"
// refer to turba/config/sources.php for possible source values
$_prefs['search_sources'] = array(
    'value' => '',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// field(s) to use when expanding addresses
// This depends on the search_sources preference if you want to provide
// default values:
// 'value' => "source_one\tfield_one\tfield_two\nsource_two\tfield_three"
// will search the fields 'field_one' and 'field_two' in source_one and
// 'field_three' in source_two.
// refer to turba/config/sources.php for possible source and field values
$_prefs['search_fields'] = array(
    'value' => '',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// address book to use for adding adresseses
// put $cfgSources array element name in the value field.
// Setting value to localsql would allow you to add contacts to MySQL database
// See turba/config/sources.php for more info
$_prefs['add_source'] = array(
    'value' => '',
// 'value' => 'localsql',
    'locked' => false,
    'shared' => true,
    'type' => 'implicit'
);

// End Address book preferences


// PGP options

// Activate PGP support?
// 0 = no, 1 = yes
$_prefs['use_pgp'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'implicit'
);

// You should not manually change the rest of the PGP entries
$_prefs['pgp_attach_pubkey'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

$_prefs['pgp_scan_body'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

$_prefs['pgp_private_key'] = array(
    'value' => '',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

$_prefs['pgp_public_key'] = array(
    'value' => '',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// End PGP Options

// S/MIME options

// Activate S/MIME support?
// 0 = no, 1 = yes
$_prefs['use_smime'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// You should not manually change the rest of the S/MIME entries
$_prefs['smime_private_key'] = array(
    'value' => '',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

$_prefs['smime_public_key'] = array(
    'value' => '',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

$_prefs['smime_additional_cert'] = array(
    'value' => '',
    'locked' => false,
    'shared' => false,
    'type' => 'implicit');

// End S/MIME Options
