#
#  File: rh9-imp.spec
#  $Horde: imp/packaging/redhat/rh9-imp.spec,v 1.1 2003/04/29 00:24:21 bjn Exp $
#
#  This is the SPEC file for the IMP Red Hat 9 RPMs/SRPM.
#

%define apachedir /etc/httpd
%define apacheuser apache
%define apachegroup apache
%define contentdir /var/www

Summary: The Internet Messaging Program: webmail access to IMAP/POP3 accounts.
Name: imp
Version: 3.2.1
Release: 1
Copyright: GPL
Group: Applications/Horde
Source: ftp://ftp.horde.org/pub/imp/imp-%{version}.tar.gz
Source1: imp.conf
Vendor: The Horde Project
URL: http://www.horde.org/
Packager: Brent J. Nordquist <bjn@horde.org>
BuildArchitectures: noarch
BuildRoot: /tmp/imp-root
Requires: php >= 4.2.1
Requires: php-imap >= 4.2.1
Requires: httpd >= 2.0.40
Requires: horde >= 2.0
Prereq: /usr/bin/perl

%description
IMP is the Internet Messaging Program, one of the Horde applications.
It provides webmail access to IMAP and POP3 accounts.

The Horde Project writes web applications in PHP and releases them under
Open Source licenses.  For more information (including help with IMP)
please visit http://www.horde.org/.

%prep
%setup -q -n %{name}-%{version}

%build

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{apachedir}/conf.d
cp -p $RPM_SOURCE_DIR/imp.conf $RPM_BUILD_ROOT%{apachedir}/conf.d
mkdir -p $RPM_BUILD_ROOT%{contentdir}/html/horde/imp
cp -pR * $RPM_BUILD_ROOT%{contentdir}/html/horde/imp
chmod go-rwx $RPM_BUILD_ROOT%{contentdir}/html/horde/imp/test.php
cd $RPM_BUILD_ROOT%{contentdir}/html/horde/imp/config
for d in *.dist; do
	d0=`basename $d .dist`
	if [ ! -f "$d0" ]; then
		cp -p $d $d0
	fi
done

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%pre

%post
# post-install instructions:
cat <<_EOF_
You must manually configure IMP!
See "CONFIGURING IMP" in %{contentdir}/html/horde/imp/docs/INSTALL
You must also restart Apache with "service httpd restart"!
_EOF_

%postun
if [ $1 -eq 0 ]; then
	cat <<_EOF2_
You must restart Apache with "service httpd restart"!
_EOF2_
fi

%files
%defattr(-,root,root)
# Apache imp.conf file
%config %{apachedir}/conf.d/imp.conf
# Include top level with %dir so not all files are sucked in
%dir %{contentdir}/html/horde/imp
# Include top-level files by hand
%{contentdir}/html/horde/imp/*.php
# Include these dirs so that all files _will_ get sucked in
%{contentdir}/html/horde/imp/download
%{contentdir}/html/horde/imp/graphics
%{contentdir}/html/horde/imp/lib
%{contentdir}/html/horde/imp/locale
%{contentdir}/html/horde/imp/po
%{contentdir}/html/horde/imp/scripts
%{contentdir}/html/horde/imp/templates
# Mark documentation files with %doc and %docdir
%doc %{contentdir}/html/horde/imp/COPYING
%doc %{contentdir}/html/horde/imp/README
%docdir %{contentdir}/html/horde/imp/docs
%{contentdir}/html/horde/imp/docs
# Mark configuration files with %config and use secure permissions
# (note that .dist files are considered software; don't mark %config)
%attr(750,root,%{apachegroup}) %dir %{contentdir}/html/horde/imp/config
%defattr(640,root,%{apachegroup})
%{contentdir}/html/horde/imp/config/.htaccess
%{contentdir}/html/horde/imp/config/*.dist
%config %{contentdir}/html/horde/imp/config/*.php
%config %{contentdir}/html/horde/imp/config/*.txt

%changelog
* Mon Apr 28 2003 Brent J. Nordquist <bjn@horde.org> 3.2.1-1
- First release, 3.2.1-1

