<?php
/**
 * Mnemo external API interface.
 *
 * $Horde: mnemo/lib/api.php,v 1.20 2003/06/16 18:13:47 chuck Exp $
 *
 * This file defines Mnemo's external API interface. Other
 * applications can interact with Mnemo through this API.
 */

$_services['list'] = array(
    'args' => array('sortby', 'sortdir'),
    'type' => 'array');

$_services['search'] = array(
    'link' => '%application%/search.php');

$_services['show'] = array(
    'link' => '%application%/view.php?memo=|memo|');

$_services['add'] = array(
    'args' => array('body', 'category'),
    'type' => 'integer');

$_services['block'] = array(
    'args' => array('type', 'params'),
    'type' => 'array');

$_services['blocks'] = array(
    'args' => array(),
    'type' => 'array');

$_services['listCategories'] = array(
    'args' => array('notepad'),
    'type' => 'array');

$_services['formatCategory'] = array(
    'args' => array('categoryID', 'notepad'),
    'type' => 'string');


function _mnemo_formatCategory($categoryID = 0, $notepad = null)
{
    require_once dirname(__FILE__) . '/base.php';
    global $conf;

    if (!isset($conf['storage']['driver']) ||
        !isset($conf['storage']['params'])) {
        return PEAR::raiseError('Not configured');
    }

    if (!array_key_exists($notepad, Mnemo::listNotepads(false, _PERMS_READ))) {
        return PEAR::raiseError(_("Permission Denied"));
    }
    return Mnemo::formatCategory($categoryID, $notepad);
}

function _mnemo_listCategories($notepad = null)
{
    require_once dirname(__FILE__) . '/base.php';
    global $conf;

    if (!isset($conf['storage']['driver']) ||
        !isset($conf['storage']['params'])) {
        return PEAR::raiseError('Not configured');
    }

    if (!array_key_exists($notepad, Mnemo::listNotepads(false, _PERMS_READ))) {
        return PEAR::raiseError(_("Permission Denied"));
    }
    return Mnemo::listCategories($notepad);
}

function _mnemo_block($type, $params) 
{
    @define('MNEMO_BASE', dirname(__FILE__) . '/..');
    require_once MNEMO_BASE . '/lib/base.php';

    $class = 'Mnemo_' . $type . '_Block';
    require_once MNEMO_BASE . '/lib/Block/' . $type . '.php';
    return new $class($params);
}

function _mnemo_blocks()
{
    $blocks['summary']['name'] = _("Notes Summary");
    $blocks['summary']['params'] = array();

    return $blocks;
}

function _mnemo_list($sortby = null, $sortdir = null)
{
    require_once dirname(__FILE__) . '/base.php';
    global $conf, $prefs;

    if (!isset($conf['storage']['driver']) ||
        !isset($conf['storage']['params'])) {
        return PEAR::raiseError('Not configured');
    }

    if (!isset($sortby)){
        $sortby = $prefs->getValue('sortby');
    }
    if (!isset($sortdir)) {
        $sortdir = $prefs->getValue('sortdir');
    }

    return Mnemo::listMemos(MEMO_ANY, $sortby, $sortdir);
}

function _mnemo_add($body = '', $category = '')
{
    require_once dirname(__FILE__) . '/base.php';
    global $conf;

    /* Create a Mnemo_Driver instance. */
    require_once MNEMO_BASE . '/lib/Driver.php';
    $storage = &Mnemo_Driver::singleton($conf['storage']['driver'],
                                        Auth::getAuth(), $conf['storage']['params']);
    $storage->retrieve();

    /* Add the new memo. */
    $result = $storage->addMemo($body, $category);
    if ($result >= 0) {
        $result = $storage->store();
    }

    return $result;
}
