<?php
/**
 * Turba directory driver implementation for Horde Preferences - very
 * simple, lightweight container.
 *
 * $Horde: turba/lib/Driver/prefs.php,v 1.3 2003/01/10 05:20:53 chuck Exp $
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.3 $
 * @since   Turba 1.2
 * @package turba
 */
class Turba_Driver_prefs extends Turba_Driver {

    /** Handle for the current database connection. */
    var $db = null;

    /** String containg the name of the table in which the entries are
        stored. */
    var $table = '';

    /**
     * Constructs a new Turba Prefs driver object.
     *
     * @param $params       Hash containing additional configuration parameters.
     */
    function Turba_Driver_prefs($params)
    {
        $this->type = 'prefs';
        $this->params = $params;
    }

    /**
     * Return all entries - searching isn't implemented here for
     * now. The parameters are simply ignored.
     *
     * @param $criteria      Array containing the search criteria.
     * @param $fields        List of fields to return.
     * @param $strict_fields (optional) Array of fields which must be matched
     *                       exactly.
     * @param const $match   Do an 'and' or an 'or' search (defaults to TURBA_SEARCH_AND).
     *
     * @return               Hash containing the search results.
     */
    function search($criteria, $fields, $strict_fields = array(), $match = TURBA_SEARCH_AND)
    {
        return array_values($this->_getAddressBook());
    }

    /**
     * Read the given data from the SQL database and returns
     * the result's fields.
     *
     * @param $criteria      Search criteria.
     * @param $id            Data identifier.
     * @param $fields        List of fields to return.
     *
     * @return               Hash containing the search results.
     */
    function read($criteria, $id, $fields)
    {
        $book = $this->_getAddressBook();
        if (isset($book[$id])) {
            return array($book[$id]);
        } else {
            return array();
        }
    }

    /**
     * Cleanup.
     *
     * @return  True.
     */
    function close()
    {
        return true;
    }

    /**
     * Adds the specified object to the SQL database.
     */
    function addObject($attributes)
    {
        $book = $this->_getAddressBook();
        $book[$attributes['id']] = $attributes;
        $this->_setAddressbook($book);

        return true;
    }

    /**
     * Deletes the specified object from the SQL database.
     */
    function removeObject($object_key, $object_id)
    {
        $book = $this->_getAddressBook();
        unset($book[$object_id]);
        $this->_setAddressbook($book);

        return true;
    }

    /**
     * Saves the specified object in the SQL database.
     */
    function setObject($object_key, $object_id, $attributes)
    {
        $book = $this->_getAddressBook();
        $book[$object_id] = $attributes;
        $this->_setAddressBook($book);
    }

    /**
     * Create an object key for a new object.
     *
     * @param array $attributes  The attributes (in driver keys) of the
     *                           object being added.
     *
     * @return string  A unique ID for the new object.
     */
    function makeKey($attributes)
    {
        return md5(mt_rand());
    }

    function _getAddressBook()
    {
        global $prefs;

        $val = $prefs->getValue('prefbooks');
        if (!empty($val)) {
            $prefbooks = unserialize($val);
            return $prefbooks[$this->params['name']];
        } else {
            return array();
        }
    }

    function _setAddressBook($addressbook)
    {
        global $prefs;

        $val = $prefs->getValue('prefbooks');
        if (!empty($val)) {
            $prefbooks = unserialize($val);
        } else {
            $prefbooks = array();
        }

        $prefbooks[$this->params['name']] = $addressbook;
        $prefs->setValue('prefbooks', serialize($prefbooks));
        $prefs->store();
    }

}
