/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGQUERYCREATOR_H
#define SKGQUERYCREATOR_H
/** @file
 * A query creator for skrooge.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include <QWidget>

#include "ui_skgquerycreator.h"
#include "skgbankgui_export.h"

class SKGDocument;


/**
 * This file is a query creator for skrooge
 */
class SKGBANKGUI_EXPORT SKGQueryCreator : public QWidget
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     * @param iParent the parent
     */
    explicit SKGQueryCreator(QWidget* iParent = 0);

    /**
     * Default Destructor
     */
    virtual ~SKGQueryCreator();

    /**
     * Set parameters
     * @param iDocument the document
     * @param iTable the table
     * @param iListAttribute the list of attribute (empty means all attributes supported of the table)
     * @param iModeUpdate to enable update mode
     */
    virtual void setParameters(SKGDocument* iDocument, const QString& iTable, const QStringList& iListAttribute = QStringList(), bool iModeUpdate = false);

    /**
     * Set XML representing the query
     * @param iXML the XML representing the query
     */
    virtual void setXMLCondition(const QString& iXML);

    /**
     * Get XML representing the query
     * @return the XML representing the query
     */
    virtual QString getXMLCondition();

    /**
     * Get the number of line
     * @return the number of line
     */
    virtual int getLinesCount();

    /**
     * Get the number of line
     * @return the number of line
     */
    virtual int getColumnsCount();

public Q_SLOTS:
    /**
     * Clear table content
     */
    virtual void clearContents();

    /**
     * Remove a line
     * @param iRow the index of the line (-1 for all)
     */
    virtual void removeLine(int iRow = -1);

    /**
     * Remove a column
     * @param iColumn the index of the column
     */
    virtual void removeColumn(int iColumn);

    /**
     * Add a new line
     */
    virtual void addNewLine();

private Q_SLOTS:
    void onCloseEditor();
    void onAddColumn();
private:
    Q_DISABLE_COPY(SKGQueryCreator)

    int getIndexQueryColumn(const QString& iAttribute, int row = -1);
    void addColumnFromAttribut(const QListWidgetItem* listItem);
    void resizeColumns() ;

    Ui::skgquerycreator_base ui;
    SKGDocument* m_document;
    QString m_table;
    bool m_updateMode;
};

#endif  // SKGQUERYCREATOR_H
