.\" @(#)xvtdl.man	5.0 xvtdl version 9/11/92
.TH XVTDL 1 "9 Sept 1992"
.SH NAME
xvtdl \- A To Do List Manager Using the XView Toolkit
.SH SYNOPSIS
.B xvtdl
[
.I options
]
.\" ========================================================================
.SH DESCRIPTION
.LP
.B xvtdl
is a "to do" list manager that features multiple, hierarchical
to do lists with items
that propagate through time (when not "checked off") and items that can 
be recurring in various time/calendar increments.   Items that are
"checked off" can either be retained for posterity or deleted by the
propagation mechanism. 
The set of lists are indicated by category names; categories can be
hierarchical to form trees of categories.
Deadlines can be specified for any item, with actions that are performed
on the deadline or after it has past.
Multi-level logging
allows items to be logged in several modes when checked off or on.
Lists can be printed
to "regular" and PostScript printers.  In normal use,
.B xvtdl
can be started with the window system and left running (usually in an
iconic state), as it uses very
little CPU time and automatically propagates items at midnight every
night.  
.LP
.B xvtdl
uses the XView toolkit from Sun Microsystems to implement the OPEN LOOK 
graphical user interface.
.LP
Unless otherwise directed by the "-f" option, 
.B xvtdl
maintains a database of to do list items in the $HOME/.tododb file.
This database is in ASCII format and is written at various times
throughout its execution lifespan (e.g., whenever items are propagated or
when new items are added to a list).  
.LP
.B xvtdl
keeps track of the modifcation times of databases.  When its internal
modification time differs from the database file's modification times, it
will sense the decrepency and ask the use how to handle it.  The user can
merge any changes made, write our the current, in-memory copy of the
database (making the user's copy the actual copy), or ignore the changes
altogether.  
.I Note that merging does not delete items.
This means that items that were deleted in the "altered" database file
will still be maintained in the current, in-memory version
.I and written out to the database file when appropriate.
.\" ========================================================================
.SH OPTIONS
.LP
.TP
-f file
Use "file" instead of $HOME/.tododb
.TP
-m
Do not initialize colors on a color display.  Treat the display as
monochrome. 
.\" ========================================================================
.SH USING XVTDL
.LP
When 
.B xvtdl
is started, the todo list for the first category for the current date is
displayed.  There are three areas that will recognize events.  These are
the calendar area on the upper left, the control area above the to do
list, and the to do list itself.  
.LP
The calendar area will respond to any mouse click.  Clicking in the
calendar will move the current list to the date clicked on.  
The date for which the todo list is being displayed will appear in the
calendar with a box around it.  A full text date specification will be
given to the right of the calendar.
If the mouse click is not on a number,
.B xvtdl
tries to deduce what date would be there if the previous or next months
numbers were displayed.
.LP
The list itself displays todo list items and their priorities.  The
middle mouse button has no effect here.  The left mouse button will
select or deselect items -- for use with editing operations -- with a
single click.  A double click on an item will toggle its "checked" state
-- from off to on or from on to off.  Checked items are not propagated
and items are optionally logged when checked on and off.  The right
(menu) mouse button will display the edit menu -- the same menu as
connected with the "Edit" button in the control area (see below). 
Some keyboard actions have effect here:

.RS
COPY (L6), PASTE (L8), and CUT (L10) keys perform the same copy, paste,
and cut operations (respectively) that can be initiated from the edit
menu (see below).
.LP
Up-arrow (R8) and Down-arrow (R14) keys increase and decrease priority
(respectively) for a selected list item, just as selecting the
appropriate operation from the edit menu does (see below).
.RE
.LP
The control area above the list has the following controls:

.RS
Left and Right arrow buttons:  
.RS
These move incrementally through the calendar.  Left moves back in time;
right moves forward in time.  Without any other keys down, the effect is
to move one day backward or forward.  With the control key down, the
increment is one week.  With the shift key pressed, the increment is one
month.  With the Meta key down, the increment is one year.

.RE
Category Menu:
.RS
This is a menu (bring it up with the right mouse button) containing all
the categories/todo lists that are in the database.  Selecting one from
this menu will display that particular list.

.RE
The "Create" button:
.RS
This button is a menu button that allows the user to create new list
items or categories.  Each choice brings up its own window.  See the
description of the item and category editor windows below.

.RE
The "Edit" button:
.RS
This is a menu button that allows the following operations:
.RS
Modify
.RS
Select a list item then this menu item. This brings up the entry
window, with the items initialized by the list edit just selected.  The
attributes -- including the deadline specifications and the 
recurring properties -- can be changed and
the "Done" button will refresh the item with its new attributes.
.RE
Copy
.RS
After selecting a list item, select this menu item.
A copy of the list item is placed in
an edit buffer, ready for pasting.  One cannot copy categories.
.RE
Cut
.RS
After selecting a list item, select this menu item.  The selected 
item is placed
in an edit buffer and deleted from the current list.  
.RE
Paste
.RS
Selecting this menu item will insert the contents of the edit buffer into
the current list.  An error will be flagged if the edit buffer is empty.
.PP
Categories cannot be pasted.
.RE
inc priority
.RS
Selecting this choice will increment the priority of the selected list
item.  The item is incremented according to the priority scheme
(ascending or decending) chosen in the property specification.
.RE
dec priority
.RS
Selecting this choice will decrement the priority of the selected list
item.  The item is decremented according to the priority scheme
(ascending or decending) chosen in the property specification.
.RE
Modify Category
.RS
Selecting this item will allow the current category to be modified in the
category editor.  Changes in name and placement in the category hierarchy
are allowed. Changes take place when the "Done" button is pressed.
.RE
Delete Category
.RS
Selecting this item will cause the currently displayed  category to be 
deleted from the category menu (and made inaccessible).
.PP
.B Note
that there must be at least one category in the system at all times.
Starting 
.B xvtdl
with no database creates an empty category called "Every Day".  Likewise,
deleting the last category automatically creates the empty "Every Day"
category.  To get rid of the "Every Day" category, create another
category, then delete the "Every Day" category.
.RE
Properties...
.RS
Selecting this menu item will pop up the properties window.  Use of this
window is detailed below.  Properties are used to manipulate the X
resources connected with this program.
.RE
.RE

.RE
The "Today" button:
.RS
This displays the current list for the current date.

.RE
The "List All" button:
.RS
This is a menu button that allows special listing operations.  Note that
this button will change its label, depending on how the default listing
action on the button's menu changes.  For all items except "List
Category", the button label will change to "List Cat" to allow easy
redisplay of the current category.  For the "List Category" menu choice,
the label will revert to "List All".  Also, selecting an option that
redisplays the todo list will revert the button to "List All" status.
.LP
The operations are as follows:
.RS
List All
.RS
This causes 
.B xvtdl
to display all list items from all categories in the user-specified order
on the todo list.  When this list is displayed, it can be manipulated as
a "normal" list from a category.  Items may be checked off and on -- the
effect of this will be reflected in the category that item appears in --
and the "global list" can be printed through the print window. 
.PP
Printing the global list works as it does with any other list, with one
exception.  The "Categories:" field is rendered inactive, because there
is only one list to print.  This field is activated again for other,
"normal" lists.
.PP
.B Note
that the category specifier does not change for the global list.  During
the time the global list is displayed, the indication in the category
item is incorrect.
.RE
List Tree
.RS
This will cause the tree of categories rooted at the current category to
be displayed on one list.  Here, semantics and operations are analogous
to those for the "List All" choice. 
.RE
List Parent
.RS
This choice will list the contents of the parent category without changing
the "current" category.
.RE
List Category
.RS
This choice will list contents of the current category on the todo list.
.RE
.RE

.RE
The "Print..." button:
.RS
This opens the Print window for printing lists.  This window is detailed
below.  

.RE
The "Done" button:
.RS
This causes the program to update the todo database and close to an
iconic form.
.I This way is preferred 
for closing over using the window menu.

.RE
The "File" Button
.RS
This button is a menu button allowing certain file operations to take
place.  Each menu choice pops up a file manager window, which allows the
user to "click" their way through a file system by double-clicking on the
list of files, or to textually specify the filename.  
.LP
Operations are:
.RS
Load
.RS
This opens and loads the contents of the file name returned by the file
manager.  The current database contents are lost.
.RE
Merge
.RS
This choice opens and load the contents of the file name returned by the file
manager in the same way the "Load" operation does.  However, the current
database contents are retained.  All new entries are added relative to
the current category.  
.RE
Save
.RS
This choice will save the current database contents into the file named
by the name returned by the file manager window.
.RE
Save Category
.RS
This choice will save the contents of the current category into the file named
by the name returned by the file manager window.
.RE
.RE

.RE
The "Quit" button:
.RS
This cause the program to terminate.
.RE
.RE
.SH The Entry Editor
.LP
Creating and editing items is done through the entry window.  This window
will pop up when the "New Item" menu entry is chosen from the "Create"
menu button or the edit menu item is selected.  This window
is detailed below.

.RS
Category Menu:
.RS
This menu, only active for list item creation, allows the user to select
the list category the newly created item will be placed into.

.RE
The "Text:" field:
.RS
This is the actual text of the to do list item.

.RE
The "Priority:" slider:
.RS
This slider specifies the priority of item being created/edited.  
This will allow a priority to be specified between 1 and 9.

.RE
The "Recurring..." button:
.RS
This will pop up the recurrence editor, detailed below.
This window lets the user
specify the recurrence properties of the item being created or edited.

.RE
The "Deadline..." button:
.RS
This button will popup the deadline specification window.  This window is
detailed below; it allows the specification of actions to occur when a
deadline for an item is encountered.

.RE
The "Cancel" and "Done" buttons:
.RS
"Cancel" cancels the creation or editing operation, ignoring the settings
in the window.  "Done" completes the creation or editing operation,
installing the changes.  Both choices close the editing window.
.RE
.RE
.SH The Recurrence Editor
.LP
The recurrence editor lets the user choose the frequency and length of
time that the item should recur.  Various items will be hidden or be
shown, depending on the frequency of the recurrence.  (For example, no
other specification is required if the recurring property is "Daily".)
Most is self-explanatory.  
Choosing "Done" in the recurrence
window will install the recurrence propoerties specified; choosing
"Cancel" will ignore the recurrence choices.
.LP
The specification of "days of the week" is more flexible now than at
version prior to 4.x.  Here, you can specify any day of the week -- and
mix and match them.  
.B There is a problem here,
however, with prior versions of
.B xvtdl.
The days of the week are stored in a "bitwise" form -- 1 for Monday, 2
for Tuesday, 3 for 
.I both
Monday and Tuesday, etc.  This means that Wednesday, Friday, Saturday,
and Sunday in the old version will come out as Monday/Tuesday,
Monday/Wednesday, Tuesday/Wednesday, and Monday/Tuesday/Wednesday,
respectively.  Please check your "day of the week" specifications when
starting to use version 5.0 for the first time.
.LP
Note that -- for monthly specification -- "week of month" and "day of
month" are mutually exclusive.  This is arranged in 
.B xvtdl
by inactivating "day of month" whenever "week of month" is specified.  
.LP
Note also that for "number of weeks" and "number of months", a zero (0)
is considered "forever".

.SH The Deadline Specification Window
.LP
A deadline is a date on or after which certain actions may occur.  A
deadline may be absolute or relative.  Absolute deadlines are given in
"mm/dd/yy" notation (e.g., "7/8/92").  Relative deadlines
are given relative to the starting date of the list item (note that's 
.I not
the current date -- especially if the item has been propagated).
Relative deadlines are give as
.RS
.PP
<number><units>
.PP
.RE
<number> may be positive or negative.  <units> must be one of "d", "w",
"m", or "y", indicating days, weeks, months, or years, respectively.  For
example, "4d" indicates 4 days from the starting date fo the item; "3m"
specifies 3 months from the date of the item. 
.LP
While absolute deadlines work fine for most applications, relative
deadlines are the best to use with recurring items, when the starting
date of the item depends on its recurring properties.
.LP
Deadlines are examined 
.I at propagation time,
and only at propagation time.  (Propagation occurs when the tool is
started and at or around midnight each night.)
.LP
Actions can be taken at or after a deadline date.  These are specified in
the deadline window and may be combined.  A new deadline window is
initialized to the actions specified in the "Deadlines" property sheet.
These actions are listed below:
.RS
Delete
.RS
The user must enter the time units and the number of those units.  After
the specified number of time units after the deadline have past, the item
will be deleted.
.RE
+ Priority
.RS
For each day after the deadline has past, the item's priority will be
incremented by the amount specified.
.RE
- Priority
.RS
For each day after the deadline has past, the item's priority will be
decremented by the amount specified.
.RE
Mail on
.RS
A message will be sent to the address specified on the day on which the
deadline occurs.
.RE
Mail after
.RS
A message will be sent to the address specified on each day after the 
deadline.
.RE
Move after
.RS
The deadline will be moved by the number of time units given on the day 
.I after
the deadline has occured.

.RE
.RE

.SH The Category Editor 
.LP
Categories are created and edited through the category editor window.
This window is used to insert a category anywhere in the category tree.  
There are a few rules to follow: (1) a category cannot be placed as the
subcategory of one that already has subcategories, (2) a category cannot
be named with the same name as any other category, and (3) a category
cannot be placed as a subcategory to itself.
.LP
The controls on the editor window are self-explanatory.  

.SH The Print Window
.LP               
Printing lists is done through the print window.  Printing can be done in
a no-frills ASCII mode or in a PostScript mode.  Through this window, the
user must specify the printer name, the printing mode, and whether to
print checked off items.  If PostScript mode is selected, the user can
also specify the scaling factor on the printout (useful for insertion
into organizational notebooks/datebooks).  The user can print the current
categories or all categories by specifying the proper selection on the
"Categories" item.  The user can cancel or
complete the print action by selecting the appropriate buttons in the
window.  
.SH The Properties Window
.LP
Invoking the "Properties..." item in the edit menu will open the
properties window.  This window controls the X resources used to control
.B xvtdl
and will create and maintain a file in the user's home directory that
contains the resource specifications.  This file, called ".xvtdlrc", will
be automatically updated when the properties are updated.  There are
three control items and four property sheet.  The items work as follows:
.RS
Category:
.RS
In version 5.0, there are five categories of properties: "Sorting",
"Printing", "Deadlines", "Logging", and "Other Info".  Each is selectable
through the menu on the "Category:" item.
.RE
The "Reset" Button:
.RS
Pressing this button will cause the window to be reset with the current
setting of X resources.  

.RE
The "Done" Button:
.RS
This button causes the program to set the X resources in the X resource
database for the user's display server and to write the values out to the
".xvtdlrc" file to be read next time the program is invoked.
.RE
.RE
.LP
The property items in each property sheet are detailed as follows:
.RS
The "Sorting" Sheet:
.RS
The Sort Order Choices:
.RS
Sorting may be specified as a combination of priority, chronological, and
alphabetical orders.  These are specified in "sort levels".  Sort level 3
is done within items sorted by sort level 2, which is done within items
sorted within sort level 1.  
.LP
Note that no levels may be specified further if alphabetical order is
selected.  Thus, alphabetical order is always the last order specified.

.RE
Priority Preference:
.RS
This provides a way to customize what order the user wishes priorities to
be listed: either with high = 1 down to low = 9 or with high = 9 and low
= 1.  The default situation is the latter.

.RE
Chronology Preference:
.RS
This provides a way to customize what order the user wishes item to
be listed chronologically: either oldest first or newest first.
The default situation is the latter.

.RE
.RE
The "Printing" Sheet:
.RS
Default Printer:
.RS
This is the printer that will come up as the default in the print window.
It is specified here because changing the printer in the print window
does not manipulate the X resource.  If this resource is left empty, then
.B xvtdl
will use the value of the PRINTER environment variable.

.RE
Default Printer Mode:
.RS
This is the printer mode (normal or PostScript) that will come up as the
default in the print window. 
It is specified here because changing the printer in the print window
does not manipulate the X resource.

.RE
.RE
The "Deadlines" Sheet:
.RS
This sheet is a replica of the deadline specification window, except that
the deadline date is not present.  Any setting the user makes on this
sheet will be used as the default setting for the items on new deadline
specifications for list items.

.RE
The "Logging" Sheet:
.RS
Log Preference:
.RS
This specifies when to log an entry.  Choices are "When Checked", which
allow logging when the item is checked on or off, "At Quit/Propagation",
which logs a checked off item when the program propagates at midnight or
the program is terminated, or "Never", which disables logging.

.RE
Log Info:
.RS
This specifies the kind of information to occur in the log file.  This
can be either "Timestamp Only", which places a timestamp and the item
string in the file without user intervention, or "User Specified", which
constructs a minimal log entry and starts an editor containing that entry
that the user can use to customize it.  This editor window contains an
editor window and two buttons: "Cancel" will cancel any edits, entering
the original log entry in the log file, and "Done" will save any edits
made, entering the new version in the log file.

.RE
Log Filename:
.RS
This gives the name of the log file.  This is can be a relative or
absolute filename.

.RE
.RE
The "Other Info" Sheet:
.RS
Default Priority:
.RS
This specification will set the default priority that sets the priority
of newly created list items.  The default for this setting is 5.
.RE
On Propagation
.RS
This specifier will direct the program what to do with checked-off list
items when it moves items to a new day.  The user can either have them
deleted, which is the default, or have them retained.  
.LP
.B Note
that if a retained, checked-off item is unchecked, it immediately
propagates to the current day.
.RE
Foreground Color and Background Color
.RS
These allow the textual specification of the foreground and background
colors for the 
.B xvtdl
application.  If you push the button next to each textual line, a color
chooser will be invoked that allows you to choose a color with the mouse
and will enter the name of that color on the property window line.
.LP
Naturally, these items are inactive (grayed out) on monochrome displays.
.RE
.RE
.\" ========================================================================
.SH TO DO LIST DATABASE FORMAT
.LP
The database is an ASCII file oriented in a line-by-line manner.  Each
line represents either a category specification, a parent specification,
a todo list item, or a deadline specification. 
.I Note that strings are surrounded two single quotes --
this has been used to allow double quotes in list items.
.LP
Category specifications
are given as
.RS
.PP
category: ''category name''
.PP
.RE
All entries up to the next category specification or the end of file
designate todo list items in the category listed.
.LP
Parent specifications can be given for categories and always appear after
the category specification.  They indicate the name of the parent of the
current category.  Parent specifications are given as
.RS
.PP
parent: ''parent name''
.PP
.RE
.LP
To do list items are given in the form
.RS
.PP
date[|recurring-part]:priority:''list item text''
.PP
.RE
The "date" is given in mm/dd/yy format.  The recurring part is optional
and is specified by a string of characters:
.RS
.PP
one of "d", "w", "b", "m", or "y" to indicate daily, weekly,
biweekly, monthly, or yearly repitition.
.PP
if weekly or biweekly, this is followed by an integer. The integer is
viewed as a 7-bit bitstring, where the bit is on when the event occurs on
a specific day of the week (0 = Sunday) 
.I (Note that the old Mon/Wed/Fri and Tues/Thurs formats are still
.I recognized for backwards compatibility.  When these are written after
.I begin read, they are converted to the new format.)
.PP
if weekly or biweekly, this is followed by a "W" and a number, indicating
the number of weeks this item is to repeat
.PP
if monthly, a "N" and a number is concatenated to indication the week
number in the month to repeat the item
.RE
.LP
The priority part is an integer from 1-9.  
.LP
Deadline specifications give deadlines associated with the most recently
defined list item.  Their format is given by
.RS
.PP
deadline:date:actions:deletetime deleteunits:+units:-units:''on addr'':''after addr'':movetime moveunits:
.PP
.RE
all on one line.  "date" is given in absolute or relative deadline form.
"actions" is the value of the action specification item on the deadline
specification window -- a bitstring with bits on or off depending if that
particular action is specified. 
"deletetime" and "movetime" are integers, giving
the number of the respective units for delete time and move time.
"deleteunits" and "moveunits" are integers in the range 0-3, giving days,
weeks, month, and years, respectively.  "+units" and "-units" are
integers giving the number of priority steps to increment or decrement an
item.  "on addr" and "after addr" are the addresses to send messages
about the deadline occuring or being past, respectively.
.\" ==========================================================================
.SH RESOURCES TO CONTROL XVTDL
.LP
There are many resources that  the resource database for
.B xvtdl
can contain.  They are included here for completeness; however, they can
all be manipulated through the properties window.  They are
.LP
.TP 
SortOrder
a sequence of three digits indicating the criteria to be used at a sort
level.  Values 0 through 2 indicate priority, chronilogical, and
alphabetical criteria, respectively.  A value of 3 indicates no criteria.
The sequence is ordered sort level 1 to sort level 3 by left to right.
.TP
PriorityListing
a string resource that can be either "ascending" or "descending",
indicating which direction, high to low, the priorities should be listed
.TP
ChronListing
a string resource that can be either "ascending" or "descending",
indicating which direction, new to old, the chronilogical order is given.
.TP
PrintDestination
a string resource, values of "file" or "printer", indicating the default
destination to which an output of the todo list should go.
.TP
Printer
a string which specifies the default printer to use in the print window
.TP
PostScript
a boolean resource specifying whether to initialize the print window to
use PostScript mode.
.TP
PrintFile 
a string resource indicating the default file name into which
an output of the todo list should go if the destination is "file".
.TP
Logging
a boolean resource specifying whether to log list item activity
.TP
LogPreference
a string resource that can contain two values: "atchecked" indicates that
logging should occur when an item is checked off or on, "atquit"
indicates that logging should occur at propagation or termination of the
program 
.TP
LogInfoPreference
a string resource that can contain one of two values: "timestamp"
indicates only timestamps are to be logged in the log file, "userspec"
indicates that the user is to specify the contents of the log entry
.TP
LogFileName
a string resource giving the name of the log file
.TP
DefaultPriority
a integer resource giving the default priority to use when creating a new
list item
.TP
DeadlineDelete
a boolean resource specifying the default for the delete action in newly
created deadlines
.TP
DeadlineDeleteTime
an integer resource giving the default for the number of delete units to
wait after the deadline in a newly created deadlines
.TP
DeadlineDeleteUnits
an integer resource giving the default units for the time to
wait after the deadline in a newly created deadlines -- the range is 0-3,
giving days, weeks, months, and years respectively
.TP
DeadlineUpPriority
a boolean resource specifying the default for the "+ Priority" action in newly
created deadlines
.TP
DeadlineUpIncrement
an integer resource giving the default for the increment of priorities 
in a newly created deadlines
.TP
DeadlineDownPriority
a boolean resource specifying the default for the "- Priority" action in newly
created deadlines
.TP
DeadlineDownIncrement
an integer resource giving the default for the decrement of priorities 
in a newly created deadlines
.TP
DeadlineMailOn
a boolean resource specifying the default for the "Mail on" action in newly
created deadlines
.TP
DeadlineMailOnAddress
a string resource giving the default address for the "Mail on" action in 
newly created deadlines
.TP
DeadlineMailAfter
a boolean resource specifying the default for the "Mail after" action in newly
created deadlines
.TP
DeadlineMailAfterAddress
a string resource giving the default address for the "Mail after" action in 
newly created deadlines
.TP
DeadlineMoveAfter
a boolean resource specifying the default for the "Move after" action in newly
created deadlines
.TP
DeadlineMoveTime
an integer resource giving the default for the number of move units to
wait after the deadline in a newly created deadlines
.TP
DeadlineMoveUnits
an integer resource giving the default units for the time to
wait after the deadline in a newly created deadlines -- the range is 0-3,
giving days, weeks, months, and years respectively
.\" ========================================================================
.SH COPYRIGHTS
.LP
The X Window system is a trademark of the Massachusetts Institute of
Technology.
.br
OPEN LOOK is a trademark of AT&T.
.br
OpenWindows is a trademark of Sun Microsystems, Inc.
.br
The code in "xdefaults.c" is copyrighted by Mike Sullivan and Sun Microsystems.
.br
Portions not covered under the above copyrights are (c) 1993 by Mike
Jipping and Hope College.
.br
Please see the COPYRIGHT file for full disclosure of copyright
information.
.\" =======================================================================
.SH FILES 
.LP
.TP
$HOME/.tododb
This is the default to do list database.
.TP
$HOME/.xvtdlrc
This file holds the X resources required to control this program.  It is
created and maintained through the property window.
.TP
/tmp/xvtdl*
When printing, this temporary file is used to store the list prior to
sending to the printer.
.TP
/tmp/log*
When logging, this temporary file is used to store the log entry prior to
editing by the user.
.\" =======================================================================
.SH SEE ALSO
cm(1) tdl(L)
.\" =======================================================================
.SH AUTHOR
.LP
The 
.B xvtdl
program was written by Mike Jipping, Hope College Department of Computer
Science.  All comments, praises, bug reports, and flames should be sent
to him at "jipping@cs.hope.edu".  He'll at least read your message.
.\" =======================================================================
.SH KNOWN BUGS
.LP
There are currently no known aspects of the program that corrupt the data
or crash the program.
.LP
There are some annoying bugs.
When the database is large, merging in changes made by someone else
duplicates all entries.  
