

#include <stdio.h>
#include <math.h>

extern void InitLattice();
extern double S3Noise();

int NPTS;

main(argc, argv)
    int argc;
    char **argv;
{
	int i, j;
	double f, x, y, z, x2, y2;
	double freq, amp, nret, xt, yt, zt;
	double s_tmp;
	int t1, t2, t3, t4;

	freq = 2.0;
	amp = 1.0;
	if (argc < 2)
	{
		fprintf(stderr, "Warning no points argument passed.\n");
		fprintf(stderr, "Setting Number of Points to 20\n");
		NPTS = 20;
	}
	else
	{
		NPTS = atoi(argv[1]);
		if (((NPTS / 4) * 4) != NPTS)
		{
			fprintf(stderr, "Warning NPTS (%d) is not a multiple of four\n", NPTS);
			NPTS = ((NPTS / 4) * 4);
			fprintf(stderr, "Setting NPTS  to (%d)\n", NPTS);
		}
		if (argc > 2)
			freq = atof(argv[2]);
		if (argc > 3)
			amp = atof(argv[3]);
	}
	InitLattice();

	printf("%d\n", ((NPTS * ((NPTS / 2) - 1)) + 2));
	printf("%d\n", (((NPTS * 2) * ((NPTS / 2) - 2)) + (NPTS * 2)));
	for (i=0; i<=(NPTS / 2); i++)
	{
		f = ((double)i / (NPTS / 2)) + 0.5;
		x2 = cos(f * M_PI);
		y2 = sin(f * M_PI);
		if ((i > 0) && (i < (NPTS / 2)))
		{
			for (j=0; j<NPTS; j++)
			{
				f = ((double)j * 2) / NPTS;
				xt = x2 * cos(f * M_PI);
				yt = y2;
				zt = x2 * sin(f * M_PI);
s_tmp = S3Noise(freq * (xt / 2.0 + 1.2), freq * (yt / 2.0 + 1.2), freq * (zt / 2.0 + 1.2));
s_tmp = fabs(s_tmp);
s_tmp = pow(s_tmp, (log(0.3) / log(0.5)));
if (s_tmp < 0.5)
{
	s_tmp = pow((2.0 * s_tmp), (log(0.1) / log(0.5)));
	s_tmp = s_tmp / 2.0;
}
else
{
	if ((2.0 - 2.0 * s_tmp) < 0.0)
	{
	s_tmp = pow((2.0 - 2.0 * s_tmp), floor(log(0.1) / log(0.5)));
	}
	else
	{
	s_tmp = pow((2.0 - 2.0 * s_tmp), (log(0.1) / log(0.5)));
	}
	s_tmp = 1.0 - (s_tmp / 2.0);
}
if (s_tmp < 0.0)
{
fprintf(stderr, "stmp = %f\n", s_tmp);
}
				x = (xt / 2) * (1.0 + (amp * s_tmp / freq));
				if (fabs(x) > fabs(xt)) x = xt;
				y = (yt / 2) * (1.0 + (amp * s_tmp / freq));
				if (fabs(y) > fabs(yt)) y = yt;
				z = (zt / 2) * (1.0 + (amp * s_tmp / freq));
				if (fabs(z) > fabs(zt)) z = zt;
				printf("%lf %lf %lf\n", x, y, z);
			}
		}
		else
		{
s_tmp = S3Noise(freq * (1.2), freq * (y2 / 2.0 + 1.2), freq * (1.2));
s_tmp = fabs(s_tmp);
s_tmp = pow(s_tmp, (log(0.3) / log(0.5)));
if (s_tmp < 0.5)
{
	s_tmp = pow((2.0 * s_tmp), (log(0.1) / log(0.5)));
	s_tmp = s_tmp / 2.0;
}
else
{
	if ((2.0 - 2.0 * s_tmp) < 0.0)
	{
	s_tmp = pow((2.0 - 2.0 * s_tmp), floor(log(0.1) / log(0.5)));
	}
	else
	{
	s_tmp = pow((2.0 - 2.0 * s_tmp), (log(0.1) / log(0.5)));
	}
	s_tmp = 1.0 - (s_tmp / 2.0);
}
y = (y2 / 2) * (1.0 + (amp * s_tmp / freq));
if (fabs(y) > fabs(y2)) y = y2;
			printf("%lf %lf %lf\n", 0.0, y, 0.0);
		}
	}

	t1 = 0;
	t2 = 1;
	t3 = 2;
	for (j=1; j<NPTS; j++)
	{
		printf("%d %d %d\n", t1, t2, t3);
		t2++;
		t3++;
	}
	printf("%d %d %d\n", t1, t2, t1 + 1);

	t1 = 1;
	t2 = 2;
	t3 = NPTS + 1;
	t4 = NPTS + 2;
	for (i=2; i<(NPTS / 2); i++)
	{
		for (j=1; j<NPTS; j++)
		{
			printf("%d %d %d\n", t1, t3, t4);
			printf("%d %d %d\n", t1, t4, t2);
			t1++;
			t2++;
			t3++;
			t4++;
		}
		t2 -= NPTS;
		t4 -= NPTS;
		printf("%d %d %d\n", t1, t3, t4);
		printf("%d %d %d\n", t1, t4, t2);
		t1 = t2 + NPTS;
		t2 = t1 + 1;
		t3 = t4 + NPTS;
		t4 = t3 + 1;
	}

	for (j=1; j<NPTS; j++)
	{
		printf("%d %d %d\n", t3, t2, t1);
		t1++;
		t2++;
	}
	printf("%d %d %d\n", t3, t2 - NPTS, t1);
}

