

#include <stdio.h>
#include <math.h>

int NPTS;
float RAD;
float CRAD;
float Twist;

main(argc, argv)
    int argc;
    char **argv;
{
	int i, j, Div;
	double f, turn, x, y, z, x2, y2;
	int ta1, ta2, ta3, ta4;
	int tb1, tb2, tb3, tb4;

	if (argc > 4)
	{
		fprintf(stderr, "usage: %s [-p<num_pts>] [-r<radius>] [-two]\n",
			argv[0]);
	}
	NPTS = 0;
	RAD = 0.2;
	CRAD = 1.0;
	Twist = 1.0;
	for (i = 1; i < argc; i++)
	{
		if ((argv[i][0] == '-')&&(argv[i][1] == 'p'))
		{
			NPTS = atoi(&argv[i][2]);
		}
		else if ((argv[i][0] == '-')&&(argv[i][1] == 'r'))
		{
			RAD = atof(&argv[i][2]);
			if (RAD <= 0.0)
			{
				fprintf(stderr, "Warning RAD (%f) is too small setting it to 0.2\n", RAD);
				RAD = 0.2;
			}
		}
		else if ((argv[i][0] == '-')&&(argv[i][1] == 'R'))
		{
			CRAD = atof(&argv[i][2]);
			if (CRAD <= 0.0)
			{
				fprintf(stderr, "Warning CRAD (%f) is too small setting it to 1.0\n", CRAD);
				CRAD = 1.0;
			}
		}
		else if ((argv[i][0] == '-')&&(argv[i][1] == 't'))
		{
			Twist = atof(&argv[i][2]);
		}
	}

	if (NPTS == 0)
	{
		fprintf(stderr, "Warning no points argument passed.\n");
		fprintf(stderr, "Setting Number of Points to 20\n");
		NPTS = 20;
	}

	printf("%d\n", ((NPTS + 1) * 4));
	printf("%d\n", (NPTS * 8));
	for (i=0; i<=NPTS; i++)
	{
		f = ((double)i * 2 / NPTS);
		x = CRAD * sin(f * M_PI);
		y = CRAD * cos(f * M_PI);
		turn = ((double)i * Twist / NPTS);
		z = RAD * cos((0.25 + turn) * M_PI);
		x2 = RAD * cos((0.25 - turn) * M_PI);
		y2 = RAD * sin((turn + 0.25) * M_PI);
		printf("%lf %lf %lf\n", x + (x2 * sin(f * M_PI)),
			y + (y2 * cos(f * M_PI)),
			z);
		z = RAD * cos((-0.25 + turn) * M_PI);
		x2 = RAD * cos((-0.25 - turn) * M_PI);
		y2 = RAD * sin((turn - 0.25) * M_PI);
		printf("%lf %lf %lf\n", x + (x2 * sin(f * M_PI)),
			y - (y2 * cos(f * M_PI)),
			-z);
		z = RAD * cos((-0.25 + turn) * M_PI);
		x2 = RAD * cos((-0.25 - turn) * M_PI);
		y2 = RAD * sin((turn - 0.25) * M_PI);
		printf("%lf %lf %lf\n", x - (x2 * sin(f * M_PI)),
			y + (y2 * cos(f * M_PI)),
			z);
		z = RAD * cos((0.25 + turn) * M_PI);
		x2 = RAD * cos((0.25 - turn) * M_PI);
		y2 = RAD * sin((turn + 0.25) * M_PI);
		printf("%lf %lf %lf\n", x - (x2 * sin(f * M_PI)),
			y - (y2 * cos(f * M_PI)),
			-z);
	}

	ta1 = 0;
	ta2 = 1;
	ta3 = 2;
	ta4 = 3;
	tb1 = 4;
	tb2 = 5;
	tb3 = 6;
	tb4 = 7;
	for (i=0; i<NPTS; i++)
	{
		printf("%d %d %d P2\n", ta1, ta2, tb2);
		printf("%d %d %d P2\n", ta1, tb2, tb1);
		printf("%d %d %d P3\n", ta2, ta4, tb4);
		printf("%d %d %d P3\n", ta2, tb4, tb2);
		printf("%d %d %d P4\n", tb3, tb4, ta4);
		printf("%d %d %d P4\n", tb3, ta4, ta3);
		printf("%d %d %d P5\n", ta3, ta1, tb1);
		printf("%d %d %d P5\n", ta3, tb1, tb3);
		ta1 += 4;
		ta2 += 4;
		ta3 += 4;
		ta4 += 4;
		tb1 += 4;
		tb2 += 4;
		tb3 += 4;
		tb4 += 4;
	}
/*
	tb1 = 3;
	tb2 = 2;
	tb3 = 1;
	tb4 = 0;
	printf("%d %d %d P2\n", ta1, ta2, tb2);
	printf("%d %d %d P2\n", ta1, tb2, tb1);
	printf("%d %d %d P3\n", ta2, ta4, tb4);
	printf("%d %d %d P3\n", ta2, tb4, tb2);
	printf("%d %d %d P4\n", tb3, tb4, ta4);
	printf("%d %d %d P4\n", tb3, ta4, ta3);
	printf("%d %d %d P5\n", ta3, ta1, tb1);
	printf("%d %d %d P5\n", ta3, tb1, tb3);
*/

/* The Inside
	ta1 = 0;
	ta2 = 1;
	ta3 = 2;
	ta4 = 3;
	tb1 = 4;
	tb2 = 5;
	tb3 = 6;
	tb4 = 7;
	for (i=0; i<(NPTS - 1); i++)
	{
		printf("%d %d %d P3\n", ta1, tb2, ta2);
		printf("%d %d %d P3\n", ta1, tb1, tb2);
		printf("%d %d %d P3\n", ta2, tb4, ta4);
		printf("%d %d %d P3\n", ta2, tb2, tb4);
		printf("%d %d %d P3\n", tb3, ta4, tb4);
		printf("%d %d %d P3\n", tb3, ta3, ta4);
		printf("%d %d %d P3\n", ta3, tb1, ta1);
		printf("%d %d %d P3\n", ta3, tb3, tb1);
		ta1 += 4;
		ta2 += 4;
		ta3 += 4;
		ta4 += 4;
		tb1 += 4;
		tb2 += 4;
		tb3 += 4;
		tb4 += 4;
	}
	tb1 = 3;
	tb2 = 2;
	tb3 = 1;
	tb4 = 0;
	printf("%d %d %d P3\n", ta1, tb2, ta2);
	printf("%d %d %d P3\n", ta1, tb1, tb2);
	printf("%d %d %d P3\n", ta2, tb4, ta4);
	printf("%d %d %d P3\n", ta2, tb2, tb4);
	printf("%d %d %d P3\n", tb3, ta4, tb4);
	printf("%d %d %d P3\n", tb3, ta3, ta4);
	printf("%d %d %d P3\n", ta3, tb1, ta1);
	printf("%d %d %d P3\n", ta3, tb3, tb1);
*/

	printf("Colormap 256\n");
	printf("red green blue\n");
	printf("0 0 0\n");
	printf("0 0 0\n");
	printf("255 0 0\n");
	printf("0 255 0\n");
	printf("0 0 255\n");
	printf("255 255 255\n");
}

