

#include <stdio.h>
#include <math.h>

extern void InitLattice();
extern double S3Noise();

int NPTS;

main(argc, argv)
    int argc;
    char **argv;
{
	int i, j;
	double x, y, z;
	double xt, yt, zt;
	double freq, amp, nret;
	int t1;

	freq = 32.0;
	amp = 1.0;
	if (argc < 2)
	{
		fprintf(stderr, "Warning no points argument passed.\n");
		fprintf(stderr, "Setting Number of Points to 20\n");
		NPTS = 20;
	}
	else
	{
		NPTS = atoi(argv[1]);
		if (argc > 2)
			freq = atof(argv[2]);
		if (argc > 3)
			amp = atof(argv[3]);
	}
	InitLattice();

	printf("%d\n", (NPTS * NPTS));
	printf("%d\n", ((NPTS - 1) * (NPTS - 1)) * 2);
	for (j=0; j<NPTS; j++)
	{
		y = (((double)j / NPTS) * 4.0) + 62.0;
		for (i=0; i<NPTS; i++)
		{
			x = (((double)i / NPTS) * 4.0) + 62.0;
			z = freq;
			nret = S3Noise(x, y, z);
			z = (amp * nret);
			printf("%lf %lf %lf\n", (x - 63.0) / 4.0, (y - 63.0) / 4.0, z);
		}
	}
	for (j=1; j<NPTS; j++)
	{
		for (i=1; i<NPTS; i++)
		{
			t1 = (j * NPTS) + i;
			printf("%d %d %d\n", t1 - 1 - NPTS, t1 - 1, t1);
			printf("%d %d %d\n", t1 - 1 - NPTS, t1, t1 - NPTS);
		}
	}
}

