

#include <stdio.h>
#include <math.h>

extern void InitLattice();
extern double S3Noise();

int NPTS;

main(argc, argv)
    int argc;
    char **argv;
{
	int i, j;
	double f, x, y, z, x2, y2;
	double freq, amp, nret, xt, yt, zt;
	double peak;
	int t1, t2, t3, t4;

	freq = 2.0;
	amp = 1.0;
	if (argc < 2)
	{
		fprintf(stderr, "Warning no points argument passed.\n");
		fprintf(stderr, "Setting Number of Points to 20\n");
		NPTS = 20;
	}
	else
	{
		NPTS = atoi(argv[1]);
		if (((NPTS / 4) * 4) != NPTS)
		{
			fprintf(stderr, "Warning NPTS (%d) is not a multiple of four\n", NPTS);
			NPTS = ((NPTS / 4) * 4);
			fprintf(stderr, "Setting NPTS  to (%d)\n", NPTS);
		}
		if (argc > 2)
			freq = atof(argv[2]);
		if (argc > 3)
			amp = atof(argv[3]);
	}
	InitLattice();

	printf("%d\n", ((NPTS * ((NPTS / 2) - 1)) + 2));
	printf("%d\n", (((NPTS * 2) * ((NPTS / 2) - 2)) + (NPTS * 2)));
	for (i=0; i<=(NPTS / 2); i++)
	{
		f = ((double)i / (NPTS / 2)) + 0.5;
		x2 = cos(f * M_PI);
		y2 = sin(f * M_PI);
		if ((i > 0) && (i < (NPTS / 2)))
		{
			for (j=0; j<NPTS; j++)
			{
				f = ((double)j * 2) / NPTS;
				xt = x2 * cos(f * M_PI);
				yt = y2;
				zt = x2 * sin(f * M_PI);
				nret = S3Noise(freq * (xt + 1.2), freq * (yt + 1.2), freq * (zt + 1.2));
peak = (1.0 + (amp * nret / freq));
if (peak > 1.4)
	peak = 1.4;
				x = xt * peak;
				y = yt * peak;
				z = zt * peak;
/*
				x = xt * (1.0 + (amp * nret / freq));
				y = yt * (1.0 + (amp * nret / freq));
				z = zt * (1.0 + (amp * nret / freq));
*/
				printf("%lf %lf %lf\n", x, y, z);
			}
		}
		else
		{
			nret = S3Noise(freq * (1.2), freq * (y2 + 1.2), freq * (1.2));
peak = (1.0 + (amp * nret / freq));
if (peak > 1.4)
	peak = 1.4;
			printf("%lf %lf %lf\n", 0.0, y2 * peak, 0.0);
/*
			printf("%lf %lf %lf\n", 0.0, y2 * (1.0 + (amp * nret / freq)), 0.0);
*/
		}
	}

	t1 = 0;
	t2 = 1;
	t3 = 2;
	for (j=1; j<NPTS; j++)
	{
		printf("%d %d %d\n", t1, t2, t3);
		t2++;
		t3++;
	}
	printf("%d %d %d\n", t1, t2, t1 + 1);

	t1 = 1;
	t2 = 2;
	t3 = NPTS + 1;
	t4 = NPTS + 2;
	for (i=2; i<(NPTS / 2); i++)
	{
		for (j=1; j<NPTS; j++)
		{
			printf("%d %d %d\n", t1, t3, t4);
			printf("%d %d %d\n", t1, t4, t2);
			t1++;
			t2++;
			t3++;
			t4++;
		}
		t2 -= NPTS;
		t4 -= NPTS;
		printf("%d %d %d\n", t1, t3, t4);
		printf("%d %d %d\n", t1, t4, t2);
		t1 = t2 + NPTS;
		t2 = t1 + 1;
		t3 = t4 + NPTS;
		t4 = t3 + 1;
	}

	for (j=1; j<NPTS; j++)
	{
		printf("%d %d %d\n", t3, t2, t1);
		t1++;
		t2++;
	}
	printf("%d %d %d\n", t3, t2 - NPTS, t1);
}

