#include <stdio.h>
#include <math.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <X11/StringDefs.h>
#include <Xm/Label.h>
#include <Xm/ScrollBar.h>

#define dfactor 10

extern void doTriangles();

extern Widget xtext;
extern Widget ytext;
extern Widget ztext;
extern Widget dtext;
extern Widget xscrollbar;
extern Widget yscrollbar;
extern Widget zscrollbar;
extern Widget dscrollbar;
extern float view_dist;
extern float distance;


static int xtheta = 0;
static int ytheta = 0;
static int ztheta = 0;
static int old_xtheta = 0;
static int old_ytheta = 0;
static int old_ztheta = 0;
static float old_dist = 0.0;


/*
 * Function to change the text in a Motif label Widget.
 */
void
replaceText(w, s)
	Widget w;
	char *s;
{
	Arg arg[10];
	Cardinal argcnt;
	XmString Mstr;

	Mstr = XmStringCreateSimple(s);
	argcnt = 0;
	XtSetArg(arg[argcnt], XmNlabelString, Mstr); argcnt++;
	XtSetValues(w, arg, argcnt);
	XmStringFree(Mstr);
}

/*
 * One of the scrollbars has been moved.  Figure out what has changed, and
 * change the image data accordingly.
 */
void
Jump(scrollbar, client_data, percent)
	Widget scrollbar;
	caddr_t client_data;
	caddr_t percent;
{
	char lab[80];
	int val, junk1, junk2, junk3;

	XmScrollBarGetValues(scrollbar, &val, &junk1, &junk2, &junk3);
	if (scrollbar == xscrollbar)
	{
		xtheta = -(val);
		sprintf(lab, "X Rotation: %3d Degrees", -xtheta);
   		replaceText(xtext, lab);
	}
	if (scrollbar == yscrollbar)
	{
		ytheta = (val);
		sprintf(lab, "Y Rotation: %3d Degrees", ytheta);
   		replaceText(ytext, lab);
	}
	if (scrollbar == zscrollbar)
	{
		ztheta = -(val);
		sprintf(lab, "Z Rotation: %3d Degrees", -ztheta);
   		replaceText(ztext, lab);
	}
	if (scrollbar == dscrollbar)
	{
		/*
		 * The distance scrollbar varies from (-view_dist) to
		 * (dfactor + view_dist).  This is pretty Arbitrary, but
		 * I have never had a need to make it better.
		 * Note:  I have to subtract 0.00001 to prevent distance
		 *        from ever becoming exactly (-view_dist) as this
		 *        could cause a divide by zero later.
		 */
		distance = (((float)val / 100) * (dfactor + view_dist)) - 
			(view_dist - 0.00001);
		sprintf(lab, "Viewer Distance: %2.1f", distance);
   		replaceText(dtext, lab);
	}
	if ((xtheta != old_xtheta)||(ytheta != old_ytheta)||
		(ztheta != old_ztheta)||(distance != old_dist))
	{
		doTriangles((xtheta - old_xtheta), (ytheta - old_ytheta),
			 (ztheta - old_ztheta), distance);
		old_xtheta = xtheta;
		old_ytheta = ytheta;
		old_ztheta = ztheta;
		old_dist = distance;
	}
}

