#include <Xm/Xm.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <stdio.h>
#include "compact.h"


extern void WriteGif();


extern Display *dsp;
extern Widget drawingcore;
extern Window Dwindow;
extern GC DrawGC;
extern XColor color[];
extern char *Myname;
extern unsigned int Width, Height;
extern int DumpFormat;


int DumpCnt = 0;


/*
 * Takes an XImage dump of depths 1, 2, 4, or 8 and converts it to a
 * an array of unsigned chars for writing to a file.  It mallocs and
 * returns the array of unsigned chars which the caller must later free.
 */
unsigned char *
ImageToData(newimage, width, height, depth)
	XImage *newimage;
	unsigned int width, height, depth;
{
	int h, w;
	int linepad, shiftnum;
	int shiftstart, shiftstop, shiftinc;
	unsigned char shiftmask;
	unsigned char *bit_data, *bitp, *datap;

	if ((depth != 1)&&(depth != 2)&&(depth != 4)&&(depth != 8))
	{
		fprintf(stderr, "%s:  Don't know how to convert image of depth %d to data\n", Myname, depth);
		return(NULL);
	}
	if (BitmapBitOrder(dsp) == LSBFirst)
	{
		shiftstart = 0;
		shiftstop = 8;
		shiftinc = depth;
	}
	else
	{
		shiftstart = 8 - depth;
		shiftstop = -depth;
		shiftinc = -depth;
	}
	shiftmask = 0xff >> (8 - depth);
	linepad = newimage->bytes_per_line - (width / (8/depth));
	bit_data = (unsigned char *)XtMalloc((width * height) + 1);
	bitp = bit_data;
	datap = (unsigned char *)newimage->data;
	for (h=0; h<height; h++)
	{
		shiftnum = shiftstart;
		for (w=0; w<width; w++)
		{
			*bitp++ = (*datap >> shiftnum) & shiftmask;
			shiftnum = shiftnum + shiftinc;
			if (shiftnum == shiftstop)
			{
				shiftnum = shiftstart;
				datap++;
			}
		}
		for (w=0; w<linepad; w++)
		{
			datap++;
		}
	}
	return(bit_data);
}


/*
 * Write the image dump as a .ebc file.  Yes , I know, YET ANOTHER IMAGE FORMAT!
 * Sorry, but I couldn't decide from the many already around, so I made my
 * own.
 */
void
WriteEbcFile(filename, data, width, height, colrs)
	char *filename;
	unsigned char *data;
	unsigned int width, height;
	XColor *colrs;
{
	FILE *fp;
	int i;
	struct ebmhdr Hdr;
	struct rgb_color ebmColor[256];

	if (strcmp(filename, "") == 0)
	{
		fp = NULL;
	}
	else
	{
		fp = fopen(filename, "w");
	}
	if (fp == NULL)
	{
		fprintf(stderr, "%s: cannot open %s for writing\n",
			Myname, filename);
		fclose(fp);
	}
	else
	{
		strcpy(Hdr.magic, "xstitch");
		Hdr.width = width;
		Hdr.height = height;
		Hdr.num_colors = 256;
		fwrite(&Hdr, sizeof(struct ebmhdr), 1, fp);

		for (i=0; i<256; i++)
		{
			ebmColor[i].red = colrs[i].red / 256;;
			ebmColor[i].green = colrs[i].green / 256;;
			ebmColor[i].blue = colrs[i].blue / 256;;
			ebmColor[i].pix_len = 0;
			fwrite(&ebmColor[i], sizeof(struct rgb_color), 1, fp);
		}

		fwrite(data, sizeof(unsigned char), (width * height), fp);

		fclose(fp);
	}
}


/*
 * Dump the current view area as an .ebc image file.
 */
void
Dump(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	char filename[256];
	unsigned char *imagedata;
	XImage *grabImage;

	if (XtIsManaged(drawingcore))
	{
		XSetSubwindowMode(dsp, DrawGC, IncludeInferiors);
		XFlush(dsp);
		grabImage = XGetImage(dsp, Dwindow, 0, 0,
			Width, Height, AllPlanes, ZPixmap);
		imagedata = ImageToData(grabImage, Width, Height,
			DefaultDepth(dsp, DefaultScreen(dsp)));
		XDestroyImage(grabImage);
		XSetSubwindowMode(dsp, DrawGC, ClipByChildren);
		sprintf(filename, "dump%03d", DumpCnt);
		DumpCnt++;
		if (DumpFormat == EBC)
		{
			strcat(filename, ".ebc");
			WriteEbcFile(filename, imagedata, Width, Height, color);
		}
		else if (DumpFormat == GIF)
		{
			strcat(filename, ".gif");
			WriteGif(filename, imagedata, Width, Height, color);
		}
		XtFree(imagedata);
	}
}

