#include <X11/Intrinsic.h>
#include "color.h"


extern Display	*dsp;
extern Colormap	Cmap;
extern int	NumCells;


struct col_rec Colors[256];


/*
 * Allocate a greyscale colormap
 */
GetShades()
{
	int i;
	XColor	cols[256];

	for (i=0; i<NumCells; i++)
	{
		cols[i].pixel = i;
	}
	XQueryColors(dsp, Cmap, cols, NumCells);
	for (i=0; i<NumCells; i++)
	{
		Colors[i].red = cols[i].red / (65536 / NumCells);
		Colors[i].green = cols[i].green / (65536 / NumCells);
		Colors[i].blue = cols[i].blue / (65536 / NumCells);
	}
}

