#include <stdio.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <X11/StringDefs.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/FileSB.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/ScrollBar.h>
#include <Xm/PushB.h>
#include <Xm/ArrowB.h>
#include <Xm/DialogS.h>

#define	DEF_BLACK	BlackPixel(dsp, DefaultScreen(dsp))
#define	DEF_WHITE	WhitePixel(dsp, DefaultScreen(dsp))

#define MSTR(str)	XmStringCreateSimple((str))

#define RIGHT           0
#define LEFT            1
#define UP              2
#define DOWN            3
#define FORWARD         4
#define BACK            5


extern void Jump();
extern void Exit();
extern void XRot();
extern void XRotStop();
extern void Detail();
extern void DetailZero();
extern void Shade();
extern void Lattice();
extern void Show();
extern void Dump();
extern void Edit();
extern void ReadScript();
extern void ChangePerspective();
extern void Mapping();
extern void SelectCall();
extern void DeleteCall();
extern void SetLink();
extern void SetAdd();
extern void Size();
extern void Read();
extern void Write();
extern void ControlExpose();
extern void ArrowPushed();
extern void ArrowReleased();

extern Display *dsp;
extern Widget top;
extern XtTranslations commandTable;
extern int NumCells;
extern Colormap Cmap;
extern unsigned int Width, Height;
extern int LowMem;


Widget developarea;
Widget menu_bar;
Widget drawingshell;
Widget controlshell;
Widget listshell;
Widget fileshell;
Widget drawingcore;
Widget listlist;
Widget controlform;
Widget upbutton;
Widget leftbutton;
Widget rightbutton;
Widget downbutton;
Widget backbutton;
Widget forwardbutton;
Widget filebox;
Widget xyzdform;
Widget xyzdlabel;
Widget xscrollbar;
Widget yscrollbar;
Widget zscrollbar;
Widget dscrollbar;
Widget xtext;
Widget ytext;
Widget ztext;
Widget dtext;
Widget command_cascade;
Widget texture_cascade;
Widget detail_cascade;
Widget file_cascade;
Widget edit_cascade;
Widget command_menu;
Widget texture_menu;
Widget detail_menu;
Widget file_menu;
Widget edit_menu;
Widget quitcommand;
Widget showcommand;
Widget dumpcommand;
Widget selectcommand;
Widget deletecommand;
Widget addcommand;
Widget linkcommand;
Widget scriptcommand;
Widget perspectivecommand;
Widget detailcommand[10];
Widget wirecommand;
Widget shadecommand;
Widget firecommand;
Widget granitecommand;
Widget marblecommand;
Widget woodcommand;
Widget basecommand;
Widget bshadecommand;
Widget readcommand;
Widget writecommand;
Widget lattice;
Window Dwindow;;
Arg		arg[50];
Cardinal	argcnt;


static XtCallbackRec ArrowList[] = {
  {  (XtCallbackProc)ArrowPushed, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec ArrowList2[] = {
  {  (XtCallbackProc)ArrowReleased, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec JumpList[] = {
  {  (XtCallbackProc)Jump, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec ExitList[] = {
  {  (XtCallbackProc)Exit, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec DetailList[] = {
  {  (XtCallbackProc)Detail, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec DetailZList[] = {
  {  (XtCallbackProc)DetailZero, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec ShadeList[] = {
  {  (XtCallbackProc)Shade, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec LatList[] = {
  {  (XtCallbackProc)Lattice, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec ShowList[] = {
  {  (XtCallbackProc)Show, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec DumpList[] = {
  {  (XtCallbackProc)Dump, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec ScriptList[] = {
  {  (XtCallbackProc)ReadScript, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec EditList[] = {
  {  (XtCallbackProc)Edit, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec PerspectiveList[] = {
  {  (XtCallbackProc)ChangePerspective, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec MapList[] = {
  {  (XtCallbackProc)Mapping, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec SelectList[] = {
  {  (XtCallbackProc)SelectCall, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec DeleteList[] = {
  {  (XtCallbackProc)DeleteCall, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec LinkList[] = {
  {  (XtCallbackProc)SetLink, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec AddList[] = {
  {  (XtCallbackProc)SetAdd, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec SizList[] = {
  {  (XtCallbackProc)Size, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec ReadList[] = {
  {  (XtCallbackProc)Read, NULL  },
  {  NULL, NULL  }
};

static XtCallbackRec WriteList[] = {
  {  (XtCallbackProc)Write, NULL  },
  {  NULL, NULL  }
};

/*
 * Really awful and old code to make the Motif windows, but it works, so I
 * don't feel like rewriting it.
 */
void
MakeWidgets()
{
int i;
char buf[100];

argcnt = 0;
/*
XtSetArg(arg[argcnt], XtNbackground, DEF_BLACK); argcnt++;
*/
  developarea = XtCreateManagedWidget(
                                    "developarea",
                                    xmFormWidgetClass,
                                    top,
                                    arg,
                                    argcnt);
argcnt = 0;
/*
XtSetArg(arg[argcnt], XtNbackground, DEF_BLACK); argcnt++;
*/
  menu_bar = XmCreateMenuBar(
				    developarea, 
                                    "menu_bar",
                                    arg,
                                    argcnt);
XtManageChild(menu_bar);
argcnt = 0;
XtSetArg(arg[argcnt], XmNallowShellResize, True); argcnt++;
  drawingshell = XtCreatePopupShell(
                                    "drawingshell",
                                    xmDialogShellWidgetClass,
                                    developarea,
                                    arg,
                                    argcnt);
XtManageChild(drawingshell);
argcnt = 0;
XtSetArg(arg[argcnt], XmNheight, Height); argcnt++;
XtSetArg(arg[argcnt], XmNwidth, Width); argcnt++;
XtSetArg(arg[argcnt], XmNbackground, DEF_BLACK); argcnt++;
XtSetArg(arg[argcnt], XmNresizePolicy, XmRESIZE_ANY); argcnt++;
XtSetArg(arg[argcnt], XmNinputCallback, SelectList); argcnt++;
XtSetArg(arg[argcnt], XmNexposeCallback, MapList); argcnt++;
XtSetArg(arg[argcnt], XmNresizeCallback, SizList); argcnt++;
  drawingcore = XtCreateWidget(
                                    "drawingcore",
                                    xmDrawingAreaWidgetClass,
                                    drawingshell,
                                    arg,
                                    argcnt);

/*EJB*/
argcnt = 0;
XtSetArg(arg[argcnt], XmNallowShellResize, True); argcnt++;
  listshell = XtCreatePopupShell(
                                    "listshell",
                                    xmDialogShellWidgetClass,
                                    developarea,
                                    arg,
                                    argcnt);
XtManageChild(listshell);
argcnt = 0;
XtSetArg(arg[argcnt], XmNwidth, 100); argcnt++;
XtSetArg(arg[argcnt], XmNheight, 1); argcnt++;
XtSetArg(arg[argcnt], XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE); argcnt++;
  listlist = XtCreateWidget(
                                    "listlist",
                                    xmListWidgetClass,
                                    listshell,
                                    arg,
                                    argcnt);
/*EJB*/

argcnt = 0;
XtSetArg(arg[argcnt], XmNallowShellResize, True); argcnt++;
  controlshell = XtCreatePopupShell(
                                    "controlshell",
                                    xmDialogShellWidgetClass,
                                    developarea,
                                    arg,
                                    argcnt);
XtManageChild(controlshell);
argcnt = 0;
XtSetArg(arg[argcnt], XmNwidth, 100); argcnt++;
XtSetArg(arg[argcnt], XmNheight, 100); argcnt++;
XtSetArg(arg[argcnt], XmNrubberPositioning, False); argcnt++;
  controlform = XtCreateWidget(
                                    "controlform",
                                    xmFormWidgetClass,
                                    controlshell,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNtraversalOn, False); argcnt++;
XtSetArg(arg[argcnt], XmNtopAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNbottomAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNrightAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNtopPosition, 2); argcnt++;
XtSetArg(arg[argcnt], XmNbottomPosition, 22); argcnt++;
XtSetArg(arg[argcnt], XmNleftPosition, 40); argcnt++;
XtSetArg(arg[argcnt], XmNrightPosition, 60); argcnt++;
XtSetArg(arg[argcnt], XmNarrowDirection, XmARROW_UP); argcnt++;
XtSetArg(arg[argcnt], XmNshadowThickness, 0); argcnt++;
ArrowList[0].closure = (caddr_t)UP;
XtSetArg(arg[argcnt], XmNarmCallback, ArrowList); argcnt++;
XtSetArg(arg[argcnt], XmNdisarmCallback, ArrowList2); argcnt++;
  upbutton = XtCreateWidget(
                                    "upbutton",
                                    xmArrowButtonWidgetClass,
                                    controlform,
                                    arg,
                                    argcnt);
XtManageChild(upbutton);
argcnt = 0;
XtSetArg(arg[argcnt], XmNtraversalOn, False); argcnt++;
XtSetArg(arg[argcnt], XmNtopAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNbottomAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNrightAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNtopPosition, 40); argcnt++;
XtSetArg(arg[argcnt], XmNbottomPosition, 60); argcnt++;
XtSetArg(arg[argcnt], XmNleftPosition, 2); argcnt++;
XtSetArg(arg[argcnt], XmNrightPosition, 22); argcnt++;
XtSetArg(arg[argcnt], XmNarrowDirection, XmARROW_LEFT); argcnt++;
XtSetArg(arg[argcnt], XmNshadowThickness, 0); argcnt++;
ArrowList[0].closure = (caddr_t)LEFT;
XtSetArg(arg[argcnt], XmNarmCallback, ArrowList); argcnt++;
XtSetArg(arg[argcnt], XmNdisarmCallback, ArrowList2); argcnt++;
  leftbutton = XtCreateWidget(
                                    "leftbutton",
                                    xmArrowButtonWidgetClass,
                                    controlform,
                                    arg,
                                    argcnt);
XtManageChild(leftbutton);
argcnt = 0;
XtSetArg(arg[argcnt], XmNtraversalOn, False); argcnt++;
XtSetArg(arg[argcnt], XmNtopAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNbottomAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNrightAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNtopPosition, 40); argcnt++;
XtSetArg(arg[argcnt], XmNbottomPosition, 60); argcnt++;
XtSetArg(arg[argcnt], XmNrightPosition, 98); argcnt++;
XtSetArg(arg[argcnt], XmNleftPosition, 78); argcnt++;
XtSetArg(arg[argcnt], XmNarrowDirection, XmARROW_RIGHT); argcnt++;
XtSetArg(arg[argcnt], XmNshadowThickness, 0); argcnt++;
ArrowList[0].closure = (caddr_t)RIGHT;
XtSetArg(arg[argcnt], XmNarmCallback, ArrowList); argcnt++;
XtSetArg(arg[argcnt], XmNdisarmCallback, ArrowList2); argcnt++;
  rightbutton = XtCreateWidget(
                                    "rightbutton",
                                    xmArrowButtonWidgetClass,
                                    controlform,
                                    arg,
                                    argcnt);
XtManageChild(rightbutton);
argcnt = 0;
XtSetArg(arg[argcnt], XmNtraversalOn, False); argcnt++;
XtSetArg(arg[argcnt], XmNtopAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNbottomAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNrightAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNtopPosition, 78); argcnt++;
XtSetArg(arg[argcnt], XmNbottomPosition, 98); argcnt++;
XtSetArg(arg[argcnt], XmNrightPosition, 60); argcnt++;
XtSetArg(arg[argcnt], XmNleftPosition, 40); argcnt++;
XtSetArg(arg[argcnt], XmNarrowDirection, XmARROW_DOWN); argcnt++;
XtSetArg(arg[argcnt], XmNshadowThickness, 0); argcnt++;
ArrowList[0].closure = (caddr_t)DOWN;
XtSetArg(arg[argcnt], XmNarmCallback, ArrowList); argcnt++;
XtSetArg(arg[argcnt], XmNdisarmCallback, ArrowList2); argcnt++;
  downbutton = XtCreateWidget(
                                    "downbutton",
                                    xmArrowButtonWidgetClass,
                                    controlform,
                                    arg,
                                    argcnt);
XtManageChild(downbutton);
argcnt = 0;
XtSetArg(arg[argcnt], XmNtraversalOn, False); argcnt++;
XtSetArg(arg[argcnt], XmNtopAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNbottomAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNrightAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNtopPosition, 2); argcnt++;
XtSetArg(arg[argcnt], XmNbottomPosition, 22); argcnt++;
XtSetArg(arg[argcnt], XmNrightPosition, 98); argcnt++;
XtSetArg(arg[argcnt], XmNleftPosition, 78); argcnt++;
XtSetArg(arg[argcnt], XmNarrowDirection, XmARROW_DOWN); argcnt++;
XtSetArg(arg[argcnt], XmNshadowThickness, 0); argcnt++;
ArrowList[0].closure = (caddr_t)BACK;
XtSetArg(arg[argcnt], XmNarmCallback, ArrowList); argcnt++;
XtSetArg(arg[argcnt], XmNdisarmCallback, ArrowList2); argcnt++;
  backbutton = XtCreateWidget(
                                    "backbutton",
                                    xmArrowButtonWidgetClass,
                                    controlform,
                                    arg,
                                    argcnt);
XtManageChild(backbutton);
argcnt = 0;
XtSetArg(arg[argcnt], XmNtraversalOn, False); argcnt++;
XtSetArg(arg[argcnt], XmNtopAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNbottomAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNrightAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
XtSetArg(arg[argcnt], XmNtopPosition, 78); argcnt++;
XtSetArg(arg[argcnt], XmNbottomPosition, 98); argcnt++;
XtSetArg(arg[argcnt], XmNrightPosition, 22); argcnt++;
XtSetArg(arg[argcnt], XmNleftPosition, 2); argcnt++;
XtSetArg(arg[argcnt], XmNarrowDirection, XmARROW_UP); argcnt++;
XtSetArg(arg[argcnt], XmNshadowThickness, 0); argcnt++;
ArrowList[0].closure = (caddr_t)FORWARD;
XtSetArg(arg[argcnt], XmNarmCallback, ArrowList); argcnt++;
XtSetArg(arg[argcnt], XmNdisarmCallback, ArrowList2); argcnt++;
  forwardbutton = XtCreateWidget(
                                    "forwardbutton",
                                    xmArrowButtonWidgetClass,
                                    controlform,
                                    arg,
                                    argcnt);
XtManageChild(forwardbutton);
argcnt = 0;
XtSetArg(arg[argcnt], XmNallowShellResize, True); argcnt++;
  fileshell = XtCreatePopupShell(
                                    "fileshell",
                                    xmDialogShellWidgetClass,
                                    developarea,
                                    arg,
                                    argcnt);
XtManageChild(fileshell);
argcnt = 0;
/*
XtSetArg(arg[argcnt], XmNautoUnmanage, True); argcnt++;
*/
  filebox = XtCreateWidget(
                                    "filebox",
                                    xmFileSelectionBoxWidgetClass,
                                    fileshell,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNtraversalOn, False); argcnt++;
XtSetArg(arg[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
XtSetArg(arg[argcnt], XmNtopWidget, menu_bar); argcnt++;
XtSetArg(arg[argcnt], XmNtopOffset, 2); argcnt++;
XtSetArg(arg[argcnt], XmNbottomAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
XtSetArg(arg[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNwidth, 370); argcnt++;
XtSetArg(arg[argcnt], XmNheight, 20); argcnt++;
XtSetArg(arg[argcnt], XmNmaximum, 370); argcnt++;
XtSetArg(arg[argcnt], XmNminimum, 0); argcnt++;
XtSetArg(arg[argcnt], XmNincrement, 1); argcnt++;
XtSetArg(arg[argcnt], XmNpageIncrement, 1); argcnt++;
XtSetArg(arg[argcnt], XmNorientation, XmHORIZONTAL); argcnt++;
XtSetArg(arg[argcnt], XmNprocessingDirection, XmMAX_ON_RIGHT); argcnt++;
XtSetArg(arg[argcnt], XmNsliderSize, 10); argcnt++;
XtSetArg(arg[argcnt], XmNrepeatDelay, 1); argcnt++;
XtSetArg(arg[argcnt], XmNvalue, 0); argcnt++;
XtSetArg(arg[argcnt], XmNdragCallback, JumpList); argcnt++;
XtSetArg(arg[argcnt], XmNvalueChangedCallback, JumpList); argcnt++;
  xscrollbar = XmCreateScrollBar(
                                    developarea,
                                    "xscrollbar",
                                    arg,
                                    argcnt);
  XtManageChild(xscrollbar);
/*
  xscrollbar = XtCreateManagedWidget(
                                    "xscrollbar",
                                    xmScrollBarWidgetClass,
                                    developarea,
                                    arg,
                                    argcnt);
*/
argcnt = 0;
XtSetArg(arg[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
XtSetArg(arg[argcnt], XmNtopWidget, xscrollbar); argcnt++;
XtSetArg(arg[argcnt], XmNbottomAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
XtSetArg(arg[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("X Rotation:   0 Degrees")); argcnt++;
  xtext = XtCreateManagedWidget(
                                    "xtext",
                                    xmLabelWidgetClass,
                                    developarea,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNtraversalOn, False); argcnt++;
XtSetArg(arg[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
XtSetArg(arg[argcnt], XmNtopWidget, xtext); argcnt++;
XtSetArg(arg[argcnt], XmNtopOffset, 10); argcnt++;
XtSetArg(arg[argcnt], XmNbottomAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
XtSetArg(arg[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNwidth, 370); argcnt++;
XtSetArg(arg[argcnt], XmNheight, 20); argcnt++;
XtSetArg(arg[argcnt], XmNmaximum, 370); argcnt++;
XtSetArg(arg[argcnt], XmNminimum, 0); argcnt++;
XtSetArg(arg[argcnt], XmNincrement, 1); argcnt++;
XtSetArg(arg[argcnt], XmNpageIncrement, 1); argcnt++;
XtSetArg(arg[argcnt], XmNorientation, XmHORIZONTAL); argcnt++;
XtSetArg(arg[argcnt], XmNprocessingDirection, XmMAX_ON_RIGHT); argcnt++;
XtSetArg(arg[argcnt], XmNsliderSize, 10); argcnt++;
XtSetArg(arg[argcnt], XmNrepeatDelay, 1); argcnt++;
XtSetArg(arg[argcnt], XmNvalue, 0); argcnt++;
XtSetArg(arg[argcnt], XmNdragCallback, JumpList); argcnt++;
XtSetArg(arg[argcnt], XmNvalueChangedCallback, JumpList); argcnt++;
  yscrollbar = XtCreateManagedWidget(
                                    "yscrollbar",
                                    xmScrollBarWidgetClass,
                                    developarea,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
XtSetArg(arg[argcnt], XmNtopWidget, yscrollbar); argcnt++;
XtSetArg(arg[argcnt], XmNbottomAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
XtSetArg(arg[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Y Rotation:   0 Degrees")); argcnt++;
  ytext = XtCreateManagedWidget(
                                    "ytext",
                                    xmLabelWidgetClass,
                                    developarea,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNtraversalOn, False); argcnt++;
XtSetArg(arg[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
XtSetArg(arg[argcnt], XmNtopWidget, ytext); argcnt++;
XtSetArg(arg[argcnt], XmNtopOffset, 10); argcnt++;
XtSetArg(arg[argcnt], XmNbottomAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
XtSetArg(arg[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNwidth, 370); argcnt++;
XtSetArg(arg[argcnt], XmNheight, 20); argcnt++;
XtSetArg(arg[argcnt], XmNmaximum, 370); argcnt++;
XtSetArg(arg[argcnt], XmNminimum, 0); argcnt++;
XtSetArg(arg[argcnt], XmNincrement, 1); argcnt++;
XtSetArg(arg[argcnt], XmNpageIncrement, 1); argcnt++;
XtSetArg(arg[argcnt], XmNorientation, XmHORIZONTAL); argcnt++;
XtSetArg(arg[argcnt], XmNprocessingDirection, XmMAX_ON_RIGHT); argcnt++;
XtSetArg(arg[argcnt], XmNsliderSize, 10); argcnt++;
XtSetArg(arg[argcnt], XmNrepeatDelay, 1); argcnt++;
XtSetArg(arg[argcnt], XmNvalue, 0); argcnt++;
XtSetArg(arg[argcnt], XmNdragCallback, JumpList); argcnt++;
XtSetArg(arg[argcnt], XmNvalueChangedCallback, JumpList); argcnt++;
  zscrollbar = XtCreateManagedWidget(
                                    "zscrollbar",
                                    xmScrollBarWidgetClass,
                                    developarea,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
XtSetArg(arg[argcnt], XmNtopWidget, zscrollbar); argcnt++;
XtSetArg(arg[argcnt], XmNbottomAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
XtSetArg(arg[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Z Rotation:   0 Degrees")); argcnt++;
  ztext = XtCreateManagedWidget(
                                    "ztext",
                                    xmLabelWidgetClass,
                                    developarea,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNtraversalOn, False); argcnt++;
XtSetArg(arg[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
XtSetArg(arg[argcnt], XmNtopWidget, ztext); argcnt++;
XtSetArg(arg[argcnt], XmNtopOffset, 10); argcnt++;
XtSetArg(arg[argcnt], XmNbottomAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
XtSetArg(arg[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNwidth, 370); argcnt++;
XtSetArg(arg[argcnt], XmNheight, 20); argcnt++;
XtSetArg(arg[argcnt], XmNmaximum, 100); argcnt++;
XtSetArg(arg[argcnt], XmNminimum, 0); argcnt++;
XtSetArg(arg[argcnt], XmNincrement, 1); argcnt++;
XtSetArg(arg[argcnt], XmNpageIncrement, 1); argcnt++;
XtSetArg(arg[argcnt], XmNorientation, XmHORIZONTAL); argcnt++;
XtSetArg(arg[argcnt], XmNprocessingDirection, XmMAX_ON_RIGHT); argcnt++;
XtSetArg(arg[argcnt], XmNsliderSize, 3); argcnt++;
XtSetArg(arg[argcnt], XmNrepeatDelay, 1); argcnt++;
XtSetArg(arg[argcnt], XmNvalue, 28); argcnt++;
XtSetArg(arg[argcnt], XmNdragCallback, JumpList); argcnt++;
XtSetArg(arg[argcnt], XmNvalueChangedCallback, JumpList); argcnt++;
  dscrollbar = XtCreateManagedWidget(
                                    "dscrollbar",
                                    xmScrollBarWidgetClass,
                                    developarea,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
XtSetArg(arg[argcnt], XmNtopWidget, dscrollbar); argcnt++;
XtSetArg(arg[argcnt], XmNbottomAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
XtSetArg(arg[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Viewer Distance:  0.0")); argcnt++;
  dtext = XtCreateManagedWidget(
                                    "dtext",
                                    xmLabelWidgetClass,
                                    developarea,
                                    arg,
                                    argcnt);
argcnt = 0;
  command_menu = XmCreatePulldownMenu(
				    menu_bar,
				    "command_menu",
				    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNsubMenuId, command_menu); argcnt++;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Commands")); argcnt++;
  command_cascade = XtCreateManagedWidget(
                                    "command_cascade",
                                    xmCascadeButtonWidgetClass,
                                    menu_bar,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Display")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, ShowList); argcnt++;
  showcommand = XtCreateManagedWidget(
                                    "showcommand",
                                    xmPushButtonWidgetClass,
                                    command_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Dump")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, DumpList); argcnt++;
  dumpcommand = XtCreateManagedWidget(
                                    "dumpcommand",
                                    xmPushButtonWidgetClass,
                                    command_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Perspective")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, PerspectiveList); argcnt++;
  perspectivecommand = XtCreateManagedWidget(
                                    "perspectivecommand",
                                    xmPushButtonWidgetClass,
                                    command_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Lattice")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, LatList); argcnt++;
  lattice = XtCreateManagedWidget(
                                    "lattice",
                                    xmPushButtonWidgetClass,
                                    command_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Quit")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, ExitList); argcnt++;
  quitcommand = XtCreateManagedWidget(
                                    "quitcommand",
                                    xmPushButtonWidgetClass,
                                    command_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
  file_menu = XmCreatePulldownMenu(
				    menu_bar,
				    "file_menu",
				    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNsubMenuId, file_menu); argcnt++;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("File")); argcnt++;
  file_cascade = XtCreateManagedWidget(
                                    "file_cascade",
                                    xmCascadeButtonWidgetClass,
                                    menu_bar,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Read")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, ReadList); argcnt++;
  readcommand = XtCreateManagedWidget(
                                    "readcommand",
                                    xmPushButtonWidgetClass,
                                    file_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Write")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, WriteList); argcnt++;
  writecommand = XtCreateManagedWidget(
                                    "writecommand",
                                    xmPushButtonWidgetClass,
                                    file_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Read Script")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, ScriptList); argcnt++;
  scriptcommand = XtCreateManagedWidget(
                                    "scriptcommand",
                                    xmPushButtonWidgetClass,
                                    file_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
  edit_menu = XmCreatePulldownMenu(
				    menu_bar,
				    "edit_menu",
				    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNsubMenuId, edit_menu); argcnt++;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Edit")); argcnt++;
  edit_cascade = XtCreateManagedWidget(
                                    "edit_cascade",
                                    xmCascadeButtonWidgetClass,
                                    menu_bar,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Select")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, EditList); argcnt++;
  selectcommand = XtCreateManagedWidget(
                                    "selectcommand",
                                    xmPushButtonWidgetClass,
                                    edit_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Delete")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, DeleteList); argcnt++;
  deletecommand = XtCreateManagedWidget(
                                    "deletecommand",
                                    xmPushButtonWidgetClass,
                                    edit_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Add Triangle")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, AddList); argcnt++;
  addcommand = XtCreateManagedWidget(
                                    "addcommand",
                                    xmPushButtonWidgetClass,
                                    edit_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Link Triangle")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, LinkList); argcnt++;
  linkcommand = XtCreateManagedWidget(
                                    "linkcommand",
                                    xmPushButtonWidgetClass,
                                    edit_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
  detail_menu = XmCreatePulldownMenu(
				    menu_bar,
				    "detail_menu",
				    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNsubMenuId, detail_menu); argcnt++;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Detail")); argcnt++;
  detail_cascade = XtCreateManagedWidget(
                                    "detail_cascade",
                                    xmCascadeButtonWidgetClass,
                                    menu_bar,
                                    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNlabelString, MSTR(" *0  ")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, DetailZList); argcnt++;
  detailcommand[0] = XtCreateManagedWidget(
                                    "detail_0",
                                    xmPushButtonWidgetClass,
                                    detail_menu,
                                    arg,
                                    argcnt);
for (i=1; i<=9; i++)
{
	argcnt = 0;
	DetailList[0].closure = (caddr_t)i;
	sprintf(buf, "  %1d  ", i);
	XtSetArg(arg[argcnt], XmNlabelString, MSTR(buf)); argcnt++;
	XtSetArg(arg[argcnt], XmNactivateCallback, DetailList); argcnt++;
  	  detailcommand[i] = XtCreateManagedWidget(
                                    "detail_N",
                                    xmPushButtonWidgetClass,
                                    detail_menu,
                                    arg,
                                    argcnt);
}
argcnt = 0;
  texture_menu = XmCreatePulldownMenu(
				    menu_bar,
				    "texture_menu",
				    arg,
                                    argcnt);
argcnt = 0;
XtSetArg(arg[argcnt], XmNsubMenuId, texture_menu); argcnt++;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("Textures")); argcnt++;
  texture_cascade = XtCreateManagedWidget(
                                    "texture_cascade",
                                    xmCascadeButtonWidgetClass,
                                    menu_bar,
                                    arg,
                                    argcnt);
argcnt = 0;
ShadeList[0].closure = 0;
XtSetArg(arg[argcnt], XmNlabelString, MSTR("*Wire")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, ShadeList); argcnt++;
  wirecommand = XtCreateManagedWidget(
                                    "wirecommand",
                                    xmPushButtonWidgetClass,
                                    texture_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
ShadeList[0].closure = (caddr_t)1;
XtSetArg(arg[argcnt], XmNlabelString, MSTR(" Shade")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, ShadeList); argcnt++;
  shadecommand = XtCreateManagedWidget(
                                    "shadecommand",
                                    xmPushButtonWidgetClass,
                                    texture_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
ShadeList[0].closure = (caddr_t)2;
XtSetArg(arg[argcnt], XmNlabelString, MSTR(" Fire")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, ShadeList); argcnt++;
  firecommand = XtCreateManagedWidget(
                                    "firecommand",
                                    xmPushButtonWidgetClass,
                                    texture_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
ShadeList[0].closure = (caddr_t)3;
XtSetArg(arg[argcnt], XmNlabelString, MSTR(" Granite")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, ShadeList); argcnt++;
  granitecommand = XtCreateManagedWidget(
                                    "granitecommand",
                                    xmPushButtonWidgetClass,
                                    texture_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
ShadeList[0].closure = (caddr_t)4;
XtSetArg(arg[argcnt], XmNlabelString, MSTR(" Marble")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, ShadeList); argcnt++;
  marblecommand = XtCreateManagedWidget(
                                    "marblecommand",
                                    xmPushButtonWidgetClass,
                                    texture_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
ShadeList[0].closure = (caddr_t)5;
XtSetArg(arg[argcnt], XmNlabelString, MSTR(" Wood")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, ShadeList); argcnt++;
  woodcommand = XtCreateManagedWidget(
                                    "woodcommand",
                                    xmPushButtonWidgetClass,
                                    texture_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
ShadeList[0].closure = (caddr_t)6;
XtSetArg(arg[argcnt], XmNlabelString, MSTR(" BaseColor")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, ShadeList); argcnt++;
  basecommand = XtCreateManagedWidget(
                                    "basecommand",
                                    xmPushButtonWidgetClass,
                                    texture_menu,
                                    arg,
                                    argcnt);
argcnt = 0;
ShadeList[0].closure = (caddr_t)7;
XtSetArg(arg[argcnt], XmNlabelString, MSTR(" BaseShade")); argcnt++;
XtSetArg(arg[argcnt], XmNactivateCallback, ShadeList); argcnt++;
  bshadecommand = XtCreateManagedWidget(
                                    "bshadecommand",
                                    xmPushButtonWidgetClass,
                                    texture_menu,
                                    arg,
                                    argcnt);
  XtRealizeWidget(top);
  XSetWindowColormap(dsp, XtWindow(drawingshell), Cmap);
  Dwindow = XtWindow(drawingcore);

   XtAddEventHandler(controlform, ExposureMask, FALSE,
                ControlExpose, NULL);

  if (LowMem)
  {
	XtSetSensitive(detail_cascade, False);
	XtSetSensitive(deletecommand, False);
	XtSetSensitive(addcommand, False);
	XtSetSensitive(linkcommand, False);
  }
}

