/* CodeGenerator.C */

#include "CodeGenerator.h"
// Super Class : None

/*oodB%CodeGenerator*** Global Declarations and Stuffs ****/
 
/*oodE*****************************************************/

CodeGenerator::CodeGenerator(char * name)
{
	init(name);
}

CodeGenerator::~CodeGenerator()
{
	// Empty
}

void CodeGenerator::init(char * name)
{
  strcpy(_application,name);
  set_options();
}

void CodeGenerator::set_options(void)
{
  OptionEditor *oe;
  oe = guide->get_OptionEditor();

  option_rec * options = oe->get_options();
  strcpy(_event_file,options->event_filename);
  strcpy(_public_file,options->public_filename);
  strcpy(_callback_file,options->callback_filename);
  strcpy(_interface_file,"interface.c");
  strcpy(_project_dir,options->project_directory);
  strcpy(_pixmap_dir,options->pixmap_directory);
  strcpy(_resource_dir,options->resource_directory);
  strcpy(_includes,options->includes);
  strcpy(_motif_lib,options->motif_lib);
  strcpy(_xt_lib,options->xt_lib);
  strcpy(_x11_lib,options->x11_lib);
  strcpy(_c_compiler,options->c_compiler);
  strcpy(_c_flags,options->c_flags);
  strcpy(_cpp_compiler,options->cpp_compiler);
  strcpy(_cpp_flags,options->cpp_flags);
}

void CodeGenerator::generate_code(widget_type_enum type,
				  ofstream *output,
				  WidgetObj * wo)
{
  char code[1024];
  char TAB[] = "  "; 

  cout << "generating code for " << widget_name[wo->get_type()] << "\n";

  if(wo->is_real())
  switch(type){
    case applicationshell_v:
      *output << "\n\n  XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;\n"
              << "  XtSetArg(al[ac], XmNargc, argc); ac++;\n"
	      << "  XtSetArg(al[ac], XmNargv, argv); ac++;\n"
	      << "  " << wo->get_variable_name() 
	      << " = XtAppCreateShell ( argv[0],\n"
	      << "                          \""
	      << _application << "\",\n"
	      << "                          applicationShellWidgetClass,\n"
	      << "                          display, al, ac );\n";
      break;
    case toplevelshell_v:
      *output << "\n\n  XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;\n"
              << "  XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;\n"
	      << "  " << wo->get_variable_name()
	      << " = XtCreatePopupShell (\""
	      << wo->get_widget_name()
	      << "\",\n                            topLevelShellWidgetClass,\n" 
	      << "                            parent, al, ac );\n";
      break;
    case arrowbutton_v:
     generate_XmCreateObject("XmCreateArrowButton",output,wo);
     break;
    case arrowbuttongadget_v:
     generate_XmCreateObject("XmCreateArrowButtonGadget",output,wo);
      break;
    case bulletinboard_v:
     generate_XmCreateObject("XmCreateBulletinBoard",output,wo);
      break;
    case cascadebutton_v:
     generate_XmCreateObject("XmCreateCascadeButton",output,wo);
      break;
    case cascadebuttongadget_v:
     generate_XmCreateObject("XmCreateCascadeButtonGadget",output,wo);
      break;
    case command_v:
     generate_XmCreateObject("XmCreateCommand",output,wo);
      break;
    case dialogshell_v:
     generate_XmCreateObject("XmCreateDialogShell",output,wo);
      break;
    case drawingarea_v:
     generate_XmCreateObject("XmCreateDrawingArea",output,wo);
      break;
    case drawnbutton_v:
     generate_XmCreateObject("XmCreateDrawnButton",output,wo);
      break;
    case errordialog_v:
     generate_XmCreateObject("XmCreateErrorDialog",output,wo);
      break;
    case fileselectionbox_v:
     generate_XmCreateObject("XmCreateFileSelectionBox",output,wo);
      break;
    case form_v:
     generate_XmCreateObject("XmCreateForm",output,wo);
      break;
    case formdialog_v:
     generate_XmCreateObject("XmCreateFormDialog",output,wo);
      break;
    case frame_v:
     generate_XmCreateObject("XmCreateFrame",output,wo);
      break;
    case informationdialog_v:
     generate_XmCreateObject("XmCreateInformationDialog",output,wo);
      break;
    case label_v:
     generate_XmCreateObject("XmCreateLabel",output,wo);
      break;
    case labelgadget_v:
     generate_XmCreateObject("XmCreateLabelGadget",output,wo);
      break;
    case list_v:
     generate_XmCreateObject("XmCreateList",output,wo);
      break;
    case mainwindow_v:
     generate_XmCreateObject("XmCreateMainWindow",output,wo);
      break;
    case menubar_v:
     generate_XmCreateObject("XmCreateMenuBar",output,wo);
      break;
    case messagebox_v:
     generate_XmCreateObject("XmCreateMessageBox",output,wo);
      break;
    case optionmenu_v:
      *output << TAB << "xmstr = XmStringCreateLtoR(\"Options\",\n";
      *output << TAB << "			   (XmStringCharSet)XmFONTLIST_DEFAULT_TAG);\n";
       *output << TAB << "XtSetArg(al[ac],XmNlabelString,xmstr);ac++;\n";
      generate_XmCreateObject("XmCreateOptionMenu",output,wo);
      *output << TAB << "XmStringFree (xmstr);\n";
      break;
    case panedwindow_v:
     generate_XmCreateObject("XmCreatePanedWindow",output,wo);
      break;
    case popupmenu_v:
     generate_XmCreateObject("XmCreatePopupMenu",output,wo);
      break;
    case promptdialog_v:
     generate_XmCreateObject("XmCreatePromptDialog",output,wo);
      break;
    case pulldownmenu_v:
      if(((wo->get_parent())->get_parent())->get_type() != optionmenu_v){
	generate_XmCreateObject("XmCreatePulldownMenu",output,wo);
      }
      else{
	*output << TAB 
		<< wo->get_variable_name()
		<< " = "
		<< "\n" << TAB << TAB
		<< "XmCreatePulldownMenu(";
	if(wo->get_parent() == NULL){
	  *output << "parent";
	}
	else{
	  *output << ((wo->get_parent())->get_parent())->get_variable_name();
	}
	*output << ", \""
		<< wo->get_widget_name()
		<< "\", al, ac);\n";  
      }
      break;
    case pushbutton_v:
     generate_XmCreateObject("XmCreatePushButton",output,wo);
      break;
    case pushbuttongadget_v:
     generate_XmCreateObject("XmCreatePushButtonGadget",output,wo);
      break;
    case questiondialog_v:
     generate_XmCreateObject("XmCreateQuestionDialog",output,wo);
      break;
    case radiobox_v:
     generate_XmCreateObject("XmCreateRadioBox",output,wo);
      break;
    case rowcolumn_v:
     generate_XmCreateObject("XmCreateRowColumn",output,wo);
      break;
    case scale_v:
     generate_XmCreateObject("XmCreateScale",output,wo);
      break;
    case scrollbar_v:
     generate_XmCreateObject("XmCreateScrollBar",output,wo);
      break;
    case scrolledlist_v:
      *output << TAB
	      << "XtSetArg(al[ac],XmNscrollBarDisplayPolicy,XmSTATIC);ac++;\n";
      *output << TAB
	      << "XtSetArg(al[ac],XmNlistSizePolicy,XmCONSTANT);ac++;\n";
      *output << TAB 
	      << (wo->find_child(list_v))->get_variable_name()
	      << " = "
	      << "\n" << TAB << TAB
	      << "XmCreateScrolledList" << "(";
      *output << (wo->get_parent())->get_variable_name();
      *output << ", \""
	      << (wo->find_child(list_v))->get_widget_name()
	      << "\", al, ac);\n";  
     *output << TAB
	     << wo->get_variable_name() 
	     << " = XtNameToWidget(" 
	     << (wo->get_parent())->get_variable_name() 
	     << ",\"" << wo->get_name() << "\"" 
	     << ");\n";
     *output << TAB
	     << "XtManageChild(" << (wo->find_child(list_v))->get_variable_name() << ");\n";
      break;
    case scrolledtext_v:
      *output << TAB
	      << "XtSetArg(al[ac],XmNeditMode,XmMULTI_LINE_EDIT);ac++;\n";
      *output << TAB 
	      << (wo->find_child(text_v))->get_variable_name()
	      << " = "
	      << "\n" << TAB << TAB
	      << "XmCreateScrolledText" << "(";
      *output << (wo->get_parent())->get_variable_name();
      *output << ", \""
	      << (wo->find_child(text_v))->get_widget_name()
	      << "\", al, ac);\n";  
     *output << TAB
	     << wo->get_variable_name() 
	     << " = XtNameToWidget(" 
	     << (wo->get_parent())->get_variable_name() 
	     << ",\"" << wo->get_name() << "\"" 
	     << ");\n";
     *output << TAB
	     << "XtManageChild(" << (wo->find_child(text_v))->get_variable_name() << ");\n";
      break;
    case scrolledwindow_v:
     generate_XmCreateObject("XmCreateScrolledWindow",output,wo);
      break;
    case selectionbox_v:
     generate_XmCreateObject("XmCreateSelectionBox",output,wo);
      break;
    case selectiondialog_v:
     generate_XmCreateObject("XmCreateSelectionDialog",output,wo);
      break;
    case separator_v:
     generate_XmCreateObject("XmCreateSeparator",output,wo);
      break;
    case separatorgadget_v:
     generate_XmCreateObject("XmCreateSeparatorGadget",output,wo);
      break;
    case templatedialog_v:
     generate_XmCreateObject("XmCreateTemplateDialog",output,wo);
      break;
    case text_v:
     generate_XmCreateObject("XmCreateText",output,wo);
      break;
    case textfield_v:
     generate_XmCreateObject("XmCreateTextField",output,wo);
      break;
    case togglebutton_v:
     generate_XmCreateObject("XmCreateToggleButton",output,wo);
      break;
    case togglebuttongadget_v:
     generate_XmCreateObject("XmCreateToggleButtonGadget",output,wo);
      break;
    case warningdialog_v:
     generate_XmCreateObject("XmCreateWarningDialog",output,wo);
      break;
    case workingdialog_v:
     generate_XmCreateObject("XmCreateWorkingDialog",output,wo);
      break;
    case last_widget_type_v:
      break;
  }
}

void CodeGenerator::create_code(code_type_enum language)
{
  List<InterfaceObj> *ilist = guide->get_interface_list();

  set_options();

  switch(language){
    case c_code_v:
        generate_c_code(ilist);
    break;
    case cpp_code_v:
        generate_cpp_code(ilist);
    break;
    case resource_code_v:
        generate_resource_code(ilist);
    break;
    case smalltalk_code_v:
        generate_smalltalk_code(ilist);
    break;
    case main_code_v:
        generate_main_code(ilist);
    break;
    case callback_code_v:
        generate_callback_code(ilist);
    break;
    case event_code_v:
        generate_event_code(ilist);
    break;
    case makefile_code_v:
        generate_makefile_code(ilist);
    break;
    case include_code_v:
        generate_include_code(ilist);
    break;
    case last_code_v:
    break;
  }

}
void CodeGenerator::generate_XmCreateObject(char * func_name, 
					    ofstream *output,
					    WidgetObj * wo)
{
  char TAB[] = "  ";

  *output << TAB 
	  << wo->get_variable_name()
	  << " = "
	  << "\n" << TAB << TAB
	  << func_name << "(";
  if(wo->get_parent() == NULL){
    *output << "parent";
  }
  else{
    *output << (wo->get_parent())->get_variable_name();
  }
  *output << ", \""
	  << wo->get_widget_name()
	  << "\", al, ac);\n";  
}

void CodeGenerator::generate_c_code(List<InterfaceObj> *ilist)
{
  ListIterator<InterfaceObj> iter(ilist);
  InterfaceObj * temp = NULL;
  cout << "Generating C code \n";

  while(temp = iter.CurrentItem()){
    cout << "Generating C code for " << (temp->get_child())->get_name() << "\n";
    generate_interface_file(temp->get_child());
    iter.GetNext();
  }
}

void CodeGenerator::generate_cpp_code(List<InterfaceObj> *ilist)
{
  cout << "Generating C++ code \n";
}

void CodeGenerator::generate_resource_code(List<InterfaceObj> *ilist)
{
  ofstream output(_application);
  cout << "Generating resource code \n";
}

void CodeGenerator::generate_smalltalk_code(List<InterfaceObj> *ilist)
{
  cout << "Generating smalltalk code \n";
}

void CodeGenerator::generate_main_code(List<InterfaceObj> *ilist)
{
  char path[512];
  sprintf(path,"%s/%s",_project_dir,"main.c");
  ofstream output(path);
  cout << "Generating main code \n";

  output << "#include \""<< _public_file << "\"\n";
  output << "\n";
  output << "XtAppContext app_context;\n";
  output << "Display *display;\n";
  output << "\n";
  output << "int\n";
  output << "main(int argc, char ** argv)\n";
  output << "{\n";
  output << "  XtSetLanguageProc ( (XtAppContext) NULL, \n";
  output << "                      (XtLanguageProc) NULL,\n";
  output << "                      (XtPointer) NULL );\n";
  output << "  XtToolkitInitialize ();\n";
  output << "  app_context = XtCreateApplicationContext ();\n";
  output << "  display = XtOpenDisplay (app_context, \n";
  output << "                           NULL, \n";
  output << "                           argv[0],\n";
  output << "                           \"" << _application << "\",\n";
  output << "                           NULL, \n";
  output << "                           0, \n";
  output << "                           &argc,\n";
  output << "                           argv);\n";
  output << "  if (!display)\n";
  output << "  {\n";
  output << "    printf(\"%s: can't open display, exiting...\", argv[0]);\n";
  output << "    exit (-1);\n";
  output << "  }\n";
  output << "\n";
  output << "  XtRealizeWidget (create_interfaces(argc,argv));\n";
  output << "  XtAppMainLoop (app_context);\n";
  output << "  exit (0);\n";
  output << "}\n";
}

void CodeGenerator::generate_callback_code(List<InterfaceObj> *ilist)
{
  char path[512];
  sprintf(path,"%s/%s.c",_project_dir,_callback_file);
  ofstream output(path);
  cout << "Generating callback code \n";
}

void CodeGenerator::generate_include_code(List<InterfaceObj> *ilist)
{
  char path[512];
  sprintf(path,"%s/%s",_project_dir,_public_file);
  ofstream output(path);
  int i = 0;
  ListIterator<InterfaceObj> * iter = 
    new ListIterator<InterfaceObj>(guide->get_interface_list());
  InterfaceObj * io;
  cout << "Generating include code \n";

  output << "#ifndef _PUBLIC_H\n";
  output << "#define _PUBLIC_H\n";
  output << "#include <stdio.h>\n";
  output << "#include <stdlib.h>\n";
  output << "#include <X11/Xatom.h>\n";
  output << "#include <X11/Intrinsic.h>\n";
  output << "#include <X11/Shell.h>\n";
  output << "#include <Xm/XmStrDefs.h>\n";
  output << "#include <Xm/Xm.h>\n\n";

  output << "\nextern Widget create_interfaces(int argc, char ** argv);\n";

  while(io = iter->CurrentItem()){
    
    // reset include files 
    // prevents files from being include more than once (in theory...)
    for(i=1;i<last_widget_type_v;i++){
      include_file[i] = False;
    }
    if((io->get_child())->get_type() == applicationshell_v)
      output << "\nextern Widget create_" << (io->get_child())->get_widget_name()
	     << "(int argc, char ** argv);\n";
    else
      output << "\nextern Widget create_" << (io->get_child())->get_widget_name()
	     << "(Widget parent);\n";
    (io->get_child())->add_includes(&output);
    (io->get_child())->add_extern_c_vars(&output);
    iter->GetNext();
  }

  output << "\nextern XtAppContext app_context;\n";
  output << "extern Display *display;\n\n";

  output << "#endif _PUBLIC_H\n";

  delete iter;
}

void CodeGenerator::generate_event_code(List<InterfaceObj> *ilist)
{
  char path[512];
  sprintf(path,"%s/%s.c",_project_dir,_event_file);
  ofstream output(path);
  cout << "Generating event code \n";
}

void CodeGenerator::generate_makefile_code(List<InterfaceObj> *ilist)
{
  char path[512];
  sprintf(path,"%s/%s",_project_dir,"Makefile");
  ofstream output(path);
  ListIterator<InterfaceObj> *iter = new  ListIterator<InterfaceObj>(ilist);
  InterfaceObj * io;
  cout << "Generating Makefile \n";

  output << ".SUFFIXES: .o .C .c \n";
  output << "\n";
  output << "CC = " << _c_compiler << "\n";
  output << "CXX = " << _cpp_compiler << "\n";
  output << "STRIP = strip \n";
  output << "INCLUDES = " << _includes << "\n";
  output << "CFLAGS = " << _c_flags << " $(INCLUDES)\n";
  output << "C++FLAGS = " << _cpp_flags << " $(INCLUDES)\n";
  output << "LIBS = "
	 << _motif_lib << " "
	 << _xt_lib << " "
	 << _x11_lib << " "
	 << "-lXpm \n";
  output << "\n";
  output << ".c.o: \n";
  output << "	$(CC) $(CFLAGS) -c $*.c \n";
  output << "\n";
  output << "\n";
  output << ".C.o: \n";
  output << "	$(CXX) $(C++FLAGS) -c $*.C \n";
  output << "\n";
  output << "all: interface\n";
  output << "\n";
  output << "OBJS = main.o \\\n";
  output << "\t\tinterface.o \\\n";
  output << "\t\t" << _callback_file << ".o \\\n";
  output << "\t\t" << _event_file << ".o \\\n";
  
  while(io = iter->CurrentItem()){
    output << "\t\t" << (io->get_child())->get_widget_name() << ".o";
    iter->GetNext();
    if(iter->CurrentItem())
      output << "\\\n";
    else
      output << "\n";
  }
  
  output << "\n";
  output << "interface: $(OBJS)\n";
  output << "	$(RM) $@\n";
  output << "	$(CC) -o $@ $(OBJS) $(LIBS)\n";

  delete iter;
}

void CodeGenerator::generate_interface_file(WidgetObj * wo)
{
  char file_name[512];
  sprintf(file_name,"%s.c",wo->get_widget_name());
  char path[512];
  sprintf(path,"%s/%s",_project_dir,file_name);
  ofstream output(path);
  sprintf(path,"%s/%s",_project_dir,_interface_file);
  ofstream interface_file(path);
  ListIterator<InterfaceObj> *iter = 
    new ListIterator<InterfaceObj>(guide->get_interface_list());
  InterfaceObj * io;
  bool app_found = False;

  io = iter->CurrentItem();

  interface_file << "#include \"" << _public_file << "\"\n";
  interface_file << "Widget create_interfaces(int argc, char ** argv)\n";
  interface_file << "{\n";
  interface_file << "  Widget parent = NULL;\n";

  if(io){

    // find Application Shell first  
    while(io = iter->CurrentItem()){
      if((io->get_child())->get_type() == applicationshell_v){
        if(app_found)
          display_warning("Ooops more than one Application Shell \n\t\t-- EVIL !!!");
        app_found = True;
        interface_file << "  parent =  create_" 
		       << (io->get_child())->get_widget_name()
		       << "(argc, argv);\n";
      }
      iter->GetNext();
    }
    if(!app_found)
      display_warning("Ooops NO Application Shell -- EVIL !!!");

    delete iter;
    iter =  new ListIterator<InterfaceObj>(guide->get_interface_list());

    // set all other interfaces
    while(io = iter->CurrentItem()){
      if((io->get_child())->get_type() != applicationshell_v){
	interface_file << "  create_" 
		       << (io->get_child())->get_widget_name()
		       << "(parent);\n";
      }
      iter->GetNext();
    }
    delete iter;
  }
  interface_file << "  return(parent);\n";
  interface_file << "}\n";

  output << "#include \"" << _public_file << "\"\n";
  output << "\n";
  wo->add_global_c_vars(&output);
  if(wo->get_type() == applicationshell_v)
    output << "Widget create_" << wo->get_widget_name() << "(int argc, char ** argv)\n";
  else
    output << "Widget create_" << wo->get_widget_name() << "(Widget parent)\n";
  output << "{\n";
  output << "  Arg al[64];\n";
  output << "  XrmValue from_value, to_value;\n";
  output << "  XmString xmstr;\n";
  output << "  Pixmap new_pixmap;\n";
  output << "  int xpm_return;\n";
  output << "  register int ac = 0;\n\n";
  
  wo->add_local_c_vars(&output);
  wo->generate_c_code(&output);
  wo->add_attachments(&output);
  output << "  " << "return(" << wo->get_variable_name() << ");\n";
  output << "}\n";
}
