/* ConstraintEditor.C */

#include "ConstraintEditor.h"
// Super Class : None

/*oodB%ConstraintEditor*** Global Declarations and Stuffs ****/

/*oodE********************************************************/

ConstraintEditor::ConstraintEditor()
{
  init();
}

ConstraintEditor::~ConstraintEditor()
{
	// Empty
}

void ConstraintEditor::init()
{
  _Constraint = NULL;
  _position = 0;
  _offset = 0;
  _mode = layout_attachment_v;
  _is_popped = False;
  _ox1 = -1;
  _oy1 = -1;
  _ox2 = -1;
  _oy2 = -1;
  _ox3 = -1;
  _oy3 = -1;
  _src = NULL;
  _dest = NULL;
  create_window();
}

void ConstraintEditor::create_window(void)
{
  Arg al[10];
  int ac = 0;
  XrmValue from_value, to_value; /* For resource conversion */
  int fg, bg;                    /* colour values for pixmaps */ 
  DesignEditor * d = guide->get_DesignEditor();
  bool use_pixmap = True;
  bool no_pixmap = False;
  XmString xmstr;
  Widget form1;
  Widget form2;
  Widget form3;
  Widget frame1;
  Widget frame2;
  Widget frame3;
  Widget label1;
  Widget label2;
  Widget popup;
  Widget menu;
  Widget cascade;
  Widget pullmenu;
  Widget option;
  Widget area_SW;
  Widget option_button;
  Widget option_label;
  Widget Close;

  Widget parent = guide->get_top_widget();
  Factory * _factory = guide->get_Factory();

  XtSetArg(al[ac],XmNminWidth,312);ac++;
  XtSetArg(al[ac],XmNminHeight,476);ac++;
  _Constraint = _factory->create_widget(parent,
					"Constraint",
					toplevelshell_v,
					NULL,
					NULL,
					no_callback_v,
					no_pixmap,
					al,ac);
  ac = 0;
  form1 = _factory->create_widget(_Constraint,
				 "Form",
				 form_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  menu = _factory->create_widget(form1,
				 "Menu",
				 menubar_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
  ac = 0;
  cascade = _factory->create_widget(menu,
				 "File",
				 cascadebutton_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
  ac = 0;
     pullmenu = _factory->create_widget(cascade,
					"XmPulldownMenu",
					pulldownmenu_v,
					NULL,
					NULL,
					no_callback_v,
					no_pixmap,
					al,ac);
     XtSetArg(al[ac], XmNsubMenuId,pullmenu);ac++;
     XtSetValues(cascade,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,
			     "Undo",
			     pushbutton_v,
			     NULL,
			     NULL,
			     no_callback_v,
			     no_pixmap,
			     al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,
			     "Close",
			     pushbutton_v,
			     ConstraintEditor::menu_button_CB,
			     (XtPointer)layout_close_v,
			     activate_v,
			     no_pixmap,
			     al,ac);
     ac = 0;
  cascade = _factory->create_widget(menu,
				 "Help",
				 cascadebutton_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
     XtSetArg(al[ac],XmNmenuHelpWidget,cascade);ac++;
     XtSetValues(menu,al,ac);
     ac = 0;
     pullmenu = _factory->create_widget(cascade,
					"XmPulldownMenu",
					pulldownmenu_v,
					NULL,
					NULL,
					no_callback_v,
					no_pixmap,
					al,ac);
     XtSetArg(al[ac], XmNsubMenuId,pullmenu);ac++;
     XtSetValues(cascade,al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,
			     "On Window",
			     pushbutton_v,
			     NULL,
			     NULL,
			     no_callback_v,
			     no_pixmap,
			     al,ac);
     ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,menu);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;
  frame1 = _factory->create_widget(form1,
				  "XmFrame",
				  frame_v,
				  NULL,
				  NULL,
				  no_callback_v,
				  no_pixmap,
				  al,ac);
  ac = 0;
  form2 = _factory->create_widget(frame1,
				 "XmForm",
				 form_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
  ac = 0;
  xmstr = XmStringCreateLtoR("Constraint Options", 
				   (XmStringCharSet)XmFONTLIST_DEFAULT_TAG);
  XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
  option =_factory->create_widget(form2,
				 "XmOptionMenu",
				 optionmenu_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
  XmStringFree (xmstr);
  option_button = XmOptionButtonGadget(option);
  option_label = XmOptionLabelGadget(option);
  ac = 0;
  pullmenu = _factory->create_widget(option,
					"XmPulldownMenu",
					pulldownmenu_v,
					NULL,
					NULL,
					no_callback_v,
					no_pixmap,
					al,ac);
  XtSetArg(al[ac], XmNsubMenuId,pullmenu);ac++;
  XtSetValues(option_button,al,ac);
  ac = 0;
     _factory->create_widget(pullmenu,
			     "Attachment",
			     pushbutton_v,
			     ConstraintEditor::menu_button_CB,
			     (XtPointer)layout_attachment_v,
			     activate_v,
			     no_pixmap,
			     al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,
			     "Position",
			     pushbutton_v,
			     ConstraintEditor::menu_button_CB,
			     (XtPointer)layout_position_v,
			     activate_v,
			     no_pixmap,
			     al,ac);
     ac = 0;
     _factory->create_widget(pullmenu,
			     "Group",
			     pushbutton_v,
			     ConstraintEditor::menu_button_CB,
			     (XtPointer)layout_group_v,
			     activate_v,
			     no_pixmap,
			     al,ac);
     ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
  XtSetArg(al[ac],XmNtopWidget,option);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNbottomOffset,100);ac++;
  XtSetArg(al[ac],XmNscrollingPolicy,XmAUTOMATIC);ac++;
  area_SW = _factory->create_widget(form2,
				  "XmScrolledWindow",
				  scrolledwindow_v,
				  NULL,
				  NULL,
				  no_callback_v,
				  no_pixmap,
				  al,ac);
  ac = 0;
  frame2 = _factory->create_widget(area_SW,
				  "XmFrame",
				  frame_v,
				  NULL,
				  NULL,
				  no_callback_v,
				  no_pixmap,
				  al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNwidth,200);ac++;
  XtSetArg(al[ac],XmNheight,200);ac++;
  XtSetArg(al[ac],XmNborderWidth,50);ac++;
  XtSetArg(al[ac],XmNborderColor,d->get_color("grey60"));ac++;
  _area = _factory->create_widget(frame2,
				  "XmDrawingArea",
				  drawingarea_v,
				  NULL,
				  NULL,
				  no_callback_v,
				  no_pixmap,
				  al,ac);

     ac = 0;
     XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
     XtSetArg(al[ac],XmNtopWidget,frame2);ac++;
     XtSetArg(al[ac],XmNtopOffset,10);ac++;
     XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_WIDGET);ac++;
     XtSetArg(al[ac],XmNbottomWidget,frame1);ac++;
     XtSetArg(al[ac],XmNbottomOffset,10);ac++;
     XtSetArg(al[ac],XmNleftAttachment,XmATTACH_WIDGET);ac++;
     XtSetArg(al[ac],XmNleftWidget,frame1);ac++;
     XtSetArg(al[ac],XmNleftOffset,10);ac++;
  frame3 = _factory->create_widget(form2,
				  "XmFrame",
				  frame_v,
				  NULL,
				  NULL,
				  no_callback_v,
				  no_pixmap,
				  al,ac);
  ac = 0;
  form3 = _factory->create_widget(frame3,
				 "XmForm",
				 form_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,100);ac++;
  _offset_text = _factory->create_widget(form3,
				 "XmText",
				 text_v,
				 ConstraintEditor::set_offset_CB,
				 NULL,
				 value_changed_v,
				 no_pixmap,
				 al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,10);ac++;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_offset_text);ac++;
  label1 = _factory->create_widget(form3,
				 "Offset",
				 label_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNtopOffset,35);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,100);ac++;
  _position_text = _factory->create_widget(form3,
				 "XmText",
				 text_v,
				 ConstraintEditor::set_position_CB,
				 NULL,
				 value_changed_v,
				 no_pixmap,
				 al,ac);
  ac = 0;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNtopOffset,35);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,10);ac++;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
  XtSetArg(al[ac],XmNbottomWidget,_position_text);ac++;
  label2 = _factory->create_widget(form3,
				 "Position",
				 label_v,
				 NULL,
				 NULL,
				 no_callback_v,
				 no_pixmap,
				 al,ac);
  ac = 0;

  XtAddCallback(_area, XmNinputCallback, 
                  ConstraintEditor::input_CB,NULL);
    
  XtAddCallback(_area, XmNexposeCallback, 
                  ConstraintEditor::refresh_CB,NULL);

  XtAddEventHandler(_area , /* Widget */
                     (EventMask) (Button1MotionMask | 
                      ButtonReleaseMask |
                      ButtonPressMask |
                      EnterWindowMask |
                      LeaveWindowMask), /* events desired */
                      0, /* non_maskable events */
                      ConstraintEditor::draw_line_EV,  /* function */
                      (XtPointer) NULL /* clientdata */);
                      
  XtAddEventHandler( _area, /* Widget */
                     (EventMask) (Button2MotionMask |
                      ButtonPressMask |
                      ButtonReleaseMask |
                      EnterWindowMask |
                      LeaveWindowMask), /* events desired */
                      0, /* non_maskable events */
                      ConstraintEditor::move_widget_EV,  /* function */
                      (XtPointer) NULL  /* clientdata */);

  _rubber_gc = CreateXorGC(display, 
              RootWindowOfScreen(XtScreen(_area)), 
              XBlackPixelOfScreen(XtScreen(_area)),
              XWhitePixelOfScreen(XtScreen(_area)));

  _red_gc = CreateXorGC(display, 
              RootWindowOfScreen(XtScreen(_area)), 
              XBlackPixelOfScreen(XtScreen(_area)),
              XWhitePixelOfScreen(XtScreen(_area)));

  _blue_gc = CreateXorGC(display, 
              RootWindowOfScreen(XtScreen(_area)), 
              XBlackPixelOfScreen(XtScreen(_area)),
              XWhitePixelOfScreen(XtScreen(_area)));
  

  XSetForeground(display,_blue_gc,d->get_color("yellow"));
  XSetForeground(display,_red_gc,d->get_color("green"));
  XSetForeground(display,_rubber_gc,d->get_color("red"));
}

void ConstraintEditor::popup()
{
  XtPopup(_Constraint,XtGrabNone);
  _is_popped = True;
}

void ConstraintEditor::popdown()
{
  XtPopdown(_Constraint);
  _is_popped = False;
}

void ConstraintEditor::menu_button_CB(Widget w,XtPointer clientdata,XtPointer calldata)
{
  ConstraintEditor *ce;
  ce = guide->get_ConstraintEditor();

  switch((layout_menu_enum)clientdata)
  {
  // File menu
  case layout_undo_v:
  break;
  case layout_close_v:
    ce->popdown();
  break;
  // Constraint menu
  case layout_attachment_v:
    ce->attachment_mode();
  break;
  case layout_position_v:
    ce->position_mode();
  break;
  case layout_group_v:
    ce->group_mode();
  break;
  // Help menu
  case layout_help_v:
  break;
  }
}

void ConstraintEditor::attachment_mode(void)
{
  _mode = layout_attachment_v;
  cout << "Switching to Attachment mode\n";
  update();
}

void ConstraintEditor::position_mode(void)
{
  _mode = layout_position_v;
  cout << "Switching to Position mode\n";
  update();
}

void ConstraintEditor::group_mode(void)
{
  _mode = layout_group_v;
  cout << "Switching to Group mode\n";
  update();
}

void ConstraintEditor::set_offset(void)
{
  char * name;
  name = XmTextGetString(_offset_text);

  cout << "Offset value = " << name << "\n";
  _offset = atoi(name);

  XtFree(name);
}

void ConstraintEditor::set_offset_CB(Widget w,
				  XtPointer clientdata,
				  XtPointer calldata)
{
  ConstraintEditor * ce = guide->get_ConstraintEditor();
  ce->set_offset();
}

void ConstraintEditor::set_position(void)
{
  char * name;
  name = XmTextGetString(_position_text);

  cout << "Position value = " << name << "\n";
  _position = atoi(name);

  XtFree(name);
}

void ConstraintEditor::set_position_CB(Widget w,
				    XtPointer clientdata,
				    XtPointer calldata)
{
  ConstraintEditor * ce = guide->get_ConstraintEditor();
  ce->set_position();
}

void ConstraintEditor::input_CB(Widget w, 
				XtPointer clientdata, 
				XtPointer calldata)
{ 
  XmDrawingAreaCallbackStruct *cbs = (XmDrawingAreaCallbackStruct *) calldata;
  ConstraintEditor * ce = guide->get_ConstraintEditor();

  // check which button has been pressed
  if((cbs->event->xany.type != ButtonPress) &&
     (cbs->event->xany.type != ButtonRelease))
    return;

  if(cbs->event->xany.type == ButtonPress)
  {
    switch(cbs->event->xbutton.button)
    {
    case 1:
      cout << "Button 1 at " << cbs->event->xbutton.x << ", " << cbs->event->xbutton.y << " pressed\n";
      ce->set_x1(cbs->event->xbutton.x);
      ce->set_y1(cbs->event->xbutton.y);
      ce->set_src((guide->get_current_widget())->find_form_widget(cbs->event->xbutton.x,cbs->event->xbutton.y));
      break;
    case 2:
      cout << "Button 2 at " << cbs->event->xbutton.x << ", " << cbs->event->xbutton.y << " pressed\n";
      ce->set_x2(cbs->event->xbutton.x);
      ce->set_y2(cbs->event->xbutton.y);
      ce->set_src((guide->get_current_widget())->find_form_widget(cbs->event->xbutton.x,cbs->event->xbutton.y));
      break;
    case 3:  
      cout << "Button 3 at " << cbs->event->xbutton.x << ", " << cbs->event->xbutton.y << " pressed\n";
      ce->set_x3(cbs->event->xbutton.x);
      ce->set_y3(cbs->event->xbutton.y);
      ce->set_src((guide->get_current_widget())->find_form_widget(cbs->event->xbutton.x,cbs->event->xbutton.y));
      ce->show_attachments();
      ce->set_src(NULL);
      break;
    }
  }
  // must be a button release
  else{
    switch(cbs->event->xbutton.button)
    {
    case 1:
      cout << "Button 1 at " << cbs->event->xbutton.x << ", " << cbs->event->xbutton.y << " released\n";
      break;
    case 2:
      cout << "Button 2 at " << cbs->event->xbutton.x << ", " << cbs->event->xbutton.y << " released\n";
      break;
    case 3:  
      cout << "Button 3 at " << cbs->event->xbutton.x << ", " << cbs->event->xbutton.y << " released\n";
      break;
    }
  }
}

void ConstraintEditor::show_attachments(void)
{
  char buffer[1024];
  char top[256],bottom[256],left[256],right[256];

  if(_src){
    attachment_rec *attach = _src->get_attachment_rec();

    if(attach->top_widget)
      strcpy(top,(attach->top_widget)->get_widget_name());
    else
      strcpy(top,"NULL");

    if(attach->bottom_widget)
      strcpy(bottom,(attach->bottom_widget)->get_widget_name());
    else
      strcpy(bottom,"NULL");

    if(attach->left_widget)
      strcpy(left,(attach->left_widget)->get_widget_name());
    else
      strcpy(left,"NULL");

    if(attach->right_widget)
      strcpy(right,(attach->right_widget)->get_widget_name());
    else
      strcpy(right,"NULL");

    sprintf(buffer,attach_buffer,
	    attachment_arr[attach->top_attachment],
            top,
	    attach->top_offset,
	    attach->top_position,
	    attachment_arr[attach->bottom_attachment],
            bottom,
	    attach->bottom_offset,
	    attach->bottom_position,
	    attachment_arr[attach->left_attachment],
            left,
	    attach->left_offset,
	    attach->left_position,
	    attachment_arr[attach->right_attachment],
            right,
	    attach->right_offset,
	    attach->right_position);
    display_warning(buffer);
  }
}

void ConstraintEditor::refresh_CB(Widget w, 
				  XtPointer clientdata, 
				  XtPointer calldata)
{
  ConstraintEditor * ce = guide->get_ConstraintEditor();
  ce->update();
}

void ConstraintEditor::draw_line_EV(Widget w, 
				    XtPointer client_data, 
				    XEvent * event, 
				    char * dummy) // needed for C++
{  
  XEvent new_event;
  memcpy(&new_event,event,sizeof(XEvent));

  ConstraintEditor * ce = guide->get_ConstraintEditor();
  ce->draw_line(w,&new_event);
}

void ConstraintEditor::draw_line(Widget w,XEvent * event)
{
  WidgetObj * form = guide->get_current_widget();

  if((form == NULL)||(_src == NULL))
    return;
  
  if((event->type == MotionNotify) &&
     ((event->xbutton.button == Button1)))
  { // start drawing
    
    // remove old line
    if((_ox1!=-1)&&(_oy1!=-1)){
      XDrawLine(display,XtWindow(w),_rubber_gc,_x1,_y1,_ox1,_oy1);
      if(_dest!=NULL)
        hilight_border(_dest);
    }
    // draw new line
    XDrawLine(display,XtWindow(w),_rubber_gc,_x1,_y1,event->xbutton.x,event->xbutton.y);

    _dest = form->find_form_widget(event->xbutton.x,event->xbutton.y);

    if(_dest!=NULL)
      hilight_border(_dest);

    _ox1 =event->xbutton.x;
    _oy1 =event->xbutton.y;
  }
  if((event->type == LeaveNotify)&&
     ((event->xbutton.button == Button1)))
  { // stop drawing
    if((_ox1!=-1)&&(_oy1!=-1)){
      XDrawLine(display,XtWindow(w),_rubber_gc,_x1,_y1,_ox1,_oy1);
      if(_dest!=NULL)
        hilight_border(_dest);
    }
  }
  if((event->type == EnterNotify)&&
     ((event->xbutton.button == Button1)))
  {
    if((_ox1!=-1)&&(_oy1!=-1)){
      XDrawLine(display,XtWindow(w),_rubber_gc,_x1,_y1,_ox1,_oy1);
      if(_dest!=NULL)
        hilight_border(_dest);
    }
  }
  if((event->type == ButtonRelease)&&
     ((event->xbutton.button == Button1)))
  { // stop drawing
    if((_ox1!=-1)&&(_oy1!=-1)){
      XDrawLine(display,XtWindow(w),_rubber_gc,_x1,_y1,_ox1,_oy1);
      if(_dest!=NULL)
        hilight_border(_dest);
    }
    _dest = form->find_form_widget(event->xbutton.x,event->xbutton.y);

    switch(_mode){
    case layout_attachment_v:
      attach(_src,_dest);
      break;
    case layout_position_v:
      position(_src);
      break;
    case layout_group_v:
      break;
    }

    _src = NULL;
    _dest = NULL;
    update();
    _ox1=-1;
    _oy1=-1;
  }
}

void ConstraintEditor::position(WidgetObj * src)
{
  cout << "Positioning Src = " << src->get_name() << "\n";
  switch(src->get_selection()){
  case top_v:
    break;
  case bottom_v:
    break;
  case left_v:
    break;
  case right_v:
    break;
  }
}

void ConstraintEditor::attach(WidgetObj * src, WidgetObj * dest)
{
      cout << "Attaching Src = " << src->get_name() 
	   << " to  Dest = "<< dest->get_name() << "\n";

  if(dest != NULL)
    if(src->index == dest->index){
      attach_none(dest->get_selection(),src);
      return;
    }


  switch(src->get_selection()){
  case top_v:
    if(dest != NULL){
      switch(dest->get_selection()){
      case top_v:
	attach_opposite_widget(top_v,src,dest);
	break;
      case bottom_v:
	attach_widget(top_v,src,dest);
	break;
      case left_v:
	break;
      case right_v:
	break;
      default:
	cout << "Couldn't find selection for destination widget.\n";
	break;
      }
    }
    else{
      // destination is a form widget
      attach_form(top_v,src,dest);
    }
    break;
  case bottom_v:
    if(dest != NULL){
      switch(dest->get_selection()){
      case top_v:
	attach_widget(bottom_v,src,dest);
	break;
      case bottom_v:
	attach_opposite_widget(bottom_v,src,dest);
	break;
      case left_v:
	break;
      case right_v:
	break;
      default:
	cout << "Couldn't find selection for destination widget.\n";
	break;
      }
    }
    else{
      // destination is a form widget
      attach_form(bottom_v,src,dest);
    }
    break;
  case left_v:
    if(dest != NULL){
      switch(dest->get_selection()){
      case top_v:
	break;
      case bottom_v:
	break;
      case left_v:
	attach_opposite_widget(left_v,src,dest);
	break;
      case right_v:
	attach_widget(left_v,src,dest);
	break;
      default:
	cout << "Couldn't find selection for destination widget.\n";
	break;
      }
    }
    else{
      // destination is a form widget
      attach_form(left_v,src,dest);
    }
    break;
  case right_v:
    if(dest != NULL){
      switch(dest->get_selection()){
      case top_v:
	break;
      case bottom_v:
	break;
      case left_v:
	attach_widget(right_v,src,dest);
	break;
      case right_v:
	attach_opposite_widget(right_v,src,dest);
	break;
      default:
	cout << "Couldn't find selection for destination widget.\n";
	break;
      }
    }
    else{
      // destination is a form widget
      attach_form(right_v,src,dest);
    }
    break;
  default:
    cout << "Couldn't find selection for source widget.\n";
    break;
  }
}

void ConstraintEditor::move_widget_EV(Widget w, 
				       XtPointer client_data, 
				       XEvent * event, 
				       char * dummy)
{
  XEvent new_event;
  memcpy(&new_event,event,sizeof(XEvent));

  ConstraintEditor * ce = guide->get_ConstraintEditor();
  ce->move_widget(w,&new_event);
}

void ConstraintEditor::move_widget(Widget w, XEvent * event)
{
  Arg al[5];
  int ac = 0;
  int old_offset;
  WidgetObj * form = guide->get_current_widget();

  if(form == NULL)
    return;
  
  if((event->type == ButtonPress) &&
     (event->xbutton.button == Button2))
  { // start move
    
    // remove old line
    if((_ox2!=-1)&&(_oy2!=-1)){
      hilight_widget(_src,_ox2,_oy2);
    }
  }  
  if((event->type == MotionNotify) &&
     ((event->xbutton.button == Button2)))
  { // move box
    // remove old line
    if((_ox2!=-1)&&(_oy2!=-1)){
      hilight_widget(_src,_ox2,_oy2);
    }
    // draw new line
    hilight_widget(_src,event->xbutton.x,event->xbutton.y);

    _ox2 =event->xbutton.x;
    _oy2 =event->xbutton.y;
  }
  if((event->type == LeaveNotify) &&
     ((event->xbutton.button == Button2)))
  { 
    // remove box
    if((_ox2!=-1)&&(_oy2!=-1)){
      hilight_widget(_src,_ox2,_oy2);
    }
  }
  if((event->type == EnterNotify) &&
     ((event->xbutton.button == Button2)))
  {
    if((_ox2!=-1)&&(_oy2!=-1)){
      hilight_widget(_src,_ox2,_oy2);
    }
    // draw new line
    hilight_widget(_src,event->xbutton.x,event->xbutton.y);

    _ox2 =event->xbutton.x;
    _oy2 =event->xbutton.y;
  }
  if((event->type == ButtonRelease) &&
     (event->xbutton.button == Button2))
  { // move widget
    // remove box
    if((_ox2!=-1)&&(_oy2!=-1)){
      hilight_widget(_src,_ox2,_oy2);
    }

    if(_src){
      old_offset = _offset;
      _offset = _oy2;
      attach_form(top_v,_src,_dest);
      _offset = _ox2;
      attach_form(left_v,_src,_dest);
      _offset = old_offset;
    }
    _src = NULL;
    _dest = NULL;
    update();
    _ox2=-1;
    _oy2=-1;
  }
}

GC ConstraintEditor::CreateXorGC(Display * display, 
               Drawable drawable,
               unsigned long fg,
               unsigned long bg)
{
  XGCValues xgcvalues;
  GC gc;
  
  xgcvalues.foreground = fg ^ bg;
  xgcvalues.background = 0;
  xgcvalues.function = GXxor;
  
  gc = XCreateGC(display,drawable,
                (GCForeground | GCBackground | GCFunction),
                &xgcvalues);
  return(gc);
}

void ConstraintEditor::set_x1(int x)
{
  _x1 = x;
}

void ConstraintEditor::set_y1(int y)
{
  _y1 = y;
}

void ConstraintEditor::set_x2(int x)
{
  _x2 = x;
}

void ConstraintEditor::set_y2(int y)
{
  _y2 = y;
}

void ConstraintEditor::set_x3(int x)
{
  _x3 = x;
}

void ConstraintEditor::set_y3(int y)
{
  _y3 = y;
}

bool ConstraintEditor::is_popped(void)
{
  return _is_popped;
}

void ConstraintEditor::update(void)
{
  if(_is_popped){
    update_area();
  }
}

void ConstraintEditor::update_area(void)
{
  XClearWindow(XtDisplay(_area), XtWindow(_area));
  draw_all();
}

void ConstraintEditor::draw_widgets(void)
{
  Arg al[5];
  int ac = 0;
  int x = 0;
  int y = 0;

  WidgetObj * top = guide->get_current_widget();
  WidgetObj * temp;
  Widget form = NULL;

  if(top){
    if(top->get_type() == form_v){

      form = top->get_widget();
      ListIterator<WidgetObj> * iter = new ListIterator<WidgetObj>(top->get_widget_list());
      while((temp = iter->CurrentItem())!= NULL){
        temp->draw_outline(_area,gc);
        iter->GetNext();
      }
      delete iter;

      XtSetArg(al[ac], XmNwidth,form->core.width+1);ac++;
      XtSetArg(al[ac], XmNheight,form->core.height+1);ac++;
      XtSetValues(_area,al,ac);
    }
  }
}

void ConstraintEditor::draw_attachments(void)
{
  WidgetObj * top = guide->get_current_widget();
  WidgetObj * temp;
  Widget form = NULL;

  if(top){
    if(top->get_type() == form_v){
      ListIterator<WidgetObj> * iter = 
        new ListIterator<WidgetObj>(top->get_widget_list());

      while((temp = iter->CurrentItem())!= NULL){
        temp->draw_attachments(_area,gc);
        iter->GetNext();
      }
      delete iter;
    }
  }
}

void ConstraintEditor::draw_positions(void)
{
  WidgetObj * top = guide->get_current_widget();
  WidgetObj * temp;
  Widget form = NULL;

  if(top){
    if(top->get_type() == form_v){
      ListIterator<WidgetObj> * iter = 
        new ListIterator<WidgetObj>(top->get_widget_list());

      while((temp = iter->CurrentItem())!= NULL){
        temp->draw_positions(_area,gc);
        iter->GetNext();
      }
      delete iter;
    }
  }
}

void ConstraintEditor::draw_all(void)
{
  draw_widgets();
  draw_attachments();
  draw_positions();
}

void ConstraintEditor::set_src(WidgetObj * src)
{
  _src = src;
  if(src!=NULL)
   hilight_border(src);
}

void ConstraintEditor::hilight_widget(WidgetObj * wo, int x, int y)
{
  Widget w = NULL;

  if(wo){
    w = wo->get_widget();
    XDrawRectangle(display,
		 XtWindow(_area),
		 _red_gc,
		 x,
		 y,
		 w->core.width,
		 w->core.height);
  }
}

void ConstraintEditor::hilight_border(WidgetObj * wo)
{
  if(wo){
  Widget w = wo->get_widget();
  switch(wo->get_selection())
    {
      case top_v:
          XDrawLine(display,XtWindow(_area),_red_gc,
		    w->core.x+1,
		    w->core.y+1,
		    w->core.x+w->core.width-2,
		    w->core.y+1);
	break;
      case bottom_v:
          XDrawLine(display,XtWindow(_area),_red_gc,
		    w->core.x+1,
		    w->core.y+w->core.height-1,
		    w->core.x+w->core.width-2,
		    w->core.y+w->core.height-1);
	break;
      case left_v:
          XDrawLine(display,XtWindow(_area),_red_gc,
		    w->core.x+1,
		    w->core.y+2,
		    w->core.x+1,
		    w->core.y+w->core.height-1);
	break;
      case right_v:
          XDrawLine(display,XtWindow(_area),_red_gc,
		    w->core.x+w->core.width-1,
		    w->core.y+2,
		    w->core.x+w->core.width-1,
		    w->core.y+w->core.height-1);
        break;
      default:
        cout << "Couldn't hilight widget.\n";
        break;
    }
  }
}

void ConstraintEditor::attach_form(selection_enum sel,WidgetObj *src,WidgetObj *dest)
{
  Arg al[5];
  int ac = 0;
  attachment_rec * attach = src->get_attachment_rec();
  clear_attachments(sel,src);
  cout << "ConstraintEditor::attach_form \n";
  switch(sel){
  case top_v:
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  attach->top_attachment = XmATTACH_FORM;
  XtSetArg(al[ac],XmNtopOffset,_offset);ac++;
  attach->top_offset = _offset;
  break;
  case bottom_v:
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_FORM);ac++;
  attach->bottom_attachment = XmATTACH_FORM;
  XtSetArg(al[ac],XmNbottomOffset,_offset);ac++;
  attach->bottom_offset = _offset;
  break;
  case left_v:
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  attach->left_attachment = XmATTACH_FORM;
  XtSetArg(al[ac],XmNleftOffset,_offset);ac++;
  attach->left_offset = _offset;
  break;
  case right_v:
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_FORM);ac++;
  attach->right_attachment = XmATTACH_FORM;
  XtSetArg(al[ac],XmNrightOffset,_offset);ac++;
  attach->right_offset = _offset;
  break;
  }
  XtSetValues(src->get_widget(),al,ac);
  update();
}

void ConstraintEditor::attach_opposite_form(selection_enum sel,WidgetObj *src,WidgetObj *dest)
{
  Arg al[5];
  int ac = 0;
  attachment_rec * attach = src->get_attachment_rec();
  clear_attachments(sel,src);
  cout << "ConstraintEditor::attach_opposite_form \n";

  switch(sel){
  case top_v:
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_OPPOSITE_FORM);ac++;
  attach->top_attachment = XmATTACH_OPPOSITE_FORM;
  XtSetArg(al[ac],XmNtopOffset,_offset);ac++;
  attach->top_offset = _offset;
  break;
  case bottom_v:
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_FORM);ac++;
  attach->bottom_attachment = XmATTACH_OPPOSITE_FORM;
  XtSetArg(al[ac],XmNbottomOffset,_offset);ac++;
  attach->bottom_offset = _offset;
  break;
  case left_v:
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_OPPOSITE_FORM);ac++;
  attach->left_attachment = XmATTACH_OPPOSITE_FORM;
  XtSetArg(al[ac],XmNleftOffset,_offset);ac++;
  attach->left_offset = _offset;
  break;
  case right_v:
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_OPPOSITE_FORM);ac++;
  attach->right_attachment = XmATTACH_OPPOSITE_FORM;
  XtSetArg(al[ac],XmNrightOffset,_offset);ac++;
  attach->right_offset = _offset;
  break;
  }
  XtSetValues(src->get_widget(),al,ac);
  update();
}

void ConstraintEditor::attach_widget(selection_enum sel,WidgetObj *src,WidgetObj *dest)
{
  Arg al[5];
  int ac = 0;
  Widget w = src->get_widget();
  attachment_rec * attach = src->get_attachment_rec();

  clear_attachments(sel,src);
  cout << "ConstraintEditor::attach_widget \n";
  switch(sel){
  case top_v:
    XtSetArg(al[ac],XmNtopAttachment,XmATTACH_WIDGET);ac++;
    attach->top_attachment = XmATTACH_WIDGET;
    XtSetArg(al[ac],XmNtopWidget,dest->get_widget());ac++;
    attach->top_widget = dest;
    XtSetArg(al[ac],XmNtopOffset,_offset);ac++;
    attach->top_offset = _offset; 
    break;
  case bottom_v:
    XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_WIDGET);ac++;
    attach->bottom_attachment = XmATTACH_WIDGET;
    XtSetArg(al[ac],XmNbottomWidget,dest->get_widget());ac++;
    attach->bottom_widget = dest;
    XtSetArg(al[ac],XmNbottomOffset,_offset);ac++;
    attach->bottom_offset = _offset; 
    break;
  case left_v:
    XtSetArg(al[ac],XmNleftAttachment,XmATTACH_WIDGET);ac++;
    attach->left_attachment = XmATTACH_WIDGET;
    XtSetArg(al[ac],XmNleftWidget,dest->get_widget());ac++;
    attach->left_widget = dest;
    XtSetArg(al[ac],XmNleftOffset,_offset);ac++;
    attach->left_offset = _offset; 
    break;
  case right_v:
    XtSetArg(al[ac],XmNrightAttachment,XmATTACH_WIDGET);ac++;
    attach->right_attachment = XmATTACH_WIDGET;
    XtSetArg(al[ac],XmNrightWidget,dest->get_widget());ac++;
    attach->right_widget = dest;
    XtSetArg(al[ac],XmNrightOffset,_offset);ac++;
    attach->right_offset = _offset; 
    break;
  break;
  }

  w = src->get_widget();
  XtSetValues(src->get_widget(),al,ac);
  update();
}

void ConstraintEditor::attach_opposite_widget(selection_enum sel,WidgetObj *src,WidgetObj *dest)
{
  Arg al[5];
  int ac = 0;
  attachment_rec * attach = src->get_attachment_rec();
  clear_attachments(sel,src);
  cout << "ConstraintEditor::attach_opposite_widget \n";
  switch(sel){
  case top_v:
    XtSetArg(al[ac],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
    attach->top_attachment = XmATTACH_OPPOSITE_WIDGET;
    XtSetArg(al[ac],XmNtopWidget,dest->get_widget());ac++;
    attach->top_widget = dest;
    XtSetArg(al[ac],XmNtopOffset,_offset);ac++;
    attach->top_offset = _offset; 
    break;
  case bottom_v:
    XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
    attach->bottom_attachment = XmATTACH_OPPOSITE_WIDGET;
    XtSetArg(al[ac],XmNbottomWidget,dest->get_widget());ac++;
    attach->bottom_widget = dest;
    XtSetArg(al[ac],XmNbottomOffset,_offset);ac++;
    attach->bottom_offset = _offset; 
    break;
  case left_v:
    XtSetArg(al[ac],XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
    attach->left_attachment = XmATTACH_OPPOSITE_WIDGET;
    XtSetArg(al[ac],XmNleftWidget,dest->get_widget());ac++;
    attach->left_widget = dest;
    XtSetArg(al[ac],XmNleftOffset,_offset);ac++;
    attach->left_offset = _offset; 
    break;
  case right_v:
    XtSetArg(al[ac],XmNrightAttachment,XmATTACH_OPPOSITE_WIDGET);ac++;
    attach->right_attachment = XmATTACH_OPPOSITE_WIDGET;
    XtSetArg(al[ac],XmNrightWidget,dest->get_widget());ac++;
    attach->right_widget = dest;
    XtSetArg(al[ac],XmNrightOffset,_offset);ac++;
    attach->right_offset = _offset; 
    break;
  }
  XtSetValues(src->get_widget(),al,ac);

  update();
}

void ConstraintEditor::attach_none(selection_enum sel, WidgetObj *src)
{
  Arg al[7];
  int ac = 0;
  cout << "ConstraintEditor::attach_none -> " << selection_arr[sel] << "\n";

  clear_attachments(sel,src);

  update();
}

void ConstraintEditor::attach_self(selection_enum sel, WidgetObj *src)
{
  Arg al[7];
  int ac = 0;
  attachment_rec * attach = src->get_attachment_rec();

  clear_attachments(sel,src);
  cout << "ConstraintEditor::attach_self \n";
  switch(sel){
  case top_v:
    XtSetArg(al[ac],XmNtopAttachment,XmATTACH_SELF);ac++;
    attach->top_attachment = XmATTACH_SELF;
    break;
  case bottom_v:
    XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_SELF);ac++;
    attach->bottom_attachment = XmATTACH_SELF;
    break;
  case left_v:
    XtSetArg(al[ac],XmNleftAttachment,XmATTACH_SELF);ac++;
    attach->left_attachment = XmATTACH_SELF;
    break;
  case right_v:
    XtSetArg(al[ac],XmNrightAttachment,XmATTACH_SELF);ac++;
    attach->right_attachment = XmATTACH_SELF;
    break;
  }
  XtSetValues(src->get_widget(),al,ac);

  update();
}

void ConstraintEditor::clear_attachments(selection_enum sel, WidgetObj * src)
{
  Arg al[5];
  int ac = 0;
  attachment_rec * attach = src->get_attachment_rec();

  if(src == NULL)
    return;
  cout << "ConstraintEditor::clear_attachments \n";
  switch(sel){
  case top_v:
    XtSetArg(al[ac],XmNtopAttachment,XmATTACH_NONE);ac++;
    attach->top_attachment = XmATTACH_NONE;
    XtSetArg(al[ac],XmNtopWidget,NULL);ac++;
    attach->top_widget = NULL;
    XtSetArg(al[ac],XmNtopOffset,0);ac++;
    attach->top_offset = 0;
    XtSetArg(al[ac],XmNtopPosition,0);ac++;
    attach->top_position = 0;
    break;
  case bottom_v:
    XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_NONE);ac++;
    attach->bottom_attachment = XmATTACH_NONE;
    XtSetArg(al[ac],XmNbottomWidget,NULL);ac++;
    attach->bottom_widget = NULL;
    XtSetArg(al[ac],XmNbottomOffset,0);ac++;
    attach->bottom_offset = 0;
    XtSetArg(al[ac],XmNbottomPosition,0);ac++;
    attach->bottom_position = 0;
    break;
  case left_v:
    XtSetArg(al[ac],XmNleftAttachment,XmATTACH_NONE);ac++;
    attach->left_attachment = XmATTACH_NONE;
    XtSetArg(al[ac],XmNleftWidget,NULL);ac++;
    attach->left_widget = NULL;
    XtSetArg(al[ac],XmNleftOffset,0);ac++;
    attach->left_offset = 0;
    XtSetArg(al[ac],XmNleftPosition,0);ac++;
    attach->left_position = 0;
    break;
  case right_v:
    XtSetArg(al[ac],XmNrightAttachment,XmATTACH_NONE);ac++;
    attach->right_attachment = XmATTACH_NONE;
    XtSetArg(al[ac],XmNrightWidget,NULL);ac++;
    attach->right_widget = NULL;
    XtSetArg(al[ac],XmNrightOffset,0);ac++;
    attach->right_offset = 0;
    XtSetArg(al[ac],XmNrightPosition,0);ac++;
    attach->right_position = 0;
    break;
  }
  XtSetValues(src->get_widget(),al,ac);
}

