proc ResourceEditor {rcfile} {
global all RE_saved xf

set xf(re_on) 1
if [winfo exists .rcedit] {
wm deiconify .rcedit
raise .rcedit
return
}
set RE_saved 0
set w [toplevel .rcedit]
wm withdraw $w
wm title $w "X-Files Resource Editor v0.7"
wm resizable $w 0 1
wm geometry $w +100+50
wm protocol $w WM_DELETE_WINDOW RE_Close

SetCnfMenuBg
frame $w.d
frame $w.bot -bd 3 -relief ridge

button $w.bot.close -text Close -width 8 -command RE_Close
button $w.bot.save -text Save -width 8 -command RE_Save
button $w.bot.add -text Add... -width 8 -command RE_Add
button $w.bot.remove -text Remove -width 8 -command RE_Remove
button $w.bot.edit -text "Edit Name..." -width 8 -command RE_Edit
pack $w.bot.close -side right
pack $w.bot.add $w.bot.remove $w.bot.edit $w.bot.save -side left
pack $w.bot -side bottom -fill x

canvas $w.d.can -yscrollcommand [list $w.d.sb set] -width 10 -height 10
scrollbar $w.d.sb -orient vertical -command [list $w.d.can yview]
pack $w.d.sb -side right -fill y
pack $w.d.can -side left -fill both -expand 1
pack $w.d -side top -fill both -expand 1
set f [frame $w.d.can.f -bd 0 -highlightthickness 0]
$w.d.can create window 0 0 -window $f -anchor nw

set all(?) ?
frame $f.dl
frame $f.dr
frame $f.left -bd 3 -relief raised
frame $f.right -bd 3 -relief raised
RE_GetOptions $rcfile
RE_PackOptions $f
pack $f.left -in $f.dl -side top -fill y
pack $f.right -in $f.dr -side top -fill y
pack $f.dl -side left -fill y
pack $f.dr -side right -fill y

bind $w <Escape> {RE_Close}
bind $w <Control-c> {RE_Close}
focus $w.bot.close
trace variable all w RE_Upd
wm deiconify $w

tkwait visibility $f.right.1
set incr [winfo height $f.right.1]
set width [winfo width $f]
set height [winfo height $f]

$w.d.can config -scrollregion "0 0 $width $height" \
-width $width -height [expr (400/$incr)*$incr] \
-yscrollincrement $incr

set la [llength $all(opt.all)]
set lr [llength $all(opt.read)]

if {$la > $lr} {
foreach l $all(opt.all) {
if {[lsearch -exact $all(opt.read) $l] == -1} {
lappend diff $l
}
}
set x [winfo pointerx .]
set y [winfo pointery .]
MessageBox "The resource file in \"~/.x-files/\"-directory is not up to date. I will now add the missing resources..." {} -50 -50 $x $y
set i $all(size)
foreach a $diff {
set all($i.name) *xfiles.$a:
set all($i.val) [option get .xfiles $a {}]
if {[string compare {} $all($i.val)] == 0} {
MessageBox "Value for option '*xfiles.$a' is missing!!\nInform the system administrator to update 'xfilesrc'." {} -50 -50 $x $y
}
set all($i.comment) {}
if {[regexp {^[01]$} $all($i.val)] && ![regexp {button_set} $all($i.name)]} {
RE_PackItem "left" $i $f
} {
RE_PackItem "right" $i $f
}
incr i
}
set all(size) $i
MessageBox "If you need the comments, add them by hand from the file\n$xf(xf_home)xfilesrc" {} -50 -50 $x $y
}
}

proc RE_Upd {arr index op} {
global RE_upd
set RE_upd 1
trace vdelete all w RE_Upd
}
proc RE_GetOptions {rcfile} {
global all

set fid [open $rcfile r]
gets $fid line
while {[string compare {} $line]} {
lappend all(comment) $line
gets $fid line
}
set i 0
set comment {}
while {[gets $fid line] >= 0} {
if [string match {!*} $line] {
lappend comment $line
}
if ![string match {!*} $line] {
if {[string compare {} $line] == 0} {
continue
}
regexp {^([^:]*): (.*)$} $line g option value
set option [string trim $option]:
set value [string trim $value]
set all($i.name) $option
set all($i.val) $value
set all($i.comment) $comment
set comment {}

if {[string match {\*xfiles*} $option] \
&& ![string match {*popup_user_item*} $option]} {
regexp {^[^.]*.([^:]*):$} $option a b
lappend all(opt.read) $b
}
incr i
}
}
set all(opt.all) {startup_dir_left startup_dir_right trash_dir selectBg_left selectBg_right pack_order_reverse hidden_files_left hidden_files_right turbo_file_operations protection_bits auto_update show_link_dest safe_deletion mem_label time_label button_line_1 button_line_2 button_line_3 button_line_4 button_line_5 button_line_6 button_line_7 button_line_8 button_set_1 button_set_2 button_set_3 button_set_4 mail_check mail_reader mail_message_box read_on_ack geometry messagelog_file log_messages log_messages_to_file log_font sort_by_extension button_cols button_spacing focus_follows_mouse messages_always_on_top peek_file_header user_email}
set all(size) $i
close $fid
}

proc RE_PackOptions {w} {
global all

for {set i 0} {$i < $all(size)} {incr i} {
if {[regexp {^[01]$} $all($i.val)] && ![regexp {button_set} $all($i.name)] \
&& ![regexp {button_cols} $all($i.name)] && ![regexp {button_spacing} $all($i.name)]} {
RE_PackItem "left" $i $w
} {
RE_PackItem "right" $i $w
}
}
}
proc RE_PackItem {side i w} {
global all
frame $w.$side.$i -highlightthickness 1
if [string match "left" $side] {
label $w.$side.$i.l -text $all($i.name)
checkbutton $w.$side.$i.c -variable all($i.val) \
-command [list focus $w.$side.$i] -highlightthickness 0
pack $w.$side.$i.c -side right
} {
label $w.$side.$i.l -text $all($i.name) -width 27 -anchor w
entry $w.$side.$i.e -textvariable all($i.val) \
-highlightthickness 0
if {[string match {*_dir*} $all($i.name)] || \
[string match {*_file*} $all($i.name)]} {
button $w.$side.$i.b -text Browse... -width 9 -padx 0 -pady 0\
-command [list RE_GetFSName $w.right.$i.e [string match {*_dir*} $all($i.name)]] -highlightthickness 0
pack $w.$side.$i.b -side right -padx 0 -pady 0
bind $w.$side.$i.b <1> [list focus $w.$side.$i]
} elseif [string match {*font*} $all($i.name)] {
button $w.$side.$i.b -text Select... -width 9 -padx 0 -pady 0\
-command [list RE_GetFont $w.right.$i.e] -highlightthickness 0
pack $w.$side.$i.b -side right -padx 0 -pady 0
bind $w.$side.$i.b <1> [list focus $w.$side.$i]
} elseif [string match \#* $all($i.val)] {
button $w.$side.$i.b -text Select... -width 9 -padx 0 -pady 0\
-command [list RE_GetColor $w.$side.$i.e] -highlightthickness 0
label $w.$side.$i.cl -bg $all($i.val) -highlightthickness 0 -width 4
pack $w.$side.$i.b $w.$side.$i.cl -side right -padx 0 -pady 0
bind $w.$side.$i.cl <1> [list focus $w.$side.$i]
bind $w.$side.$i.b <1> [list focus $w.$side.$i]
bind $w.$side.$i.e <Return> {
regsub {[^\.]*$} %W "cl" cl
$cl config -bg [%W get]
}
} elseif [string match *xfiles.geometry* $all($i.name)] {
button $w.$side.$i.b -text Get -width 9 -padx 0 -pady 0\
-command [list RE_GetGeom $w.right.$i.e] -highlightthickness 0
pack $w.$side.$i.b -side right -padx 0 -pady 0
bind $w.$side.$i.b <1> [list focus $w.$side.$i]
}
pack $w.$side.$i.e -side right -fill x -expand 1
}
pack $w.$side.$i.l -side left
pack $w.$side.$i -side top -fill x -expand 1
bind $w.$side.$i.l <3> [list RE_PopUp $w.$side.$i %X %Y]
bind $w.$side.$i <3> {RE_PopUp %W %X %Y}
bind $w.$side.$i.l <1> [list focus $w.$side.$i]
bind $w.$side.$i <1> {focus %W}
}
proc RE_GetFSName {entry dirmode} {
global xf env

regsub {[^\.]*$} $entry "b" b
if $dirmode {set m "dir"} {set m "load"}
if {[string compare {} [$entry get]] == 0} {
set dir $env(HOME)/
} {
set dir [GetParentDir [TildeSubst [$entry get]]]
}
set new [FS "RE" $dir $m]
if {[string compare "" $new] == 0} {
return
}
$entry delete 0 end
$entry insert 0 $new
$entry xview moveto 1
$entry icursor end
}
proc RE_GetFont {entry} {
global xf

regsub {[^\.]*$} $entry "b" b
set bg [lindex [$b config -bg] end]
$b config -relief sunken -bg #fcbcbc
set new [SelectFont [$entry get]]
$b config -relief raised -bg $bg
if {[string compare [$entry get] $new] == 0} {
return
}
$entry delete 0 end
$entry insert 0 $new
$entry xview moveto 1
$entry icursor end
}
proc RE_GetGeom {entry} {
global xf

regsub {[^\.]*$} $entry "b" b
set bg [lindex [$b config -bg] end]
$b config -relief sunken -bg #fcbcbc
set new [wm geometry .]
$b config -relief raised -bg $bg
if {[string compare [$entry get] $new] == 0} {
return
}
$entry delete 0 end
$entry insert 0 $new
$entry xview moveto 1
$entry icursor end
}
proc RE_GetColor {entry} {
global xf

regsub {[^\.]*$} $entry "b" b
regsub {[^\.]*$} $entry "cl" cl
set bg [lindex [$b config -bg] end]
$b config -relief sunken -bg #fcbcbc
set new [SelectColor [$entry get]]
$b config -relief raised -bg $bg
if {[string compare [$entry get] $new] == 0} {
return
}
$entry delete 0 end
$entry insert 0 $new
$entry xview moveto 1
$entry icursor end
$cl config -bg $new
}
proc RE_PopUp {W X Y} {
global all
focus $W
catch {destroy $W.popup}
regexp {.*\.(.*)\.(.*)$} $W g side ind
set p [menu $W.popup -tearoff 0 -relief ridge -bd 4 -bg grey70 -disabledforeground #000000]
$p add command -label "Edit comment..." -command [list RE_EditComment $ind]
$p add separator
foreach l $all($ind.comment) {
$p add command -label $l -state disabled
}
tk_popup $p $X $Y
}
proc RE_EditComment {ind} {
global all

set tl [toplevel .rc_comment]
wm geometry $tl +100+100
wm title $tl "X-Files Resource Comment"
frame $tl.tf
text $tl.tf.text -width 50 -height 10
frame $tl.bf
button $tl.bf.ok -text Ok -command [list RE_CommentOK $ind]
button $tl.bf.cancel -text Cancel -command {destroy .rc_comment}
pack $tl.tf -side top
pack $tl.bf -side bottom -fill x -expand true
pack $tl.bf.ok -side left
pack $tl.bf.cancel -side right
pack $tl.tf.text -side top
$tl.tf.text delete 0.0 end
foreach line $all($ind.comment) {
$tl.tf.text insert end "$line\n"
}
focus $tl.bf.cancel
}
proc RE_CommentOK {ind} {
global all RE_upd

set text [split [string trim [.rc_comment.tf.text get 0.0 end]] \n]
if {[string compare $text $all($ind.comment)] == 0} {
return
}
set RE_upd 1
set all($ind.comment) ""
foreach l $text {
lappend all($ind.comment) !![string trimleft $l !]
}
destroy .rc_comment
}
proc RE_Add {} {
global all add

set add(result) "*"
set add(choice) "e"
if [RE_AddDialog "Give the name and type of the new resource." -100 -150] {
if {[string match {\*xfiles*} $add(result)] && \
![string match {*popup_user_item_*} $add(result)]} {
MessageBox "You cannot give an *xfiles option!!"
unset add
return
}
set i $all(size)
incr all(size)
if {[string compare "e" $add(choice)] == 0} {
set all($i.name) [string trimright $add(result) :]:
set all($i.val) ""
set all($i.comment) {}
RE_PackItem "right" $i .rcedit.d.can.f
} {
set all($i.name) [string trimright $add(result) :]:
set all($i.val) ""
set all($i.comment) {}
RE_PackItem "left" $i .rcedit.d.can.f
}
}
unset add
.rcedit.d.can config -scrollregion "0 0 [winfo width .rcedit.d.can.f] [winfo height .rcedit.d.can.f]"
}
proc RE_AddDialog {string {xoffset -50} {yoffset -50}} {
global add ret xf

set d .prompt
catch {destroy $d}
toplevel $d -bd 3
if {[option get .xfiles messages_always_on_top {}] == 1} {
bind $d <Visibility> [list KeepOnTop $d %W %s]
}
wm title $d "Add Resource"
set x [expr [winfo pointerx .] + $xoffset]
set y [expr [winfo pointery .] + $yoffset]
wm geometry $d "+$x+$y"
frame $d.but -bd 2 -relief raised
message $d.msg -justify left -text $string -aspect 300 \
-font *helvetica-bold-r-*-*-14* -relief flat -bd 6
frame $d.y -relief ridge -bd 2
label $d.y.l -text "Name:"
entry $d.y.e -textvariable add(result) -highlightthickness 2
pack $d.y.l $d.y.e -side left
frame $d.d -relief ridge -bd 2
frame $d.d.c
radiobutton $d.d.c.c -variable add(choice) -value "c" -text "Checkbutton"
radiobutton $d.d.c.e -variable add(choice) -value "e" -text "Entry field"
pack $d.d.c.c $d.d.c.e -side top -anchor w
label $d.d.l -text Type:
pack $d.d.l $d.d.c -side left

bind $d <Control-c> {set ret  0}
bind $d <Escape> {set ret  0}
bind $d.y.e <Return> {set ret 1}
button $d.but.ok -width 6 -text OK -command {set ret 1}
button $d.but.cancel -width 6 -text Cancel -command {set ret 0}
pack $d.but.ok -side left -padx 5 -pady 5
pack $d.but.cancel -side right -padx 5 -pady 5
pack $d.msg $d.y $d.d $d.but -side top -fill x -expand true

tkwait visibility $d
grab $d
$d.y.e xview moveto 1
$d.y.e icursor end
focus $d.y.e
tkwait variable ret
grab release $d
destroy $d
return $ret

}
proc RE_Remove {} {
global all RE_upd

set w [focus]
if [string match *bot* $w] {
MessageBox "Select an option first!" {} -100 -150
return
}
regexp {^\..*\.(right|left)\.([0-9]+)} $w g side ind
if {[string match *xfiles* $all($ind.name)] \
&& ![string match *popup_user* $all($ind.name)] \
|| [string match *popup_menu* $all($ind.name)]} {
MessageBox "You are not allowed to remove an *xfiles -option!" {} -100 -150
return
}
if {[AskWin "Are You sure ?!" -100 -150] == 0} {
return
}
set RE_upd 1
pack forget $w
unset all($ind.name)
unset all($ind.val)
unset all($ind.comment)
.rcedit.d.can config -scrollregion "0 0 [winfo width .rcedit.d.can.f] [winfo height .rcedit.d.can.f]"
.rcedit.bot.remove flash
}
proc RE_Edit {} {
global all xf RE_upd prompt

set w [focus]
if [string match *bot* $w] {
MessageBox "Select an option first!" {} -150 -150
return
}
regexp {^\..*\.(right|left)\.([0-9]+)} $w g side ind
if {[string match *xfiles* $all($ind.name)] \
&& ![string match *popup_user* $all($ind.name)] \
|| [string match *popup_menu* $all($ind.name)]} {
MessageBox "You are not allowed to edit an *xfiles -option name!" {} -150 -150
return
}
set x [winfo pointerx .]
set y [winfo pointery .]
set prompt(1.label) "Name:"
set prompt(1.result) [string trimright $all($ind.name) :]
if [DialogWin "Edit option\n" -150 -150 1 $x $y] {
if {[string compare {} $prompt(1.result)] == 0} {
MessageBox "Not a good name..." {} -150 -150 {} $x $y
unset prompt
return
}
set res [string trimright $prompt(1.result) :]:
foreach n [array names all *name] {
if {[string compare $res $all($n)] == 0} {
MessageBox "An option with that name already exists!" {} -150 -150 {} $x $y
unset prompt
return
}
}
set RE_upd 1
set all($ind.name) $res
$w.l config -text $all($ind.name)
}
update idletasks
unset prompt
}
proc RE_Save {} {
global all xf RE_upd RE_saved

MakeSaveDir
set xf(rcfile) $xf(user_home)xfilesrc
set out [open $xf(rcfile) w]
foreach l $all(comment) {
puts $out $l
}
puts $out ""
set i 0
while {$i < $all(size)} {
catch {
foreach x $all($i.comment) {
puts $out $x
}
}
catch {puts $out "$all($i.name) $all($i.val)"}
catch {puts $out ""}
incr i
}
close $out
set RE_upd 0
set RE_saved 1
trace variable RE_upd w RE_Upd
.rcedit.bot.save flash
}
proc RE_Close {} {
global all RE_upd RE_saved xf argc argv

set x [winfo pointerx .]
set y [winfo pointery .]

if [info exists RE_upd] {
if $RE_upd {
set ret [AskWin "You have made changes! Close the editor without saving?" -150 -150 "Save" $x $y]
switch $ret {
0 {return}
1 {set RE_upd 0; set RE_saved 0}
2 {RE_Save}
default {}
}
}
} {
set RE_upd 0
}
if {$RE_upd || $RE_saved} {
if [AskWin "Do you wish to restart X-Files, so that the changes become effective now?" -150 -150 {} $x $y] {
set home $xf(xf_home)
catch {after cancel MailChk}
catch {after cancel AutoUD}
catch {unset xf ee ea be all RE_upd}
bind XF_Listbox <Configure> {}
foreach w [winfo children .] {
catch {destroy $w}
}
set xf(xf_home) $home
uplevel #0 {MAIN $argc $argv}
}
}
set xf(re_on) 0
SetCnfMenuBg
catch {destroy .rcedit}
catch {unset all}
catch {unset RE_upd}
}
