#!/bin/sh
#
# install.sh
#
# Installes XCmail and all required components
#
# (c) 1998 by Jrgen Schmitz (schmitzj@fsai.fh-trier.de)
#


_XCMAILBIN='/usr/local/bin'
if [ "$XCMAILDIR" ]; then
  _XCMAILDIR=$XCMAILDIR
else
  _XCMAILDIR='/usr/local/XCmail'
fi
_DYNAMIC="N"

echo_n() {
	if [ "`echo -n`" = "-n" ] ; then
		if [ "`echo \c`" = 'c' ] ; then
			printf "$@"
		else
			echo "$@""\c"
		fi
	else
		echo -n "$@"
	fi
}

clear
echo
echo "                                                  |"
echo "                                                  |"
echo " XCmail interactive installation                  |"
echo "                                                  |"
echo "+-------------------------------------------------+"
echo "|"
echo "| By default the XCmail binary should be placed in"
echo "| '/usr/local/bin' or '/usr/bin'. All other files"
echo "| like default setups, global plugins or config files"
echo "| will be installed in '/usr/local/XCmail'."
echo "|"
echo "| We will now go and verify this directories and"
echo "| change them to your needs."
echo "|"

echo
echo "Where should the main program be installed to?"
echo_n "[$_XCMAILBIN]: "
read dummy
if [ -n "$dummy" ]; then
  _XCMAILBIN="$dummy"
fi

echo
echo "Where should the extra files be placed in?"
echo_n "[$_XCMAILDIR]: "
read dummy
if [ -n "$dummy" ]; then
  _XCMAILDIR="$dummy"
fi

if [ -f "xc-mail_static" -a -f "xc-mail" ]; then
 echo
 echo "We have a dynamic and a static release of XCmail included"
 echo "in this achive. Static means Xclasses library is linked in"
 echo "the binary, dynamic means you need Xclasses library installed"
 echo "on your system."
 echo
 echo_n "Which should be installed, the dynamic releases? (y/N) "
 read dummy
 if [ "$dummy" = "y" -o "$dummy" = "Y" ]; then
   _DYNAMIC="Y"
 fi
fi

echo
echo
echo "Ok. We will now copy the files:"
echo " - binary to $_XCMAILBIN"
echo " - other files to $_XCMAILDIR"
echo
echo_n "Is this correct? (y/N) "
read dummy
echo
if [ "$dummy" != "y" -a "$dummy" != "Y" ]; then
  echo
  echo "As you wished it, leaving!"
  echo
  exit
fi

# --- main -----------------------------------------------------------
if [ ! -d "$_XCMAILBIN" ]; then
  echo "Directory $_XCMAILBIN not found!"
  echo "Aborting."
  exit
fi

if [ -f "xc-mail" -o "$_DYNAMIC" = "Y" ]; then
  cp xc-mail $_XCMAILBIN
fi
if [ -f "xc-mail_static" -a "$_DYNAMIC" = "N" ]; then
  cp xc-mail_static $_XCMAILBIN/xc-mail
fi

chmod 755 $_XCMAILBIN/xc-mail

if [ ! -f "$_XCMAILBIN/xcmail" ]; then
  ln -s $_XCMAILBIN/xc-mail $_XCMAILBIN/xcmail
fi
if [ ! -f "$_XCMAILBIN/XCmail" ]; then
  ln -s $_XCMAILBIN/xc-mail $_XCMAILBIN/XCmail
fi

echo "XCmail main program copied and installed."

# --- globals dir ----------------------------------------------------
if [ ! -d "$_XCMAILDIR" ]; then
  mkdir $_XCMAILDIR
  chmod 755 $_XCMAILDIR
fi

if [ ! -d "$_XCMAILDIR" ]; then
  echo "Directory $_XCMAILDIR could not be created!"
  echo "Aborting."
  exit
fi

# --- plugins --------------------------------------------------------
if [ ! -d "$_XCMAILDIR/plugins" ]; then
  mkdir $_XCMAILDIR/plugins
  chmod 755 $_XCMAILDIR/plugins
fi

if [ "`ls plugins/*_pl.o 2>/dev/null`" ]; then
  if [ -d "$_XCMAILDIR/plugins" ]; then
    cp plugins/*_pl.o $_XCMAILDIR/plugins
    chmod 755 $_XCMAILDIR/plugins/*
	echo "Plugins copied and installed."
  fi
fi

# --- converters -----------------------------------------------------
if [ ! -d "$_XCMAILDIR/converters" ]; then
  mkdir $_XCMAILDIR/converters
  chmod 755 $_XCMAILDIR/converters
fi

if [ "`ls converters/* 2>/dev/null`" ]; then
  if [ -d "$_XCMAILDIR/converters" ]; then
    cp converters/* $_XCMAILDIR/converters
    chmod 755 $_XCMAILDIR/converters/*
	chmod 644 $_XCMAILDIR/converters/README
	echo "Converters copied and installed."
  fi
fi

# --- finished -------------------------------------------------------

echo
echo "|"
echo "| Done."
echo "| XCmail may now the started with 'xc-mail', 'xcmail' or 'XCmail'."
echo "| To use the global resource directory '$_XCMAILDIR'"
echo "| you should set the environment variable 'XCMAILDIR' to this"
echo "| directory (XCMAILDIR=$_XCMAILDIR eg. in you global or local profile)."
echo "|"
echo "+----------------------------------------------------> have fun!"
echo
