

#include <stdio.h>
#include <string.h>
#include "LL.h"

#define POLY 1
#define VERTEX 2
#define POINT 3
#define POLY_NORMAL 4
#define SPHERE 5
#define CYLN 6
#define COMMENT 7

typedef struct {
  float           x;
  float           y;
  float           z;
}               t_Vertex;
typedef struct {
  float           x;
  float           y;
  float           z;
  float           radius;
}               t_Sphere;

typedef struct {
  t_Sphere        Base;
  t_Sphere        Apex;
}               t_Cyln;

typedef struct {
  t_LL            PolyVertices;
}               t_Polygon;


int
main (argc, argv)
  int             argc;
  char          **argv;
{
  FILE           *fp, *FpOut;
  char            SingleLine[200];
  char            BaseName[60];
  char            Token[20];
  char            Data;
  int             len;
  int             Formatid;
  float           scale = 1.0;
  t_Vertex        Point, *OutPoint;
  t_Polygon       Poly, *OutPoly;
  t_Sphere        Sphere, *OutSphere;
  t_Cyln          Cyln, *OutCyln;
  t_LL            Vertices;
  t_LL            Polygons;
  t_LL            Spheres;
  t_LL            Cylinders;
  int             Num, i;
  float           CyI, CyJ, CyK;

  fprintf (stderr, "nff2gf Filter :- P.Hoad 7/7/93\n");


  if (argc < 2) {
    fprintf (stderr, "Usage: nff2gf infile.[nff] outfile [1/scale]\n ");
    exit (-1);
  }

  if ((fp = fopen (argv[1], "r")) == NULL) {
    fprintf (stderr, "File %s Does not exist\n", argv[1]);
    exit (-1);
  }

  if ((FpOut = fopen (argv[2], "w")) == NULL) {
    fprintf (stderr, "File %s Does not exist\n", argv[2]);
    exit (-1);
  }

  Polygons = ConsLL ();
  Vertices = ConsLL ();
  Spheres = ConsLL ();
  Cylinders = ConsLL ();
  strcpy (BaseName, argv[2]);

  if (argc == 4)
    scale = (float) atoi (argv[3]);

  while (fscanf (fp, "%[^\n]\n", SingleLine) != EOF) {
    if (SingleLine != NULL)
      len = strlen (SingleLine);
    else
      len = 0;
    if (len >= 1) {
      Formatid = 0;
      Data = SingleLine[0];
      sscanf (SingleLine, "%[^ ]", Token);
      if (!strcasecmp (Token, "pp"))
	Formatid = POLY_NORMAL;
      else if (!strcasecmp (Token, "p"))
	Formatid = POLY;
      else if (!strcasecmp (Token, "s"))
	Formatid = SPHERE;
      else if (!strcasecmp (Token, "v"))
	Formatid = VERTEX;
      else if (!strcasecmp (Token, "c"))
	Formatid = CYLN;
      else
	Formatid = COMMENT;
      switch (Formatid) {
      case POLY_NORMAL:
	sscanf (SingleLine, "pp %d", &Num);
	Poly.PolyVertices = ConsLL ();
	for (i = 0; i < Num; i++) {
	  fscanf (fp, "%f %f %f %*f %*f %*f",
		  &Point.x, &Point.y, &Point.z);
	  Point.x = Point.x / scale;
	  Point.y = Point.y / scale;
	  Point.z = Point.z / scale;
	  InsLastLL (Poly.PolyVertices, Point);
	}
	InsLastLL (Polygons, Poly);
	break;
      case POLY:
	sscanf (SingleLine, "p %d", &Num);
	Poly.PolyVertices = ConsLL ();
	for (i = 0; i < Num; i++) {
	  fscanf (fp, "%f %f %f",
		  &Point.x, &Point.y, &Point.z);
	  Point.x = Point.x / scale;
	  Point.y = Point.y / scale;
	  Point.z = Point.z / scale;
	  InsLastLL (Poly.PolyVertices, Point);
	}
	InsLastLL (Polygons, Poly);
	break;
      case SPHERE:
	sscanf (SingleLine, "s %f %f %f %f",
		&Sphere.x, &Sphere.y, &Sphere.z, &Sphere.radius);
	Sphere.x = Sphere.x / scale;
	Sphere.y = Sphere.y / scale;
	Sphere.z = Sphere.z / scale;
	Sphere.radius = Sphere.radius / scale;
	InsLastLL (Spheres, Sphere);
	break;
      case CYLN:
	fscanf (fp, "%f %f %f %f",
		&Cyln.Base.x, &Cyln.Base.y, &Cyln.Base.z, &Cyln.Base.radius);
	Cyln.Base.x = Cyln.Base.x / scale;
	Cyln.Base.y = Cyln.Base.y / scale;
	Cyln.Base.z = Cyln.Base.z / scale;
	Cyln.Base.radius = Cyln.Base.radius / scale;
	fscanf (fp, "%f %f %f %f",
		&Cyln.Apex.x, &Cyln.Apex.y, &Cyln.Apex.z, &Cyln.Apex.radius);
	Cyln.Apex.x = Cyln.Apex.x / scale;
	Cyln.Apex.y = Cyln.Apex.y / scale;
	Cyln.Apex.z = Cyln.Apex.z / scale;
	Cyln.Apex.radius = Cyln.Apex.radius / scale;
	InsLastLL (Cylinders, Cyln);
	break;
      case COMMENT:
	fprintf (FpOut, ";gfCOMM: %s\n", SingleLine);
	break;


      default:
	break;
      }
    }
  }
  fprintf (FpOut, "@Set %s\nFormat Polygon3D\n", BaseName);
  ForeachLL_M (Polygons, OutPoly) {
    fprintf (FpOut, "%d ", SizeLL (Poly.PolyVertices));
    ForeachLL_M (OutPoly->PolyVertices, OutPoint) {
      fprintf (FpOut, "%f %f %f ", OutPoint->x, OutPoint->y, OutPoint->z);
    }
    fprintf (FpOut, "\n");
  }
  fprintf (FpOut, "@\n");
  fprintf (FpOut, "@Set %s\nFormat Sphere3D\n", BaseName);
  ForeachLL_M (Spheres, OutSphere) {
    fprintf (FpOut, "%f %f %f %f\n", OutSphere->x, OutSphere->y, OutSphere->z, OutSphere->radius);
  }
  fprintf (FpOut, "@\n");

  fprintf (FpOut, "@\n");
  fprintf (FpOut, "@Set %s\nFormat OrTruncCylinder3D\n", BaseName);
  ForeachLL_M (Cylinders, OutCyln) {
    CyI = OutCyln->Base.x - OutCyln->Apex.x;
    CyJ = OutCyln->Base.y - OutCyln->Apex.y;
    CyK = OutCyln->Base.z - OutCyln->Apex.z;
    fprintf (FpOut, "%f %f %f %f %f %f %f %f\n", OutCyln->Base.x, OutCyln->Base.y, OutCyln->Base.z, OutCyln->Base.radius, OutCyln->Apex.radius, CyI, CyJ, CyK);
  }
  fprintf (FpOut, "@\n");


 return (0);
}
