static char         sccsid[] = "@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";

/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad
 * This file is part of the Xmgf Software.
 * For conditions of distribution and use, see the accompanying README file.
 *
 *  Vision Speech and Signal Processing Group .
 *  Dept. of Electronic Engineering.
 *  University of Surrey.
 *  Guildford,
 *  Surrey.
 *  England.
 *  Phone: +44 483 300800 Ext 2753
 *  Email: P.Hoad@ee.surrey.ac.uk
 */

#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "3Droutines.h"
#include "Parse.h"
#include "Animator.h"
#include "callbacks.h"
#include "Init.h"
#include "GUI.h"

#define DEFAULT_FRAMES 20


t_LL                RotationParameters;
static double       TimeSliceCount = 0;
static double       FramesPerSlice = DEFAULT_FRAMES;
int                 FlagForward = 0;
int                 FlagRewind = 0;
int                 FlagStop = 0;
int                 FlagPause = 0;
int                 FlagPlay = 0;
int                 FlagReverse = 0;
int                 FlagAutoRev = 0;

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
NewAnimation()
{
  RotationParameters = ConsLL();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillAnimation()
{
  if (RotationParameters != NULL)
    DestLL(RotationParameters);
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
RecordFrame()
{
  static int          FrameCount=0;	
  int 		      FilmSize;

  t_RotParm           TimeSlice;

  FramesPerSlice = DefaultAnimSpeed;
  if (RotationParameters == NULL)
    NewAnimation();
  Touchit();
  TimeSlice.Theta = Theta;
  TimeSlice.Phi = Phi;
  TimeSlice.Gamma = Gamma;
  TimeSlice.ScaleNumber = ScaleNumber;
  TimeSlice.Scale_factor = Scale_factor;
  TimeSlice.DistSC = DistSC;
  TimeSlice.Ox = Ox;
  TimeSlice.Oy = Oy;
  TimeSlice.Oz = Oz;
  TimeSlice.TimePos = TimeSliceCount + FramesPerSlice;
  TimeSliceCount += FramesPerSlice;
  TimeSlice.FramesPerSlice = FramesPerSlice;
  InsLastLL(RotationParameters, TimeSlice);
  FrameCount++; 
  assert(RotationParameters);
  FilmSize = SizeLL(RotationParameters);
  SetAnimFrameLabel(FrameCount,FilmSize);

}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InterPolateFrame(First, Last, Steps)
t_RotParm           First;
t_RotParm           Last;
double              Steps;
{
  double              DTheta, DPhi, DGamma;
  double              DScaleNumber, DDistSC;
  double              DScale_factor;
  double              DOx, DOy, DOz;
  double              i;
  double              DoubleDistSC;
  double              DoubleScaleNumber;
  double              DoubleScale_factor;

  DTheta = (Last.Theta - First.Theta) / Steps;
  DPhi = (Last.Phi - First.Phi) / Steps;
  DGamma = (Last.Gamma - First.Gamma) / Steps;
  DScaleNumber = (Last.ScaleNumber - First.ScaleNumber) / Steps;
  DScale_factor = (Last.Scale_factor - First.Scale_factor) / Steps;
  DDistSC = (Last.DistSC - First.DistSC) / Steps;
  DOx = (Last.Ox - First.Ox) / Steps;
  DOy = (Last.Oy - First.Oy) / Steps;
  DOz = (Last.Oz - First.Oz) / Steps;

 /* Set Up First Frame */
  Theta = First.Theta;
  Phi = First.Phi;
  Gamma = First.Gamma;
  ScaleNumber = (int) First.ScaleNumber;
  Scale_factor = First.Scale_factor;
  DistSC = First.DistSC;
  Ox = First.Ox;
  Oy = First.Oy;
  Oz = First.Oz;

  DoubleDistSC = (double) DistSC;
  DoubleScaleNumber = (double) ScaleNumber;
  DoubleScale_factor = (double) Scale_factor;
  for (i = 0; i < Steps; i++) {
    Theta += DTheta;
    Phi += DPhi;
    Gamma += DGamma;
    DoubleScaleNumber += DScaleNumber;
    DoubleDistSC += DDistSC;
    DoubleScale_factor += DScale_factor;
    Ox += DOx;
    Oy += DOy;
    Oz += DOz;
    DistSC = (int) DoubleDistSC;
    ScaleNumber = (int) DoubleScaleNumber;
    Scale_factor = DoubleScale_factor;
    MakeTwoDim();
    UpdateRotationParms();
    SetScale();
    switch (RotateGuide) {
     case 0:
      Redraw();
      break;
     case 1:
      QuickRedraw();
      break;
    }

  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PlaySlice(a, b)
int                 a;
int                 b;
{
  t_RotParm          *CurrentTimeSlice, *NextTimeSlice;
  double              Count;

  CurrentTimeSlice = NthElmLL(RotationParameters, a);
  NextTimeSlice = NthElmLL(RotationParameters, b);
  Count = fabs((double) ((NextTimeSlice->TimePos) -
      (CurrentTimeSlice->TimePos)));
  Count = (double) DefaultAnimSpeed;
  InterPolateFrame(*CurrentTimeSlice, *NextTimeSlice, Count);

}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PlaySingleFrame()
{

  static int          FrameNumber = 0;
  static int          NFrameNumber = 0;
  int                 FilmSize;
  static int          Direction = 1;
  static int          RelDir = 1;	/* Relative Direction */
  static int          Speed = 1;
  int 		      InCremental=0;

  if (RotationParameters == NULL)
    NewAnimation();
  FilmSize = SizeLL(RotationParameters);
  if (FilmSize > 2) {
 /* Normal Playing */
    if (FlagPlay && (!FlagForward)){
      Speed = 1;
      Direction = RelDir;
    }
    else if (FlagReverse && (!FlagRewind)){
      Speed = 1;
      Direction = RelDir;
    }
    else if (FlagStop)
      Speed = 0;

    if (FlagForward) {
	FrameNumber = FilmSize+1;	
    }

    if (FlagRewind) {
	FrameNumber = 0;	
    }

    if (FlagPause) {
      Speed = 0;
    }
    
    /* Rules for play in both directions */ 
    if (FrameNumber > (FilmSize - Speed -1) && FlagAutoRev == 0 && Direction==1) {
      FrameNumber = 0;
      RelDir = 1;
      Direction = RelDir;
    }
    if (FrameNumber > (FilmSize - Speed -1) && FlagAutoRev == 1 && Direction==1) {
      FrameNumber = (FilmSize+1);
      RelDir = -1;
      Direction = RelDir;
    }
    if (FrameNumber < (Speed +1) && FlagAutoRev == 0 && Direction== -1) {
      FrameNumber = (FilmSize+1);
      RelDir = -1;
      Direction = RelDir;
    }
    if (FrameNumber <= (Speed +1) && FlagAutoRev == 1 && Direction == -1) {
      FrameNumber = 0;
      RelDir = 1;
      Direction = RelDir;
    }

    if (FlagPlay || FlagReverse) {
      InCremental = Speed * Direction;
      FrameNumber += InCremental;
      NFrameNumber = FrameNumber + InCremental;
    }
/*    fprintf(stderr,"%d %d %d %d %d %d\n",Speed,Direction,InCremental,FrameNumber,NFrameNumber,FilmSize);*/
    SetAnimFrameLabel(FrameNumber,FilmSize);
    PlaySlice(FrameNumber, NFrameNumber);
  }
}



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SaveAnimation(Filename)
char               *Filename;
{
  t_RotParm          *Slice;
  FILE               *AnimFilePtr;
  int                 FilmSize;
  int                 SliceCount;

  AnimFilePtr = fopen(Filename, "w");

  FilmSize = SizeLL(RotationParameters);
  fprintf(AnimFilePtr, "%d\n", FilmSize);
  SliceCount = 0;
  ForeachLL_M(RotationParameters, Slice) {
    SliceCount++;
    fprintf(AnimFilePtr, "%d\n", SliceCount);
    fprintf(AnimFilePtr, "%f %f %f\n%f %f %f\n%f %f %f\n",
      Slice->Theta, Slice->Phi, Slice->Gamma,
      Slice->ScaleNumber, Slice->Scale_factor, Slice->DistSC,
      Slice->Ox, Slice->Oy, Slice->Oz);
  }
  fclose(AnimFilePtr);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
LoadAnimation(Filename)
char               *Filename;
{
  t_RotParm           Slice;
  FILE               *AnimFilePtr;
  int                 FilmSize;
  int                 SliceCount;
  int                 i;

  AnimFilePtr = fopen(Filename, "r");
  RotationParameters = ConsLL();

  fscanf(AnimFilePtr, "%d\n", &FilmSize);
  for (i = 0; i < FilmSize; i++) {
    fscanf(AnimFilePtr, "%d\n", &SliceCount);
    fscanf(AnimFilePtr, "%lf %lf %lf\n%lf %lf %lf\n%lf %lf %lf\n",
      &Slice.Theta, &Slice.Phi, &Slice.Gamma,
      &Slice.ScaleNumber, &Slice.Scale_factor, &Slice.DistSC,
      &Slice.Ox, &Slice.Oy, &Slice.Oz);
    InsLastLL(RotationParameters, Slice);
  }
  fclose(AnimFilePtr);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetAnimationSpeed(NewFramesPerSlice)
int                 NewFramesPerSlice;
{
  FramesPerSlice = NewFramesPerSlice;
}
