static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include "XmgfMalloc.h"

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

#include "Compression.h"
#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "Disp3DGF.h"

#include <assert.h>


/*
 * XV2.21 Compression Handling Routines Author:    John Bradley, University
 * of Pennsylvania (bradley@cis.upenn.edu)
 */

int
ExtensionTest(filename)
char               *filename;
{

  char                Extension[MAX_FILENAME];
  char               *ext;

/*  fprintf(stderr, "Filename %s\n", filename);*/
  ext = (char *) rindex(filename, '.');
  if (!ext)
    ext = filename;
  else
    ext++;
  strcpy(Extension, ext);
  if (strlen(Extension) > 2) {
    if (!strncasecmp(Extension, "geom", 4))
      return IMPORT_OFF_FILE;
    else if (!strncasecmp(Extension, "nff", 3))
      return IMPORT_NFF_FILE;
    else if (!strncasecmp(Extension, "ray", 3))
      return IMPORT_RAY_FILE;
    else if (!strncasecmp(Extension, "sla", 3))
      return IMPORT_SLA_FILE;
    else if (!strncasecmp(Extension, "obj", 3))
      return IMPORT_OBJ_FILE;
    else if (!strncasecmp(Extension, "dxf", 3))
      return IMPORT_DXF_FILE;
    else if (!strncasecmp(Extension, "part", 4))
      return IMPORT_IGRIP_FILE;
    else if (!strncasecmp(Extension, "text", 3))
      return IMPORT_MINICAD_FILE;
    else
      return 0;
  }
  return 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* CompressionTest */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
CompressionTest(fullname, filename)
char               *fullname;
char               *filename;
{
  int                 i;
  char               *tmpdir;
  char                basefname[MAX_FILENAME];
  char               *tmp;
  int                 status;
  char                CompressCommandName[100];

  if (WindowOpen)
    BusyCursor();
  tmpdir = (char *) getenv("TMPDIR");
  if (!tmpdir)
    tmpdir = "/tmp";

 /* compute basefname */
  tmp = (char *) rindex(fullname, '/');
  if (!tmp)
    tmp = fullname;
  else
    tmp++;
  strcpy(basefname, tmp);

  i = strlen(fullname);
  if (WindowOpen)
    BusyCursor();
  if (i > 2 && strcmp(fullname + i - 2, ".Z") == 0) {
    strcpy(CompressCommandName, appres.CompressCommand);
    status = CompressionCmd(tmpdir, filename, fullname, basefname, CompressCommandName);
  } else if (i > 3 && strcmp(fullname + i - 3, ".gz") == 0) {
    strcpy(CompressCommandName, appres.GZipCommand);
    status = CompressionCmd(tmpdir, filename, fullname, basefname, CompressCommandName);
  } else {
    strcpy(filename, fullname);
    status = 0;
  }

  if (WindowOpen)
    BusyCursor();
  return status;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* CompressError */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
CompressionCmd(tmpdir, filename, fullname, basefname, CompressCommand)
char               *tmpdir;
char               *filename;
char               *fullname;
char               *basefname;
char               *CompressCommand;
{
  int                 status = 0;
  char                str[MAX_FILENAME];

  sprintf(filename, "%s/xmgf_XXXXXX", tmpdir);
  mktemp(filename);
  if (WindowOpen)
    BusyCursor();
  sprintf(str, "%s -c %s >%s", CompressCommand, fullname, filename);
  if (WindowOpen)
    BusyCursor();
  if (system(str)) {
    fprintf(stderr, "Unable to uncompress '%s'...using %s \n",
    basefname, CompressCommand);
    status = -1;
/*    exit(0);*/
  } else
    status = 1;
  return status;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* CompressionCleanUp */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CompressionCleanUp(filename)
char               *filename;
{
  char                str[128];
  int                 status;

  sprintf(str, "%s %s", appres.RemoveCommand, filename);
  if (system(str)) {
    fprintf(stderr, "Unable to Remove file '%s'...\n", filename);
    status = 0;
    exit(0);
  } else
    status = 1;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Import Commands */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
ImportCmd(filename, ImportType)
char               *filename;
int                 ImportType;
{
  char               *ImportCommand;
  char               *tmpdir;
  char               *newfilename;
  int                 status;

  ImportCommand = (char *) XmgfMalloc(100 * sizeof(char));
  assert(ImportCommand);
  newfilename = (char *) XmgfMalloc(100 * sizeof(char));
  assert(newfilename);

  if (WindowOpen)
    BusyCursor();
  tmpdir = (char *) getenv("TMPDIR");
  if (!tmpdir)
    tmpdir = "/tmp";

  if (WindowOpen)
    BusyCursor();
  sprintf(newfilename, "%s/xmgf_XXXXXX", tmpdir);
  mktemp(newfilename);
  switch (ImportType) {
   case IMPORT_OFF_FILE:
    sprintf(ImportCommand, "%s %s %s.gf 100", appres.off2gf, filename, newfilename);
    break;
   case IMPORT_NFF_FILE:
    sprintf(ImportCommand, "%s %s %s.gf 100", appres.nff2gf, filename, newfilename);
    break;
   case IMPORT_RAY_FILE:	
    sprintf(ImportCommand, "%s %s %s.gf 100", appres.ray2gf, filename, newfilename);
    break;
   case IMPORT_SLA_FILE:	
    sprintf(ImportCommand, "%s %s %s", appres.sla2gf, filename, newfilename);
    break;
   case IMPORT_OBJ_FILE:	
    sprintf(ImportCommand, "%s %s %s.gf 100", appres.obj2gf, filename, newfilename);
    break;
   case IMPORT_DXF_FILE:	
    sprintf(ImportCommand, "%s %s %s.gf ", appres.dxf2gf, filename, newfilename);
    break;
   case IMPORT_IGRIP_FILE:	
    sprintf(ImportCommand, "%s %s %s.gf ", appres.igrip2gf, filename, newfilename);
    break;
   case IMPORT_MINICAD_FILE:	
    sprintf(ImportCommand, "%s %s %s.gf ", appres.minicad2gf, filename, newfilename);
    break;
  }
  if (WindowOpen)
    BusyCursor();
  status = system(ImportCommand);
  sprintf(filename, "%s.gf", newfilename);
  if (WindowOpen)
    BusyCursor();
  if (status == 256)
    return -1;
  return 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* ImportCleanUp */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ImportCleanUp(filename)
char               *filename;
{
  char                str[128];
  int                 status;

  sprintf(str, "%s %s", appres.RemoveCommand, filename);
  if (system(str)) {
    fprintf(stderr, "Unable to Remove file '%s'...\n", filename);
    status = 0;
    exit(0);
  } else
    status = 1;
}

int
BlankEnd(fullname)
char               *fullname;
{
  int                 i;
  char               *tmp;

  tmp = (char *) rindex(fullname, '/');
  if (!tmp) tmp = fullname;
  else tmp++;
  i = strlen(tmp);

  if(i==0)return 1;
  return 0;
}

int
MakeCompressed(fullname,type)
char *fullname;
int type;
{
  int                 status = 0;
  char                str[MAX_FILENAME];

  if (WindowOpen) BusyCursor();

  switch(type){
  case 1:  sprintf(str, "compress %s", fullname);break;
  default: sprintf(str, "gzip %s", fullname);break;
  }

  if (WindowOpen) BusyCursor();
  if (system(str)) {
    switch(type){
    case 1: 
    fprintf(stderr, "Unable to uncompress '%s'...using compress\n", fullname);
	break;
    default: 
    fprintf(stderr, "Unable to uncompress '%s'...using gzip\n", fullname);
	break;
   }
    status = -1;
  } else
  status = 1;
  return status;
}

