static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <stdio.h>
#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "PostScript.h"
#include "ReadWriteParm.h"
#include "Parse.h"
#include "Read3DSet.h"
#include "BackDrop.h"
#include "VersionInfo.h"
#include "MotifUtils.h"

int SelectColours = 1;
int SelectPoints = 0;
int SelectLabels = 1;
int Sorting = 0;
int Centroid = 0;
int DoubleBuff = 0;
int BackFace = 0;
int DefaultLineWidth = 1;
int Axis = 0;
int AxisLabel = 0;
int Axis_Size = 20;
int DefaultAxisSize = 20;
int DefaultAnimSpeed = 20;
int DefaultResolution = 30;
int BackDropImage = 0;
int ExpandImage = 0;
int Origin = 0;
int DefaultLineStyle = SOLIDLS;
int DefaultFillStyle = NOTFILLED;
int DefaultTessLevel = 3;
int DefaultPointSize = 2;
int PSOrientation = 0;
int PSColour = 0;
int BackDropWidth;
int BackDropHeight;
int OrBackDropWidth;
int OrBackDropHeight;
int polydiv = 1;
int FillPolys = 0;
int Oldviewtype = 0;
int DepthCueing = 0;
int PointCueing = 0;
int RotateGuide = 0;
int BackGroundColour = DEFAULTCOL;
int AutoRotateFlag = 0;
int AutoCommand=0;
int GFColours=0;
int  AxisType=0;
int  AxisColour=1;
int  OrthoGraphicProj=0;
int  TwoDimSettings=0;
int DefaultPointType=0;
int      OutLineColour=0;
int      OutLine=0;
int      DitherFill=0;
/* HaloedColor */
int    HaloedColor=63;
int    ScrClrThes=100;
int    RedBlue=0;
int    LeftEyeColour=0;
int    RightEyeColour=0;
int    TranslationStep=5;


#ifdef ICON_PANEL
int  ICONPANEL=1;
#else
int  ICONPANEL=0;
#endif

#ifndef FIXATE_ON_CENTROID
int FixateType = 0;

#else
int FixateType = 1;

#endif

#ifdef AUTOSCALE_ON_ALL
int ScaleObectType = 0;

#else
int ScaleObectType = 1;

#endif

int DefaultARThetaStep = 1;
int DefaultARPhiStep = 1;
int DefaultARGammaStep = 1;
int ARThetaStep = 5;
int ARPhiStep = 5;
int ARGammaStep = 5;
int ARScale = 1;
char commandfile[100];
char controlfile[100];

double UserScaleFactor = 4;
int DefaultMaxDisp = 1000;

/*#define MyXmgfErr(A){fprintf(stderr,"Xmgf Error: %s",(A));}*/

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Parse the command line */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ParseCommandLine(argc, argv)
int argc;
char **argv;
{
/*----------------------------------oOo------------------------------------*/
/* Parse the command line */
/*----------------------------------oOo------------------------------------*/
	char parmfile[30];
	char filename[100];
	char BckGrdStr[100];
	XmString NewName;

	argc -= 0;
	argv += 0;		/* skip over infile and outfile names */

	while ((--argc > 0) && ((*++argv)[0] == '-')) {
		switch (argv[0][1]) {
		    case 'w':	/* Max Displacement  Selection */
			sscanf(GetOption(), "%d", &DefaultMaxDisp);
			break;
		    case 'A':	/* Load Parmfile  */
			sscanf(GetOption(), "%s", parmfile);
			LoadParmSpecify(parmfile);
			break;
		    case 'B':	/* Sorting */
			Sorting = 1;
			break;
		    case 'C':	/* User Colour Selection */
			SelectColours = 1;
			break;
		    case 'D':	/* PointType  */
			sscanf(GetOption(), "%d", &DefaultPointType);
			break;
		    case 'E':	/* Expand Image */
			ExpandImage = 1;
			break;
		    case 'F':	/* FillType  */
			sscanf(GetOption(), "%d", &FillPolys);
			break;
		    case 'H':	/* Circle DefaultResolution  */
			sscanf(GetOption(), "%d", &DefaultResolution);
			break;
		    case 'I':	/* Turn Origin on */
			Origin = 1;
			break;
		    case 'J':	/* Get Default  line style */
			sscanf(GetOption(), "%d", &DefaultLineStyle);
			if (DefaultLineStyle < 0 || DefaultLineStyle > 2)
				DefaultLineStyle = SOLIDLS;
			break;
		    case 'K':	/* Sphere tesserlation */
			sscanf(GetOption(), "%d", &DefaultTessLevel);
			break;
		    case 'L':	/* Labels */
			SelectLabels = 1;
			break;
		    case 'M':	/* Centroid */
			Centroid = 1;
			break;
		    case 'N':	/* Double Buffering */
			DoubleBuff = 1;
			break;
		    case 'O':	/* Orthographic+Perspective  */
			viewtype = 1;
			break;
		    case 'P':	/* PolyApprox  */
			sscanf(GetOption(), "%d", &polydiv);
			break;
		    case 'Q':	/* BackFace Culling */
			BackFace = 1;
			break;
		    case 'R':	/* User Point Selection defunct */
			SelectPoints = 1;
			break;
		    case 'S':	/* Stereo  */
			/* viewtype=2;break; */
			break;
		    case 'T':	/* DefaultLineWidth  */
			sscanf(GetOption(), "%d", &DefaultLineWidth);
			fprintf(stderr,"Thickness %d\n",DefaultLineWidth);
			break;
		    case 'U':	/* DefaultPointSize  */
			sscanf(GetOption(), "%d", &DefaultPointSize);
			break;
		    case 'V':	/* Postscript Orientation  */
			PSOrientation = LANDSCAPE;
		    case 'W':	/* Scalefactor - Scalefoactor */
			sscanf(GetOption(), "%lf", &UserScaleFactor);
			break;
		    case 'X':	/* Axis Selection */
			AxisLabel = 1;
			break;
		    case 'Y':	/* Depth Cueing */
			DepthCueing = 1;
			break;
		    case 'Z':	/* Axis Size  */
			sscanf(GetOption(), "%d", &DefaultAxisSize);
			Axis = 1;
			break;
		    case 'a':	/* RotateGuide */
			RotateGuide = 1;
			break;
		    case 'b':	/* Image in background */
			sscanf(GetOption(), "%s", BckGrdStr);
			BackImage = ReadImage(BckGrdStr, &BackDropWidth, &BackDropHeight);
			OrBackDropWidth = BackDropWidth;
			OrBackDropHeight = BackDropHeight;
			if (BackImage!=NULL) BackDropImage = 1;
			else BackDropImage = 0;
			break;
		    case 'c':   /* Command Fle */
			sscanf(GetOption(), "%s", commandfile);
              		strcpy(controlfile,commandfile);
              		strcat(controlfile,"_cont");
			AutoCommand=1;
              		break;
		    case 'd': /* AutoCommand Usage */
			MyXmgfErr("AutoCommand usage:\n Xmgf [options]\n\
			-d value]  delay[value]\n\
			-t [value] Theta=Theta+value(degrees)\n\
			-q [value] Phi=Phi+value(degrees)\n\
			-g [value] Gamma=Gamma+value(degrees)\n\
			-s [value] Theta=value(degrees)\n\
			-q [value] Phi=+value(degrees)\n\
			-h [value] Gamma=value(degrees)\n\
			-w empty all sets and clear screen\n\
			-y redraw \n\
			-z empty all sets DO NOT clear screen\n\
			-X update those visible\n\
			-v redraw visible\n\
			-G file.gf -G filea.gf (no multiple files) \n\
			-G appends so -z must be used if clear wanted \n\
			Xmgf Options -A......Z\n\
			\n");
                        exit(0);
                        break;
		    case 'e':
			AutoRotateFlag = 1;
			break;
		    case 'f':
			GFColours = 1;
			break;
		    case 'i':	/* Axis Size  */
			sscanf(GetOption(), "%d", &AxisType);
			Axis = 1;
			break;
		    case 'j':	/* Axis Size  */
			sscanf(GetOption(), "%d", &AxisColour);
			Axis = 1;
			break;
		    case 'k':
			OrthoGraphicProj = 1;
			break;
		    case 'l':
			TwoDimSettings = 1;
			break;
		    case 'n':
			ICONPANEL = 0;
			break;
		    case 'o':
			OutLine = 1;
			break;
		    case 'p':	/* Point Size Cueing */
			PointCueing = 1;
			break;
		    case 'q':	/* learScreenThres */
			sscanf(GetOption(), "%d", &ScrClrThes);
			break;
		    case 'r':	/* Axis Size  */
			sscanf(GetOption(), "%d", &TranslationStep);
			break;
		    case 'G':	/* load a file(s) with .gf 3D-sets, @xgf A.Tai
				   G.Matas */
			/* Allows compress files though */
			sscanf(GetOption(), "%s", filename);
			/* Newish to get rid of compile bug */
        		NewName = Str2MotStr(filename);
            		InsLastLL(CurrentFileList,NewName);
			if (Read3DSets(filename) != 0) {
				fprintf(stderr, "Error Reading %s\n", filename);
				exit(0); }
			/* multiple file can be specified */
			while ((--argc > 0) && ((*++argv)[0] != '-')) {
			fprintf(stderr,"%s\n",filename);
				sscanf(*argv, "%s", filename);
        			NewName = Str2MotStr(filename);
            			InsLastLL(CurrentFileList,NewName);
				if (Read3DSets(filename) != 0) {
				fprintf(stderr, "Error Reading %s\n", filename); exit(0); }
			}
			argc++; argv--;
			break;
		    case 'h':
		    case 'u':
			MyXmgfErr("usage:\n Xmgf [options]\n\
	  -a Rotation Guide\n\
	  -b Background Image \n\
	  -c [filename] Command file ( see manual )\n\
	  -d AutoCommand Usage\n\
	  -e AutoRotate \n\
	  -f xgf Automatic Colouring \n\
          -uh This message\n\
	  -i AxisType 0 1 2\n\
	  -j AxisColour 0 1 (default =1) \n\
	  -k OrthoGraphicProjection ( Focal Length > Inf )\n\
	  -l 2D settings\n\
	  -n No Icon Panel at side \n\
	  -o outline \n\
	  -p point cueing \n\
	  -q Clear Screen Threshold (100 polygons)(defunct)\n\
	  -r Translation Step (default 5)\n\
          -w max displacement default=1000\n\
          -A [parmfile] Read Parameter file\n\
          -B Polygon Sorting\n\
          -C User Colour Selection\n\
          -D DefaultPointType (Select Point type)\n\
	  -E Expand Background Image\n\
          -F FillType  (Select FillType )\n\
          -G Load file(s)\n\
          -H Resolution of Circular Objects\n\
	  -I Origin On\n\
	  -J LineStyle (0=Solid 1=Dot 2=Dash)\n\
	  -K Tesserlation Value\n\
          -L Labels\n\
          -M Add Centroid\n\
          -N Double Buffering\n\
          -O Orthographic+Perspective\n\
          -P PolyApprox (PointSet)\n\
          -Q BackFace Culling\n\
          -R User PointType Selection\n\
          -S Stereo (defunct)\n\
          -T LineWidth (Select Line Width)\n\
          -U PointSize \n\
	  -V Postscript Orientation (Set=LandScape/Default=Portrait)\n\
	  -W UserScaleFactor\n\
          -X Axis\n\
          -Y DepthCueing\n\
          -Z Axis_Size\n\
           \n");
			exit(0);
			break;


		}
	}
	return ;
}
