static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include <X11/StringDefs.h>
#include "PostScript.h"
#include "Pixmaps.h"
#include "3Droutines.h"
#include "Parse.h"
#include "VersionInfo.h"
#include "Disp3DGF.h"
#include "Init.h"
#include "XmgfFont.h"

int     OutPost;
int     OutPostCol;
int     PostEPS;
FILE   *PSFilePtr;

#ifndef _NO_PROTO 
void DetermineColour(int Color,char *ColourString);
void PSMakeOutLine(XPoint *Pts,int num,int LineWidth);
#else 
void DetermineColour();
void PSMakeOutLine();
#endif 


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SavePSCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  int     ColourRequest = (int) client_data;
  int     FileType;

  switch (ColourRequest) {
   case SAVE_COLOUR_PORT:
   case SAVE_COLOUR:
    FileType = SAVE_PSCOL_FILE;
    PSOrientation = PORTRAIT;
    PostEPS = 0;
    break;
   case SAVE_GREY_PORT:
   case SAVE_GREY:
    FileType = SAVE_PS_FILE;
    PSOrientation = PORTRAIT;
    PostEPS = 0;
    break;
   case SAVE_GREY_LAND:
    FileType = SAVE_PS_FILE;
    PSOrientation = LANDSCAPE;
    PostEPS = 0;
    break;
   case SAVE_COLOUR_LAND:
    FileType = SAVE_PSCOL_FILE;
    PSOrientation = LANDSCAPE;
    PostEPS = 0;
    break;
   case SAVE_EPS_PORT:
    PSOrientation = PORTRAIT;
    FileType = SAVE_PSCOL_FILE;
    PostEPS = 1;
    break;
   case SAVE_EPS_LAND:
    PSOrientation = LANDSCAPE;
    FileType = SAVE_PSCOL_FILE;
    PostEPS = 1;
    break;
   default:
    FileType = SAVE_PS_FILE;
    PSOrientation = PORTRAIT;
    PostEPS = 0;
    break;
  }
  if (!PostEPS)
    XmFileSelect("Save PostScript File", FileType, POSTFIL, "Out.ps", POSTDIR);
  else
    XmFileSelect("Save Encapsulated-PostScript File", FileType, EPSFIL, "Out.eps", EPSDIR);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutputPS(fname, Col, Orientation)
char   *fname;
int     Col;
int     Orientation;
{
  switch (Col) {
   case SAVE_COLOUR:
    OutPostCol = 1;
    break;
   case SAVE_GREY:
    OutPost = 1;
    break;
   default:
    OutPost = 1;
    break;
  }

  if ((PSFilePtr = fopen(fname, "w")) == NULL)
    return ;
  else if (OutPost == 1 || OutPostCol == 1)
    InitPostScript(PSOrientation);
  REDRAW_SCREEN;
  if (OutPost == 1 || OutPostCol == 1)
    EndPostScript();
  fclose(PSFilePtr);
  OutPost = 0;
  OutPostCol = 0;
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PolygonPS(Pts, num, fill, TmpWind, Color, PtType, BaseType, LineStyle, LineWidth, FillStyle,ShadedVal)
XPoint *Pts;
int     num;
int     fill;
Window  TmpWind;
int     Color;
int     PtType;
int     BaseType;
int     LineStyle;
int     LineWidth;
int     FillStyle;
int     ShadedVal;
{
  int     i;
  double  PSLineWidth = (double) LineWidth / 2;
  char    ColourString[10];
  char    HaloedColourString[10];
  char    FontName[30];
  int     P = DefaultPointSize;

  DetermineColour(Color,ColourString);
  DetermineColour(HaloedColor,HaloedColourString);

  fill = DetermineFillType(fill, num, PtType, FillStyle, BaseType);

  switch (fill) {
   case DOT:{
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "%.2f %.2f m ", Pts[0].x - 0.25, -Pts[0].y + 0.25);
      fprintf(PSFilePtr, "%.2f %.2f l ", Pts[0].x + 0.25, -Pts[0].y + 0.25);
      fprintf(PSFilePtr, "%.2f %.2f l ", Pts[0].x + 0.25, -Pts[0].y - 0.25);
      fprintf(PSFilePtr, "%.2f %.2f l ", Pts[0].x - 0.25, -Pts[0].y - 0.25);
      fprintf(PSFilePtr, "%.2f %.2f l ", Pts[0].x - 0.25, -Pts[0].y + 0.25);
      fprintf(PSFilePtr, "%.2f slw ", 1.0);
      fprintf(PSFilePtr, "s\n");
      break;
    }
   case PLUS:{
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "%d %d m ", (int) Pts[0].x - P, (int) -Pts[0].y);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x + P, (int) -Pts[0].y);
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "s ");
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "%d %d m ", (int) Pts[0].x, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x, (int) -Pts[0].y - P);
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "s\n");
      break;
    }
   case CROSS:{
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "%d %d m ", (int) Pts[0].x - P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x + P, (int) -Pts[0].y - P);
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "s ");
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%d %d m ", (int) Pts[0].x - P, (int) -Pts[0].y - P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x + P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "s\n");
      break;
    }
   case BOX:{
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "%d %d m ", (int) Pts[0].x - P, (int) -Pts[0].y - P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x + P, (int) -Pts[0].y - P);
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "s ");
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%d %d m ", (int) Pts[0].x + P, (int) -Pts[0].y - P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x + P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "s ");
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%d %d m ", (int) Pts[0].x + P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x - P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "s ");
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%d %d m ", (int) Pts[0].x - P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x - P, (int) -Pts[0].y - P);
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "s\n");
      break;
    }
   case TRI:{
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%d %d m ", (int) Pts[0].x - P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x + P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "s ");
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%d %d m ", (int) Pts[0].x + P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x, (int) -Pts[0].y - P);
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "s ");
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%d %d m ", (int) Pts[0].x, (int) -Pts[0].y - P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x - P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "s\n");
      break;
    }
   case FILLEDTRI:{
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "%d %d m ", (int) Pts[0].x - P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x + P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x, (int) -Pts[0].y - P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x - P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "clp\n");
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "fill\n");
      fprintf(PSFilePtr, "s\n");
      break;
    }
   case FILLEDBOX:{
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "%d %d m ", (int) Pts[0].x - P, (int) -Pts[0].y - P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x + P, (int) -Pts[0].y - P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x + P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x - P, (int) -Pts[0].y + P);
      fprintf(PSFilePtr, "%d %d l ", (int) Pts[0].x - P, (int) -Pts[0].y - P);
      fprintf(PSFilePtr, "clp\n");
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "fill\n");
      fprintf(PSFilePtr, "s\n");
      break;
    }
   case PTCIRCLE:{
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "%d %d ", (int) Pts[0].x, (int) -Pts[0].y);
      fprintf(PSFilePtr, "%d 0 360 arc \n", P);
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "s\n");
      break;
    }
   case FILLEDCIRCLE:{
      fprintf(PSFilePtr, "n ");
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "%d %d ", (int) Pts[0].x, (int) -Pts[0].y);
      fprintf(PSFilePtr, "%d 0 360 arc \n", P);
      fprintf(PSFilePtr, "%.2f slw ", PSLineWidth);
      fprintf(PSFilePtr, "fill\n");
      fprintf(PSFilePtr, "s\n");
      break;
    }
   case FILLEDSPHERE:{
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "%d %d %d %f %f sp\n", (int) Pts[0].x, (int) -Pts[0].y,P,(float)P/4.0,(float)P/8.0);
      break;
   }

   case FILLEDOPAQUE:{
      fprintf(PSFilePtr, "n\n");
      fprintf(PSFilePtr, "%d %d m\n", (int) Pts[0].x, (int) -Pts[0].y);
      for (i = 1; i < num; i++) {
	fprintf(PSFilePtr, "%d %d l\n", (int) Pts[i].x, (int) -Pts[i].y);
      }
      fprintf(PSFilePtr, "%d %d l\n", (int) Pts[0].x, (int) -Pts[0].y);
      fprintf(PSFilePtr, "clp\n");
      fprintf(PSFilePtr, "%.2f slw\n", PSLineWidth);
      fprintf(PSFilePtr, "1 sgy\n");
      fprintf(PSFilePtr, "fill\n");
      fprintf(PSFilePtr, "0 sgy\n");
      fprintf(PSFilePtr, "n\n");
      fprintf(PSFilePtr, "%d %d m\n", (int) Pts[0].x, (int) -Pts[0].y);
      for (i = 1; i < num; i++) {
	fprintf(PSFilePtr, "%d %d l\n", (int) Pts[i].x, (int) -Pts[i].y);
      }
      fprintf(PSFilePtr, "%d %d l\n", (int) Pts[0].x, (int) -Pts[0].y);
      fprintf(PSFilePtr, "%.2f slw\n", PSLineWidth);
      fprintf(PSFilePtr, "s\n");
      break;
    }
   case COLOUREDOPAQUE:{
      fprintf(PSFilePtr, "n\n");
      fprintf(PSFilePtr, "%d %d m\n", (int) Pts[0].x, (int) -Pts[0].y);
      for (i = 1; i < num; i++) {
	fprintf(PSFilePtr, "%d %d l\n", (int) Pts[i].x, (int) -Pts[i].y);
      }
      fprintf(PSFilePtr, "%d %d l\n", (int) Pts[0].x, (int) -Pts[0].y);
      fprintf(PSFilePtr, "clp\n");
      fprintf(PSFilePtr, "%.2f slw\n", PSLineWidth);
      fprintf(PSFilePtr, "1 sgy\n");
      fprintf(PSFilePtr, "fill\n");
      fprintf(PSFilePtr, "0 sgy\n");
      fprintf(PSFilePtr, "n\n");
      fprintf(PSFilePtr, "%d %d m\n", (int) Pts[0].x, (int) -Pts[0].y);
      for (i = 1; i < num; i++) {
	fprintf(PSFilePtr, "%d %d l\n", (int) Pts[i].x, (int) -Pts[i].y);
      }
      fprintf(PSFilePtr, "%d %d l\n", (int) Pts[0].x, (int) -Pts[0].y);
      fprintf(PSFilePtr, "%.2f slw\n", PSLineWidth);
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "s\n");
      break;
    }
   case WHITELINES:{
      fprintf(PSFilePtr, "n\n");
      fprintf(PSFilePtr, "%d %d m\n", (int) Pts[0].x, (int) -Pts[0].y);
      for (i = 1; i < num; i++) {
	fprintf(PSFilePtr, "%d %d l\n", (int) Pts[i].x, (int) -Pts[i].y);
      }
      fprintf(PSFilePtr, "clp\n");
      fprintf(PSFilePtr, "%.2f slw\n", PSLineWidth);
      fprintf(PSFilePtr, "0.7 sgy\n");
      fprintf(PSFilePtr, "fill\n");
      break;
    }
   case BLACKLINES:{
      fprintf(PSFilePtr, "n\n");
      fprintf(PSFilePtr, "%d %d m\n", (int) Pts[0].x, (int) -Pts[0].y);
      for (i = 1; i < num; i++) {
	fprintf(PSFilePtr, "%d %d l\n", (int) Pts[i].x, (int) -Pts[i].y);
      }
      fprintf(PSFilePtr, "clp\n");
      fprintf(PSFilePtr, "%.2f slw\n", PSLineWidth);
      fprintf(PSFilePtr, ".2 sgy\n");
      fprintf(PSFilePtr, "fill\n");
      break;
    }
   case HALOEDLINES:{
      fprintf(PSFilePtr, "n\n");
      fprintf(PSFilePtr, "%d %d m\n", (int) Pts[0].x, (int) -Pts[0].y);
      for (i = 1; i < num; i++) {
	fprintf(PSFilePtr, "%d %d l\n", (int) Pts[i].x, (int) -Pts[i].y);
      }
      fprintf(PSFilePtr, "clp\n");
      fprintf(PSFilePtr, "%.2f slw\n", PSLineWidth+HALSIZE);
      fprintf(PSFilePtr, "%s\n", HaloedColourString);
/*      fprintf(PSFilePtr, "1.0 sgy\n");*/
      fprintf(PSFilePtr, "s\n");
      fprintf(PSFilePtr, "n\n");
      fprintf(PSFilePtr, "%d %d m\n", (int) Pts[0].x, (int) -Pts[0].y);
      for (i = 1; i < num; i++) {
	fprintf(PSFilePtr, "%d %d l\n", (int) Pts[i].x, (int) -Pts[i].y);
      }
      fprintf(PSFilePtr, "%.2f slw\n", PSLineWidth);
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "s\n");
      PSMakeOutLine(Pts,num,LineWidth);
      break;
    }
  
   case FILLEDHIDDENLINE:{
      fprintf(PSFilePtr, "n\n");
      fprintf(PSFilePtr, "%d %d m\n", (int) Pts[0].x, (int) -Pts[0].y);
      for (i = 1; i < num; i++) {
        fprintf(PSFilePtr, "%d %d l\n", (int) Pts[i].x, (int) -Pts[i].y);
      }
      fprintf(PSFilePtr, "clp\n");
      fprintf(PSFilePtr, "%.2f slw\n", PSLineWidth);
      fprintf(PSFilePtr, ".2 sgy\n");
      fprintf(PSFilePtr, "fill\n");
      fprintf(PSFilePtr, ".7 sgy\n");
      fprintf(PSFilePtr, "n\n");
      fprintf(PSFilePtr, "%d %d m\n", (int) Pts[0].x, (int) -Pts[0].y);
      for (i = 1; i < num; i++) {
        fprintf(PSFilePtr, "%d %d l\n", (int) Pts[i].x, (int) -Pts[i].y);
      }
      fprintf(PSFilePtr, "%.2f slw\n", PSLineWidth);
      fprintf(PSFilePtr, "s\n");
      PSMakeOutLine(Pts,num,LineWidth);
      break;
    }
 
	
   case COLOUREDLINES:
   case FILLEDCOLOR:{
      fprintf(PSFilePtr, "n\n");
      fprintf(PSFilePtr, "%d %d m\n", (int) Pts[0].x, (int) -Pts[0].y);
      for (i = 1; i < num; i++) {
	fprintf(PSFilePtr, "%d %d l\n", (int) Pts[i].x, (int) -Pts[i].y);
      }
      fprintf(PSFilePtr, "clp\n");
      fprintf(PSFilePtr, "%.2f slw\n", PSLineWidth);
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "fill\n");
      PSMakeOutLine(Pts,num,LineWidth);
      break;
    }
   case POINTS_ONLY:{
      fprintf(PSFilePtr, "n\n");
      for (i = 0; i < num; i++) {
	fprintf(PSFilePtr, "%f %f m\n", (int) Pts[i].x - 0.25, (int) -Pts[i].y - 0.25);
	fprintf(PSFilePtr, "%f %f l\n", (int) Pts[i].x + 0.25, (int) -Pts[i].y - 0.25);
	fprintf(PSFilePtr, "%f %f l\n", (int) Pts[i].x + 0.25, (int) -Pts[i].y + 0.25);
	fprintf(PSFilePtr, "%f %f l\n", (int) Pts[i].x - 0.25, (int) -Pts[i].y + 0.25);
	fprintf(PSFilePtr, "%f %f l\n", (int) Pts[i].x - 0.25, (int) -Pts[i].y - 0.25);
      }
      fprintf(PSFilePtr, "clp\n");

      fprintf(PSFilePtr, "%.2f slw\n", PSLineWidth);
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "fill\n");
      break;
    }
   case TEXTLABEL:{
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "%d %d m\n", (int) Pts[0].x, (int) -Pts[0].y);
	switch(FontFamily){
	 case COURIER: strcpy(FontName,"/Courier");break;
	 case NEWCENSCH: strcpy(FontName,"/NewCenturySchlbk-Roman");break;
	 case HELVETICA: strcpy(FontName,"/Helvetica");break;
	 case SYMBOL: strcpy(FontName,"/Symbol");break;
	 case TIMES: strcpy(FontName,"/Times-Roman");break;
	 default: strcpy(FontName,"/Helvetica");break;
	}
      fprintf(PSFilePtr, "(%s) %d %s printword\n", CurrentString,FontSize,FontName);
/*      fprintf(PSFilePtr, "(%s) /Helvetica printword\n", CurrentString);*/
      break;
    }

   default:{
      fprintf(PSFilePtr, "n\n");
      fprintf(PSFilePtr, "%d %d m\n", (int) Pts[0].x, (int) -Pts[0].y);
      for (i = 1; i < num; i++) {
	fprintf(PSFilePtr, "%d %d l\n", (int) Pts[i].x, (int) -Pts[i].y);
      }
      fprintf(PSFilePtr, "%.2f slw\n", PSLineWidth);
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "s\n");
      PSMakeOutLine(Pts,num,LineWidth);
      break;
    }
  }
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InitPostScript(Orientation)
int     Orientation;
{
  int     PMiX, PMiY, PMaX, PMaY;
  int     PWidth, PHeight;

  ImageMinX = 0;
  ImageMinY = 0;
  ImageMaxX = 600;
  ImageMaxY = 800;
  FindScreenMaxMin();
  PMiX = (int) ImageMinX;
  PMiY = (int) ImageMinY;
  PMaX = (int) ImageMaxX;
  PMaY = (int) ImageMaxY;
  PWidth = PMaX - PMiX;
  PHeight = PMaY - PMiY;
  fprintf(PSFilePtr, "%%!PS-Adobe-2.0 EPSF-2.0\n");
  fprintf(PSFilePtr, "%%%%Title: XmgfOutput\n");
  fprintf(PSFilePtr, "%%%%Creator: Xmgfv%s.%s by Paul Hoad\n", appres.XMgfVersion, appres.XMgfRelease);
  if (Orientation)
    fprintf(PSFilePtr, "%%%%Orientation: Landscape\n");
  if (!PostEPS)
    fprintf(PSFilePtr, "%%%%BoundingBox: %d %d %d %d\n",
      ((595 / 2) - (PWidth / 2)), ((842 / 2) - (PHeight / 2)), PMaX + ((595 / 2) - (PWidth / 2)) - PMiX, PMaY + ((842 / 2) - (PHeight / 2)) - PMiY);
  else
    fprintf(PSFilePtr, "%%%%BoundingBox: 0 0 %d %d\n", PWidth, PHeight);


  fprintf(PSFilePtr, "%%%%Pages: 1\n");
  fprintf(PSFilePtr, "%%%%DocumentFonts:\n");
  fprintf(PSFilePtr, "%%%%EndComments\n");
  fprintf(PSFilePtr, "save\n");
  if (PostEPS) {
    fprintf(PSFilePtr, "%d %d translate\n", -PMiX, PMiY);
    fprintf(PSFilePtr, "0 %d translate\n", PHeight);
  } else {
    fprintf(PSFilePtr, "0 842 translate\n");
    fprintf(PSFilePtr, "%d %d translate\n", -PMiX, PMiY);
    fprintf(PSFilePtr, "%d %d translate\n", ((595 / 2) - (PWidth / 2)), -((842 / 2) - (PHeight / 2)));
  }



  fprintf(PSFilePtr, "1 setlinejoin\n");	/* Rounded Join */
 /* 0 = Miter Join */
 /* 1 =  Rounded Join */
 /* 2 =  Bevel Join */
  fprintf(PSFilePtr, "/l {lineto} bind def\n");
  fprintf(PSFilePtr, "/m {moveto} bind def\n");
  fprintf(PSFilePtr, "/s {stroke} bind def\n");
  fprintf(PSFilePtr, "/n {newpath} bind def\n");
  fprintf(PSFilePtr, "/clp {closepath} bind def\n");
  fprintf(PSFilePtr, "/slw {setlinewidth} bind def\n");
  fprintf(PSFilePtr, "/sgy {setgray} bind def\n");
  fprintf(PSFilePtr, "/srgb {setrgbcolor} bind def\n");
  fprintf(PSFilePtr, "/printword{ gsave findfont exch scalefont setfont show grestore } def\n");
  /* Define rules for sphere */
  fprintf(PSFilePtr, "/disk { 0 360 arc } bind def\n");
  fprintf(PSFilePtr, "/filldisk { disk fill } bind def\n");
  fprintf(PSFilePtr, "/clipdisk { disk clip newpath } bind def\n");
#ifdef SPHEREPSGREY 
  fprintf(PSFilePtr, "/sphere { 1  -.05  0 { \n");
  fprintf(PSFilePtr, "4 copy dup 1 exch sub  setgray mul filldisk pop \n");
  fprintf(PSFilePtr, "}for pop pop pop } bind def\n");
#else
  fprintf(PSFilePtr, "/sphere { 1  -.05  0 {4 copy dup 1 exch sub \n");
  fprintf(PSFilePtr, "currentrgbcolor  pop 3 -1 roll setrgbcolor mul\n");
  fprintf(PSFilePtr, "filldisk pop }for pop pop pop } bind def\n");
#endif

  fprintf(PSFilePtr, "/DrSphere { gsave 5 2 roll 3 copy clipdisk 5 1 roll \n");
  fprintf(PSFilePtr, "2 index add  exch 3 index add exch 5 -1 roll 1.4 mul \n");
  fprintf(PSFilePtr, "sphere pop pop grestore } bind def\n");
  fprintf(PSFilePtr, "/sp {DrSphere} bind def\n");

  if (Orientation == 1) {
    fprintf(PSFilePtr, "0 -842 translate\n");
    fprintf(PSFilePtr, "%d %d translate\n", -PMiX, PMiY);
    fprintf(PSFilePtr, "90 rotate\n");
    fprintf(PSFilePtr, "%d %d translate\n", PMiY, -PMiX);
  } else
    fprintf(PSFilePtr, "\n");
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
EndPostScript()
{
  if (!PostEPS)
    fprintf(PSFilePtr, "showpage\n");
  else
    fprintf(PSFilePtr, "%%%%showpage\n");
  fprintf(PSFilePtr, "restore\n");
  PostEPS = 0;
  return ;
}

void
PSMakeOutLine(Pts,num,LineWidth)
XPoint *Pts;
int num;
int LineWidth;
{
    char ColourString[10];
    int i;
    double  PSLineWidth = (double) LineWidth / 2;

    if(OutLine){
    DetermineColour(OutLineColour,ColourString);
      fprintf(PSFilePtr, "n\n");
      fprintf(PSFilePtr, "%d %d m\n", (int) Pts[0].x, (int) -Pts[0].y);
      for (i = 1; i < num; i++) {
        fprintf(PSFilePtr, "%d %d l\n", (int) Pts[i].x, (int) -Pts[i].y);
      }
      fprintf(PSFilePtr, "clp\n");
      fprintf(PSFilePtr, "%.2f slw\n", PSLineWidth);
      fprintf(PSFilePtr, "%s\n", ColourString);
      fprintf(PSFilePtr, "s\n");
    }
}


void DetermineColour(Color,ColourString)
int Color;
char *ColourString;
{
	switch (Color) {
   	case 64:
     		strcpy(ColourString, "0 0 0 srgb");
     		break;
   	case 66:
     		strcpy(ColourString, "0 0 1 srgb");
     		break;
   	case 69:
     		strcpy(ColourString, "0 1 0 srgb");
     		break;
   	case 72:
     		strcpy(ColourString, "0 1 1 srgb");
     		break;
   	case 65:
     		strcpy(ColourString, "1 0 0 srgb");
     		break;
   	case 92:
     		strcpy(ColourString, "1 0 1 srgb");
     		break;
   	case 67:
     		strcpy(ColourString, "1 1 0 srgb");
     		break;
   	case 70:
     		strcpy(ColourString, "1 1 1 srgb");
     		break;
   	case -1:
     		strcpy(ColourString, "0 0 0 srgb");
     		break;
   	default:
		 if (Color > 64)
      		Color = 0;
    		sprintf(ColourString, "%.2f sgy\n", ((double) Color / 64));
    		break;
  	}
}


