#include <stdio.h>
#include <math.h>

#define MyXmgfErr(A){fprintf(stderr,"Xmgf Error: %s",(A));}

#define GetOption() ((*(*argv+2)!='\0')?*argv+2:(argc--,*++argv))
int                 checkzero = 0;
int                 Zonly = 0;


int
main(argc, argv)
int                 argc;
char              **argv;
{
  float               xyz[300][300];
  float               row, col;
  float               z, du;
  float               z1, z2, z3, z4;
  int                 i, j;
  int                 PolyType;

  argc -= 0;
  argv += 0;			/* skip over infile and outfile names */
  PolyType = 0;

  if (argc < 2) {
    MyXmgfErr("usage:\n XYZtoPatch < datain > out.gf [options]\n\
	 -C Remove Empty Zeros \n\
	 -Z file as Z's only \n\
	 -P Polygon rather than polyline\n\
         options:\n");
    exit(1);
  }
  while ((--argc > 0) && ((*++argv)[0] == '-')) {
    switch (argv[0][1]) {
     case 'C':			/* Orthographic+Perspective  */
      checkzero = 1;
      break;

     case 'Z':			/* Orthographic+Perspective  */
      Zonly = 1;
      break;

     case 'P':
      PolyType = 1;
      break;

     default:
      fprintf(stderr, "XYZtoPatch: bad option -%c\n", argv[0][1]);
      break;

    }
  }

  if (checkzero == 1)
    fprintf(stderr, "Removeing Zero Planes\n");

  fscanf(stdin, "%f %f\n", &row, &col);
  if (row >= 257 || col >= 257) {
    fprintf(stderr, "Not that many Row,Cols Max(256)\n");
    exit(0);
  }
  if (row < 0 || col < 0) {
    fprintf(stderr, "Positive Row,Cols only\n");
    exit(0);
  }
  for (i = 0; i < row; i++) {
    for (j = 0; j < col; j++) {
      if (Zonly == 0) {
	fscanf(stdin, "%f %f %f\n", &du, &du, &z);
      } else {
	fscanf(stdin, "%f\n", &z);
      }
      xyz[(int) i][(int) j] = z;
    }
  }
  fprintf(stderr, "%f %f \n", row, col);


  switch (PolyType) {
   case 0:
    fprintf(stdout, "@Set Patch\nFormat Polyline3D\n");
    for (i = 0; i < row - 1; i++) {
      fprintf(stdout, "%f ", col);
      for (j = 0; j < col - 1; j++) {
	z1 = xyz[i][j];
	fprintf(stdout, "%d %d %f ", i, j, z1);
      }
      z1 = xyz[i][j];
      fprintf(stdout, "%d %d %f \n", i, j, z1);
    }
    fprintf(stdout, "@\n");
    break;
   case 1:
    fprintf(stdout, "@Set Patch\nFormat Polygon3D\n");
    for (i = 1; i < row - 1; i++) {
      for (j = 1; j < col - 1; j++) {
	fprintf(stdout, "4 ");
	z1 = xyz[i - 1][j - 1];
	z2 = xyz[i][j - 1];
	z3 = xyz[i][j];
	z4 = xyz[i - 1][j];
	fprintf(stdout, "%d %d %f ", i - 1, j - 1, z1);
	fprintf(stdout, "%d %d %f ", i, j - 1, z2);
	fprintf(stdout, "%d %d %f ", i, j, z3);
	fprintf(stdout, "%d %d %f\n", i - 1, j, z4);
      }
    }
    fprintf(stdout, "@\n");
    break;
  }


  return 0;
}
