.TH COLOR_XTERM 1
.SH NAME
color_xterm \- color terminal emulator for X
.SH DESCRIPTION

\fIColor_xterm\fP is essentially the same as 
.IR xterm (1).
The main differences are described below.
.TP 8
.B ISO 6429 color text support.
.PP
In addition to the Escape sequences supported by xterm, color_xterm
supports the following sequences:
.TP 8
.B ESC [ 3 Ps m
Set the text foreground to color Ps.
.TP 8
.B ESC [ 4 Ps m
Set the text background to color Ps.
.TP 8
According to ISO 6429, the colors are given by:
 0) black
 1) red
 2) green
 3) yellow
 4) blue
 5) magenta
 6) cyan
 7) white
.TP 8
The actual colors that color_xterm uses are customizable as the X
resources "color0", "color1", etc.
.PP
Color_xterm includes the 'Dynamic Colors' patch 
by Erik Fortune (erik@esd.sgi.com).
This allows you to change the foreground, background, etc. colors
dynamically using the "ESC ] Ps ; name BEL" escape sequence, where
Ps determines the color to change and name is the name of the color
to change it to.
        Ps = 10: Foreground
             11: Background
             12: Cursor
             13: Mouse cursor foreground
             14: Mouse cursor background
             15: Tek window foreground
             16: Tek window background

For example, to change the text color to white, you could go

        echo "^[]10;white^G"

The dynamic colors are controlled using the -dc/+dc command line option
or the *dynamicColor X resource.
.PP
The UGCS color_xterm contains the Cursor Warp patch.  If the 
cursorWarpTranslation X resource is set to
an X event, then whenever the color_xterm receives the event, the terminal
generates the cursor movement keys to move the text cursor to the mouse 
cursor.
.PP
The UGCS color_xterm supports the -jobs option, which disables termination
upon receipt of a SIGCHILD.  This is generally only useful with the -e 
option, as most shells intercept a SIGCHILD.  



.SH AUTHORS
.I of xterm:
.PP
	Far too many people, including:
.TP 0
	Loretta Guarino Reid, Joel McCormack, Terry Weissman, Edward Moy,
Ralph R. Swick, Mark Vandevoorde, Bob McNamara, Jim Gettys,
Bob Scheifler, Doug Minki, Steve Pitschke, Ron Newman, Jim Fulton,
Dave Serisky
.PP
.I of color_xterm:
	Tom Weinstein, Erik Fortune, Paul Shupak
.TP 16
Manual page, UGCS hacks and maintaince  courtesy of Jacob Mandelson 
(jlm@ugcs.caltech.edu).


.SH NOTICE
Color_xterm is derived from xterm, whose copyright requires the following 
to appear in the documentation:
.PP
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard,
Massachusetts, and the Massachusetts Institute of Technology,
Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
.TP 16
(Uh, same goes for me, too.  -- JLM) 
