/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: YearP.h,v 1.1.1.1 1996/04/16 15:12:03 leon Exp $ */

#ifndef _YearP_h
#define _YearP_h

#include "Year.h"
#include <X11/CoreP.h>
#include <X11/Xlib.h>
#include "agenda.h"


typedef struct {
    int empty;
} YearClassPart;

typedef struct _YearClassRec {
    CoreClassPart	core_class;
    YearClassPart	year_class;
} YearClassRec;

extern YearClassRec yearClassRec;

typedef struct {
    /* resources */
    Agenda agenda;
    int year;

    Pixel dayForeground;
    Pixel dayBackground;
    Pixel closedDayForeground;
    Pixel closedDayBackground;
    Pixel todayForeground;
    Pixel todayBackground;
    Pixel yearColor;
    Pixel appointmentColor;
    String closedDaysFile;

    String dateFormat; /* 4 chars from 'y 'm' 'd' 'w'*/
    String months[12];
    String days[7];
    Pixel monthColors[12];
/*    Pixel dayColors[7];*/
    XFontStruct *yearFont;
    XFontStruct *monthFont;
    XFontStruct *dayFont;

    String layout;
    Position leftMargin;
    Position topMargin;
    Position monthOffset;
    Position dayOffset;
    Position dayWidth;
    Position dayHeight;
    Position dayMargin;

    /* private state */
    GC gc;
    GC month_gc;
    GC day_gc;
    Position xoffset;
    Position yoffset;
    Cardinal Hnum;
    Cardinal Vnum;
    WeekDay startWeekOn;
    WeekDay firstWeekDayOfTheYear;
    XRectangle selected;
    Date *clicked;
    Date selday;
    Date today;
    XtCallbackList dateCallback;
    unsigned short appointments[32]; /* 16 bits for 12 months */
    unsigned long closedDays[12];

} YearPart;

typedef struct _YearRec {
    CorePart		core;
    YearPart	year;
} YearRec;

#endif /* _YearP_h */
