/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: misc.c,v 1.1.1.1 1996/04/16 15:12:04 leon Exp $ */
#include <string.h>
#include <ctype.h>



/*
 * strdup is not provided by all systems. here is one
 * which does the trick
   ( copied from the Xpm distrib, misc.c )
 */
char *
Strdup(s1)
    char *s1;
{
    char *s2;
    int l;
    
    if(NULL == s1) return NULL;
    l = strlen(s1) + 1;

    if (s2 = (char *) malloc(l))
	strncpy(s2, s1, l);
    return s2;
}

 


#ifdef NEED_CUSERID
char *cuserid(char *loc)
{
	return getenv("USER");
}
#endif /* NEED_CUSERID */



void ToLower(source, dest)
    register char  *source, *dest;
{
    register char ch;
    int i;

    for (i = 0; (ch = *source) != 0 && i < 999; source++, dest++, i++) {
    	if ('A' <= ch && ch <= 'Z')
	    *dest = ch - 'A' + 'a';
	else
	    *dest = ch;
    }
    *dest = 0;
}
