#include <ihm.h>
#include <kmus.h>


f_kmus_chg_ctrl (canal, type, valeur)
BYTE canal, type, valeur;
{
 BYTE form;

 form = canal;

 if (form >=K_NB_MAX_INST )
   {
    Dprintf (stderr, "\nCtrl.type %d: %d sur form %d non affichable", type, valeur, form);
    return;
   }

 switch (type)
   {
    case MODULATION : XtVaSetValues (tab_control_panel[form].vibrato, XmNvalue,
			valeur, NULL);
			break;

    case VOLUME : XtVaSetValues (tab_control_panel[form].volume, XmNvalue,
			valeur, NULL);
			break;

    case EXPRESSION : XtVaSetValues (tab_control_panel[form].velocity,XmNvalue,
			valeur, NULL);
			break;

    case PAN : XtVaSetValues (tab_control_panel[form].panning,XmNvalue,
			valeur, NULL);
			break;

    case BREATH : XtVaSetValues (tab_control_panel[form].breath,XmNvalue,
			valeur, NULL);
			break;

    default : if (type != 6 && type != 38  && type != 100 && type != 101)
                Dprintf (stderr, "\nCTRL Type %d ->%d sur le canal %d non traite", type, valeur, form);
              break;
   }

}

f_kmus_chg_pitch (canal, bfaible, bfort)
BYTE canal, bfort, bfaible;
{
 int valeur ;
 BYTE form;

 form = canal ;

 valeur = (bfaible&0x7F)+(bfort<<7);

 if (form < K_NB_MAX_INST )
   XtVaSetValues (tab_control_panel[form].pitch,XmNvalue, valeur, NULL);
 else
   Dprintf (stderr, "\nPitch %d sur form %d non affichable", valeur, form);

}

f_kmus_eq_change (widget, Tag, data)
Widget widget;
XtPointer Tag;
XmAnyCallbackStruct *data;
{
 int value;
 short  tag;

 tag = (short ) Tag;

 XtVaGetValues (widget, XmNvalue, &value, NULL);
Dprintf (stderr, "\nEq modifie -> [%d] ", value);

 p_co_share_tables->volumeCanal[tag] = value;
}

f_kmus_panning_chg (widget, Tag, data)
Widget widget;
XtPointer Tag;
XmAnyCallbackStruct *data;
{
 int value;
 short  tag;

 tag = (short ) Tag;

 XtVaGetValues (widget, XmNvalue, &value, NULL);
Dprintf (stderr, "\nPanning modifie -> [%d] ", value);

 p_co_share_tables->panningCanal[tag] = value;
 f_co_send (K_CO_TYPE_C34, C3_PANNING, (BYTE)value, 0, 0);
}

f_kmus_chg_bpm(Bpm)
BYTE Bpm;
{
 char s[100];
 XmString lab;

 sprintf (s, "Rythme : %d%s%d", p_co_share_tables->bpm,
	(p_co_share_tables->ppm>=0)?"+":"", p_co_share_tables->ppm);

 lab = XmStringCreateSimple (s);

 XtVaSetValues (lab_rythme, XmNlabelString, lab, NULL);

 XmStringFree (lab);
}
 
