#include <ihm.h>
#include <kmus.h>

static Pixmap pixmap;

unsigned short w_rec;

static short drawing_width, drawing_height;

GC led_gc[16];
GC led_gc_bck;

static Boolean b_flat_expose;

f_redraw_flat_led (widget)
Widget widget;
{
 Window self_win;

 self_win = XtWindow (widget);

 if (self_win && XtIsRealized (widget) && pixmap)
   {
    XCopyArea (app_display, pixmap, self_win, X11_gc, 0, 0, drawing_width,
	drawing_height, 0, 0);
    b_flat_expose = True;
   }

}

f_draw_flat_led (widget)
Widget widget;
{
 short X, Y;
 unsigned short h_rec, h2_rec;
 int i, j, cpt;
 XSegment points [MAX_VERTI_CELL * NB_SEG_VERT_BY_CELL ];
 XSegment points1 [MAX_VERTI_CELL];
 int cpt1;
 static GC      Dash_gc;
 static GC      Horiz_trait_gc;
 static GC      Vert_trait_gc;
 char ch[50];
 Window win_for_inst4;
 Window self_win;
 XSetWindowAttributes attrs;
 XmString str;
 int hauteur;
 char niv [15];

 win_for_inst4 = XtWindow (for_inst4);


 self_win = XtWindow (widget);

 XtVaGetValues (widget, XmNwidth, &drawing_width, XmNheight, &drawing_height, NULL);


 pixmap = XCreatePixmap (app_display, RootWindowOfScreen(XtScreen (widget)), drawing_width, drawing_height, widget->core.depth);

 attrs.bit_gravity = ForgetGravity;
 XChangeWindowAttributes (app_display, self_win, CWBitGravity, &attrs);

 w_rec = drawing_width/MAX_HORIZ_CELL ;
 h_rec = drawing_height/MAX_VERTI_CELL/NB_SEG_VERT_BY_CELL;
 h2_rec = drawing_height/MAX_VERTI_CELL/NB_SEG_VERT_BY_CELL*NB_SEG_VERT_BY_CELL;

 Dprintf (stderr, "\n w_rec %d, h_rec %d\n", w_rec, h_rec);

 f_kmus_init_leds();


 if (Dash_gc == NULL) /* graphic contexte pour les pointilles Init la permiere fois*/
   f_kmus_create_gc(&Dash_gc, &Horiz_trait_gc, &Vert_trait_gc, self_win);
    

 /* 
   Trace des separations verticales 
  */

 X = 0;
 cpt1 = 0;
 for (i=0; i<MAX_HORIZ_CELL; i++)
   {
    points[cpt1].x1 = X;
    points[cpt1].y1 = 0;
    points[cpt1].x2 = X;
    points[cpt1].y2 = drawing_height;
    X+=w_rec;
    cpt1++;
   }

 XDrawSegments (app_display, self_win, Vert_trait_gc, points, MAX_HORIZ_CELL);


/*
   Trace des separations horizontales 
 */

 Y = drawing_height;
 cpt = 0;
 cpt1 = 0;
 for (i=0; i<MAX_VERTI_CELL ; i++)
   {
    for (j=0; j<NB_SEG_VERT_BY_CELL; j++)
      {
       points[cpt].x1 = 0;
       points[cpt].y1 = Y;
       points[cpt].x2 = drawing_width;
       points[cpt].y2 = Y;
       Y-=h_rec;
       cpt++;
      }
    points1[cpt1].x1 = 0;
    points1[cpt1].y1 = Y;
    points1[cpt1].x2 = drawing_width;
    points1[cpt1].y2 = Y;
    Y-=h_rec;
    cpt1++;
   }

 XDrawSegments (app_display,self_win , Dash_gc, points, MAX_VERTI_CELL * NB_SEG_VERT_BY_CELL );

 XDrawSegments (app_display, self_win, Horiz_trait_gc, points1, MAX_VERTI_CELL );

 XCopyArea (app_display, self_win, pixmap, X11_gc, 0, 0, drawing_width, drawing_height, 0, 0);


 /* 
    Trace des labels
 */

 hauteur = ((NB_SEG_VERT_BY_CELL+1)* h_rec);
 for (j=1; j<MAX_VERTI_CELL; j++)
   {
    sprintf (ch, "%d", j);
    sprintf (niv, "FlatLev_%d", j);
    str = XmStringCreateLocalized (ch);
    XtVaCreateManagedWidget (niv, xmLabelWidgetClass, for_inst4,
		XmNx, 12 - strlen (ch) * 4,
		XmNy, drawing_height - j*hauteur +15,
		XmNlabelString, str, 
		NULL);
    XmStringFree (str);
   }

 XFreeGC(app_display, Dash_gc);
 XFreeGC(app_display, Horiz_trait_gc);
 XFreeGC(app_display, Vert_trait_gc);

}


f_kmus_on_led (canal, note)
BYTE canal, note;
{
 if (b_flat_expose)
   XDrawRectangle (app_display, XtWindow(dra_inst5), led_gc[canal],
  (unsigned int)((canal * w_rec)+1),
  (unsigned int)(drawing_height - (note *3)+1), w_rec-2, 1);

}

f_kmus_off_led (canal, note)
BYTE canal, note;
{
 if (b_flat_expose)
    XDrawRectangle (app_display, XtWindow(dra_inst5), led_gc_bck,
    (unsigned int)((canal * w_rec)+1),
    (unsigned int)(drawing_height - (note *3)+1), w_rec-2, 1);
}

f_kmus_off_led_on_canal (canal)
BYTE canal;
{
f_redraw_flat_led (dra_inst5);
}

f_kmus_init_leds()
{
 int i;
 
 static Pixel colors_led [8];
 XGCValues valeur;
 Pixel pix_note_off;
 
 colors_led[0] = Col_white;
 colors_led[1] = Col_red;
 colors_led[2] = Col_yellow;
 colors_led[3] = Col_blue;
 colors_led[4] = Col_magenta;
 colors_led[5] = Col_orange;
 colors_led[6] = Col_cyan;
 colors_led[7] = Col_green;

 /*
 valeur.background = Col_grey40;
 */
 XtVaGetValues (dra_inst5, XmNbackground, & pix_note_off, NULL);
 valeur.background = pix_note_off;

 for (i=0; i<8; i++)
   {
    valeur.foreground =  colors_led [i];
    led_gc[i] =  XCreateGC (app_display, XtWindow(dra_inst5), GCForeground|GCBackground, &valeur);
    led_gc[i+8] = led_gc[i];
   }

 /*
 valeur.foreground = Col_grey40;
*/
 valeur.foreground = pix_note_off;

 led_gc_bck =  XCreateGC (app_display, XtWindow(dra_inst5), GCForeground|GCBackground, &valeur);
}
