/*
	 KARAOKE

	 Copyright (c) 1993 JP COCATRIX , L TAIEB. All rights reserved.

kplay_util.c : the midi reader and player utilities
*/

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <co.h>

extern struct DATACOM *pmc;
extern char *strupr(char*);
extern void lyring(char*);
extern char ibm(unsigned char);

#define lowerbyte(x) ((unsigned char)(x & 0xff))
#define upperbyte(x) ((unsigned char)((x & 0xff00)>>8))


/*===========================================================*/
/*  read a string line in a file			     */
/* put the string in buf with a 0 at end. 		     */
/* return the number of byte read			     */
/*===========================================================*/
int getstring(int fd,char* buf,int max)
{
	char c;
	int count=0;
	int ok = TRUE;
	while (ok && (read(fd,&c,1)>0)&& (count < max))
	{
		if (c == 0x0d) 
		{
			ok = FALSE;
			c = 0;
		}
		if (c != 0x0a)
		{
			*(buf++)=c;
			count ++;
		}
	}
	*buf = 0;
	return count;
}

/*****************************************************************/
/*     strupr : convert a string to upper case			 */
/*****************************************************************/
char * strupr(char *str)
{
	int i;
	int len;
	len = strlen(str);
	for (i=0;i<len;i++)
	{
		str[i]=toupper(str[i]);
	}
	return str;
}
/*****************************************************************/
/*     strlwr : convert a string to lower case			 */
/*****************************************************************/
char * strlwr(char *str)
{
	int i;
	int len;
	len = strlen(str);
	for (i=0;i<len;i++)
	{
		str[i]=tolower(str[i]);
	}
	return str;
}



/* parser de .txk */
/******************************************************************/
/*     parse :  search the default configuration                  */
/******************************************************************/
int parse (char *string,char sep,char set) /* sep separator,set jeu complet */
{
char lstring[80];
int deci;
	if (*string != sep) return FALSE;
	string++;
	strlwr(string);
	if (strncmp(string,"ft",2)==0)   	/* jeu de characteres	*/
	{
		sscanf(string,"%2s %*[ =] %d",lstring,&deci);
		if (deci < 10) strcpy(pmc->font,pmc->fontnum[deci]);
		return TRUE;
	}

	if (strncmp(string,"ff",2)==0)       /* colour texte au debut	*/
	{
		sscanf(string,"%2s %*[ =] %d",lstring,&deci);
		if ((deci&0X7F) < MaxColors) strcpy(pmc->fforeground,pmc->palette[deci]);
		return TRUE;
	}
	if (strncmp(string,"af",2)==0)       /* couleur texte actif	*/
	{
		sscanf(string,"%2s %*[ =] %d",lstring,&deci);
		if ((deci&0X7F) < MaxColors) strcpy(pmc->aforeground,pmc->palette[deci]);
		return TRUE;
	}
	if (strncmp(string,"pf",2)==0)       /* couleur texte apres actif*/
	{
		sscanf(string,"%2s %*[ =] %d",lstring,&deci);
		if ((deci&0X7F) < MaxColors) strcpy(pmc->pforeground,pmc->palette[deci]);
		return TRUE;
	}
	if (strncmp(string,"ab",2)==0) /* active background */
	{
		sscanf(string,"%2s %*[ =] %d",lstring,&deci);
		if (deci < MaxColors) strcpy(pmc->abackground,pmc->palette[deci]);
		return TRUE;
	}
	if (strncmp(string,"nb",2)==0) /* normal background */
	{
		sscanf(string,"%2s %*[ =] %d",lstring,&deci);
		if (deci < MaxColors) strcpy(pmc->nbackground,pmc->palette[deci]);
		return TRUE;
	}
	if (strncmp(string,"st",2)==0) /* style */
	{
		sscanf(string,"%2s %*[ =] %d",lstring,&deci);
		if (deci < 12) pmc->styleBack = deci;
		return TRUE;
	}

/*/-----------------------------------------------------*/
	if (set == 0)  /* text option . enable rem	*/
	{
	  if (strncmp(string,"rem",3)==0) /* commentaire */
	  {
		  return TRUE;
	  }
	}
/*/-----------------------------------------------------*/

	if (strncmp(string,"tc",2)==0) /* numero du canal parole Text channel*/
	{
		sscanf(string,"%2s %*[ =] %d",lstring,&deci);
		if (deci>0)deci --; /* commence en 0	*/
		deci %=16;
		pmc->parole = 1<<deci;
		return TRUE;
	}
	if (strncmp(string,"dc",2)==0) /* numero du canal drum channel*/
	{
		sscanf(string,"%2s %*[ =] %d",lstring,&deci);
		if (deci>0) deci --; /* commence en 0	*/
    		deci%=16;
    		pmc->drum = 1<<deci;
		return TRUE;
	}

/* v1.6 added	*/
	if (strncmp(string,"mu",2)==0) /* mute channel*/
	{
		sscanf(string,"%2s %*[ =] %d",lstring,&deci);
		if (deci>0)
    		{
      			deci --; /* commence en 0	*/
      			pmc->mute[deci%16]=TRUE;
    		}
		return TRUE;
	}
	if (strncmp(string,"tr",2)==0) /* transpose channels*/
	{
		sscanf(string,"%2s %*[ =] %d",lstring,&deci);
    		pmc->transpose=deci;
		return TRUE;
	}
	if (strncmp(string,"ve",2)==0) /* volume channels*/
	{
		sscanf(string,"%2s %*[ =] %d",lstring,&deci);
    		pmc->volume=deci;
		return TRUE;
	}
	if (strncmp(string,"ry",2)==0) /* beat (rythme)*/
	{
		sscanf(string,"%2s %*[ =] %d",lstring,&deci);
    		pmc->ppm=deci;
		return TRUE;
	}
/**/

	if (strncmp(string,"re",2)==0) /* registered valid ?*/
/* no registering for karalin */
	{
		sscanf(string,"%2s %*[ =] %s",lstring,string);
		if (TRUE){ pmc->registerflag=TRUE;strcpy(pmc->user,strupr(string));}
		return TRUE;
	}

	return FALSE;
}

/******************************************************************/
/*     sampling : create samples from an input line               */
/******************************************************************/
void sampling ( char *string)
{
	char buf[132];
	int state = FALSE;
	char *ptr;
	int index = 0;

	lyring("\n");
	while( *string != (char)0  )
	{
		*string=ibm(*string);
		switch (*string)
		{
		case ' ':
		case '-':
		case 0X0d:
		case 0x0a:
			if (state)
			{			/* a sample completed */
				buf[index] = (char) 0;
				ptr = (char *)malloc( strlen(buf) +1);
				if (ptr == 0) noroom("sampling");
				strcpy(ptr,buf);
				state = FALSE;
				index = 0;
				lyring(ptr);
			}
			/* elimine les OXOD et - du sample	*/
			if (*string==' ') buf[index++] = *string;
			string++;
			break;
		default:
			buf[index++] = *string;
			string++;
			state = TRUE;
		}
	}
	if (state)
		/* a sample completed */
	{
		buf[index] = (char) 0;
		ptr = (char *)malloc( strlen(buf) +1);
		if (ptr == 0) noroom("sampling");
		strcpy(ptr,buf);
		state = FALSE;
		index = 0;
		lyring(ptr);
	}
}


/*
 * This routine converts delta times in ticks into seconds. The
 * else statement is needed because the formula is different for tracks
 * based on notes and tracks based on SMPTE times.
 *
 */
double
mf_ticks2sec (ticks, division, tempo)
     int division;
     unsigned long tempo;
     unsigned long ticks;
{
  double smpte_format, smpte_resolution;

  if (division > 0)
    return ((double) (((double) (ticks) * (double) (tempo)) / ((double) (division) * 1000000.0)));
  else
    {
      smpte_format = upperbyte (division);
      smpte_resolution = lowerbyte (division);
      return (double) ((double) ticks / (smpte_format * smpte_resolution * 1000000.0));
    }
}				/* end of ticks2sec() */

unsigned long
mf_sec2ticks (secs, division, tempo)
     int division;
     unsigned long tempo;
     double secs;
{
  return (unsigned long) (((secs * 1000.0) / 4.0 * division) / tempo);
}

