/*
  ************************************************************************
  ************************************************************************
    Copyright (C) 1995   Michael J. Oehler

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 Module Description:

  ************************************************************************
  ************************************************************************
*/
#define DEBUG 1

/* Local Includes: crd.h has the data structures needed by this app. xcard.h has all the X & Motif includes */
#include "crd.h"

#include <ctype.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>



/*
  ************************************************************************
  ************************************************************************
  Name
   Any_To_Map

  Calling Sequence

  Description:
    This is not a callback, just a helper routine for the callbacks.
  ************************************************************************
  ************************************************************************
*/
extern void Any_To_Map(governing)
int governing;
{
Card_Content_Ptr tmp_ptr;
int i;

/* If there's room to view a card, figure out which one to map */
if (head_ptr->card_view) 
{
    /* GOVERN is defined as 0 implying one card only to map.
       Otherwise, map one less than the number of cards,
       because the primary card is already mapped! */
    if (governing == 0)
	    governing = 1;
    else
	    governing--;
    
    for ( ; (head_ptr->available_spots) && governing ; governing--) {
	/* Reduce the number of available spots */
	(head_ptr->available_spots)--;

	/* Go to the end of the link list */
	tmp_ptr = head_ptr->viewable_cards;
	for (i = head_ptr->visible_spots; i > 0; i--)
		tmp_ptr = tmp_ptr->next;

	/* Indicate how many widgets are now mapped & then map */
	(head_ptr->visible_spots)++;
	XtMapWidget(tmp_ptr->form);

   } /* for */
} /* end card view */


else {
Card_Content_Ptr tmp_ptr;
Card_Ptr data_ptr;

    /* List View needs to map either 1 newly added card or all cards via govern */
    if (governing == 0) {
	XmString item;
	item = XmStringCreateSimple(head_ptr->primary_card->index);

	/* Select the entry in the primary card position in the list entry */
	data_ptr=head_ptr->card_data;
	for (i=1;  data_ptr != head_ptr->primary_card &&
	     i < head_ptr->cards; i++)
		data_ptr=data_ptr->next;
	
	XmListAddItemUnselected(head_ptr->scroll,item,i);
	XmListSelectPos(head_ptr->scroll,i,False);
	XmStringFree(item);
	
    }
    /* Multiple cards, for example an open or change to List View */
    else 
    {
	XmStringTable str_list;

	/* Creat the space, file in the names from the indexes, & set them in the Widget. */
	str_list= (XmStringTable) XtMalloc( sizeof(XmString *) * (head_ptr->cards));
	data_ptr = head_ptr->card_data;
	for (i=0; i< head_ptr->cards; i++) {
	    str_list[i]=XmStringCreateSimple(data_ptr->index);
	    data_ptr = data_ptr->next;
	}

	XtVaSetValues(head_ptr->scroll,
		      XmNitemCount,     head_ptr->cards,
		      XmNitems,     str_list,
		      NULL);
	
	/* Select the entry in the primary card position in the list entry */
	data_ptr=head_ptr->card_data;
	for (i=1;  data_ptr != head_ptr->primary_card &&
	     i < head_ptr->cards; i++)
		data_ptr=data_ptr->next;
	
	XmListSelectPos(head_ptr->scroll,i,False);
    } /* else in govern */
    
}/* else in card_view */
} /* end Any_To_Map */



/*
   *****************************************************************
   *****************************************************************
   Name
      Grab_Primary_Card_Data
  
   Description:
        This is not a callback, just a helper routine for the
        callbacks.
   *****************************************************************
   *****************************************************************
*/
extern void Grab_Primary_Card_Data(widget)
Widget widget;
{
   char *tmp, *index, *address;

/*
Get any recent updates to the primary card, the user may have type some stuff
Orginal versions checked for a change first, since I have to go to the X
server to get the data, comparing both for a change was useless. Just
assign the data, Just do it.
*/
   tmp = head_ptr->primary_card->index;
   XtFree(head_ptr->primary_card->address);

   index   = XmTextGetString( head_ptr->viewable_cards->index );
   head_ptr->primary_card->index = index;
   head_ptr->primary_card->address = XmTextGetString( head_ptr->viewable_cards->address );

   if (!index || !head_ptr->primary_card->address )
	   Abend(widget,-1,"Unable to allocate memory while reading a text widget\n");

/* Test the orginal index and the new one, if different, need to alphabetize */
   if ( strcmp(tmp, index ) && head_ptr->cards > 1  ) {
       Card_Ptr user_data, dummy;
       int i;

/* The card to move in this re-alphabetization is always the primary card */
       dummy = head_ptr->primary_card;

/* Remove the element from the linked list */       
       dummy->prior->next = dummy->next;
       dummy->next->prior = dummy->prior;

/* If the primary card is also the first card fix master pointer */
       if ( head_ptr->card_data == dummy )
	       head_ptr->card_data = dummy->next;
      
/* Sequentially start from the beginning of the list */
       user_data = head_ptr->card_data;
       for(i=0; i < head_ptr->cards-1; i++) {
	   if ( strcmp(index,user_data->index) <=0 ) {
	       user_data = user_data->prior;
	       break;
	   }
	   user_data = user_data->next;
       }

/* If true, place card at the end of the list */
        if (i == head_ptr->cards)
		user_data = user_data->prior; /* should equal head_ptr->card_data->prior */

/* Check if inserting before the first card, not necessarily the primary card */
       if (i ==0 )
	       head_ptr->card_data = dummy;

/* Insert element into new position */
       user_data->next->prior = dummy;
       dummy->next = user_data->next;
       dummy->prior = user_data;
       user_data->next = dummy;

   }
   XtFree(tmp);
   

}



/*
   *****************************************************************
   *****************************************************************
    Name:
        Redraw_List

    Purpose:
        This is not a callback, just a helper routine for the
        callbacks.

    Calling Sequence:


    Description:

   *****************************************************************
   *****************************************************************
*/
extern void Redraw_List()
{
Card_Content_Ptr tmp_ptr;
Card_Ptr user_data;
int i,n, num_of_digits = 0;
XmString card_label;
static char *label;
static int cards;
char tmp[20];

/*
  This section will only be called ONCE! When Redraw_List is first called.
  It indicates how many cards there are. The code is verbose because it is
  Language independent and works for French, Germam, Spainish, English, etc.
*/
   if (!label)
   {
       XtVaGetValues(head_ptr->label,
			XmNlabelString,		&card_label,
			NULL);

       /* get the char string for the label, stored as a static */
       XmStringGetLtoR(card_label, XmSTRING_DEFAULT_CHARSET, &label);
       XmStringFree(card_label);

	if (!label) return;

	/* XtFree(label) <- No, not needed! Its a static variable */

       /* 
	  The language is unknown. Any entry can appear in the resource file.
	  This string might be "1 Cards" or "1 Cartes" or just "Cards"
	  This is a simple check to Strip off any digits.
	  Attempting to isolate the word "Card"
	  A big assumption is made here, users can change the resource
	  file to contain something screwy! Like 
		*Label*labelString: C1a2r3d4s
	  I look for *Label*labelString: 1234 Cards
	  The digits must be up front on theleft for this to work!!
                 BUG TIME OTHERWISE. I can only due so much.
       */
       for (i=0, n=strlen(label); i<n; i++ )
	       if ( isdigit( (int) label[i]) )
	       {
		   num_of_digits++;
		   label[i] = ' ';
		}

       /* Get whatever word represents "Cards" */
	strcpy(tmp,label+num_of_digits);

	/* Label has just been set! Don't change label, its static */
	strcpy(label,tmp);

   } /* end if label */


if (head_ptr->card_view) {

/* Go set the text widets's text to the just selected position */
  tmp_ptr = head_ptr->viewable_cards;
  user_data = head_ptr->primary_card;
      for (i = head_ptr->visible_spots ; i > 0; i-- ) {
       XmTextSetString(tmp_ptr->address, user_data->address);
       XmTextSetString(tmp_ptr->index, user_data->index);
       tmp_ptr = tmp_ptr->next;
       user_data = user_data->next;

     } /* end for visible_spots */

} /* end if card_view */

/* Don't redraw the "n Cards" label if the number of cards didn't change */
if (head_ptr->cards == cards) return;

	/* Convert the actual number of cards to a string */
	cards = head_ptr->cards;
	sprintf(tmp,"%d",cards);
       
/* Insert the new number of cards */
	num_of_digits = strlen(tmp);
	tmp[num_of_digits] = ' ';
	tmp[num_of_digits+1] = '\0';
	strcat(tmp,label);

card_label = XmStringCreateSimple(tmp);
XtVaSetValues(head_ptr->label,
			XmNlabelString,		card_label,
			NULL);

} /* end Redraw_List */


/*
   *****************************************************************    
   ***************************************************************** 
    Name:
         Create_Prompt

    Purpose:
         Create a dialog box in which the user is notified to enter
         show data.

    Calling Sequence:
     1. User selects Add card from  "card" on the main menu.
     2. Card_Menu_Callback() see card_callback.c comes here.
         OR
     1. User selects Goto, Find, or Find Next from "search" on the main menu.
     2. Search_Menu_Callback() see search_callback.c comes here.

     The label strings are different, see the resource file
     The XmNokCallback are also different depending on who called.
     The callback is set there, that's why this routine returns a
     Widget.

    Description:
     1. Call the Motif convience routine to create the dialog box.
     2. Establish the cancel button to dismiss the widget.
     3. Manage the widget.
     4. Return the widget value/

   ***************************************************************** 
   ***************************************************************** 
*/
extern Widget Create_Prompt(prompt)
char *prompt;
{
static Widget dialog;
Arg args[3];


    /* Create the Prompt Dialog pop up */
    XtSetArg(args[0], XmNautoUnmanage, False);
    XtSetArg(args[1], XmNcolumns, 40);
    dialog = XmCreatePromptDialog(head_ptr->parent_form,prompt, args, 2);

/* Not here!!!! ->    XtAddCallback(dialog, XmNokCallback, YOUR_CALLBACK,NULL); */
    XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc) XtDestroyWidget,NULL);
    XtSetSensitive(XmSelectionBoxGetChild(dialog,XmDIALOG_HELP_BUTTON),False);
    XtManageChild(dialog);

/*
     ????? Can I make the user close this dialog before proceeding
         XtPopup(XtParent(dialog), XtGrabNone);
*/

return(dialog);

} /* end Create_Prompt */


/*
   *****************************************************************    
   ***************************************************************** 
    Name:
         Create_Info_Prompt

    Purpose:
         Create a dialog box in which the user is given some information.

    Calling Sequence:
     1. Child_Check() see file_callback.c

     The label strings are different, see the resource file

    Description:
     1. Call the Motif convience routine to create the dialog box.
     2. Establish the OK button to dismiss the widget.
     3. Get rid of the Help & Cancel buttons.
     4. Manage the widget.


   ***************************************************************** 
   ***************************************************************** 
*/
extern void Create_Info_Prompt(prompt)
char *prompt;
{
static Widget dialog;

        dialog = XmCreateInformationDialog(head_ptr->parent_form, prompt, NULL, 0);
	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc) XtDestroyWidget, NULL);

#ifdef NOT_NECESSARY
        XtSetSensitive(XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON),False);
        XtSetSensitive(XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON),False);
#endif

        XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON));
        XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON));
        XtManageChild(dialog);

} /* end Create_Info_Prompt */


/*
   ***************************************************************** 
   Name:
       Create_Error_Prompt
   Purpose:
       Creates a dismissable error message for the user.

   Calling Sequence:
       Numerous routines that may produce an escapable call the routine.
       The actual error string is stored in the resource file. Only the
       widget name is passed to this routine.

   Description:
       1. Call the Motif convience routine to create an error dialog.
       2. Map the OK button to dissmiss the dialog.
       3. Get rid of the Help Cancel button. It's just baggage.
       4. Manage the widget. In Motif, this displays the dialog.

   ***************************************************************** 
*/
extern Widget Create_Error_Prompt(prompt)
char *prompt;
{
static Widget dialog;

        dialog = XmCreateErrorDialog(head_ptr->parent_form, prompt, NULL, 0);
	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc) XtDestroyWidget, NULL);

#ifdef DEBUG
{
XmString rabbit_message;
if (prompt[0] == 'R') {
rabbit_message = XmStringCreateLtoR("You wasically wabbit","charset");
XtVaSetValues(dialog,XmNmessageString, rabbit_message, NULL);
XtFree(rabbit_message);
}
}
#endif

#ifdef NOT_NECESSARY
        XtSetSensitive(XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON),False);
        XtSetSensitive(XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON),False);
#endif

        XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON));
        XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON));
        XtManageChild(dialog);

return dialog;

} /* end Create_Error_Prompt */


/* ******************************************************** */
/* ******************************************************** */
/* ******************************************************** */
/* ******************************************************** */
extern void Configure_Minimum_Size_Callback(shell, client_data, event)
Widget shell;
XtPointer client_data;
XConfigureEvent *event;
{

    if ( event->type != ConfigureNotify) return;

/*
int height, width; 

height = event->height;
width =  event->width;

     XtVaSetValues(shell, XmNminHeight, event->height,
		   XmNminWidth, event->width,
		   XmNheight, height,
		   XmNwidth, width,
		   NULL);
*/
/*
 Only want the minimum size set once!
 Not every time a ConfigureNotify event occurs
*/
     XtRemoveEventHandler(shell, StructureNotifyMask, False, Configure_Minimum_Size_Callback, NULL);

} /* Configure_Minimum_Size_Callback */
