/*
  ************************************************************************
  ************************************************************************

    Copyright (C) 1995   Michael J. Oehler

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  ************************************************************************
  ************************************************************************
*/

#include "crd.h"
#include <Xm/Text.h>

static Widget Get_Selection()
{
Widget owner = NULL;
char *highlighted_text;


#ifdef SOME_DAY
/* XmInternAtom does work, eventhough used on page 628 Motif Programming Manual.  */
     Display *dpy = XtDisplay(widget);
     Atom clipboard_atom = XmInternAtom(dpy, "CLIPBOARD", False);
     Window win = XGetSelectionOwner(dpy, clipboard_atom);
     Widget widget = XtWindowToWidget(dpy,win);
#endif

/*
 This is a work around to determine who owns the text selection
 Not interested in the text! Only the WIDGET that has the text!
   This choses the text from one widget or the other.
 */
     if ( (highlighted_text = XmTextGetSelection(head_ptr->viewable_cards->index) ))
       {
	 owner = head_ptr->viewable_cards->index;
	 XtFree(highlighted_text);
       }
     else  /* NULL text returned, try other widget */
       if ( (highlighted_text = XmTextGetSelection(head_ptr->viewable_cards->address) ))
	 {
	   owner = head_ptr->viewable_cards->address;
	   XtFree(highlighted_text);
	 }
/* If the user did not high light any text, post an error */
if ( !owner)
    Create_Error_Prompt("Search_Error");

return(owner);
}


/*
  ************************************************************************
  ************************************************************************

   Name:
     Edit_Menu_Callback

   Purpose:
     This is the callback routine for the sub buttons off the "Edit" in the main menu

   Calling Sequence:
    

   Description:

  ************************************************************************
  ************************************************************************
*/
extern void Edit_Menu_Callback(widget, item_no, call_data)
Widget widget;
int item_no;
XmAnyCallbackStruct *call_data;
{
Widget owner = NULL;

Boolean result;

switch (item_no) {
    /* undo */
  case 0:
    
    break;

    /* Cut */
  case 1:
  
    if (!(owner=Get_Selection()) ) return;
    result = XmTextCut(owner, CurrentTime);
    break;
  
    /* Copy */
  case 2:
  
    if (!(owner=Get_Selection()) ) return;
    result = XmTextCopy(owner, CurrentTime);
    break;
    

    /* Paste */
  case 3:
{
    if (!XmTextPaste(head_ptr->viewable_cards->address))
	    Create_Error_Prompt("Search_Error");
    break;
   }    

} /* end switch */

/* if (!result) */

}
