/*
  ************************************************************************
  ************************************************************************
    Copyright (C) 1995   Michael J. Oehler

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 Module Description:


  ************************************************************************
  ************************************************************************
*/

#include "crd.h"
#include "oehler.xbm"
#include <Xm/MessageB.h>

#ifdef  __STDC__
static void About( void );

#else
static void About();
#endif


/*
  ************************************************************************
  ************************************************************************
  Name:
	Help_Menu_Callback
  Calling Sequence:
	Called from the "help" option on the main menu bar.

  Description:
	This routines calls the specific function requested.
	Based on the integer in item_no

   *****************************************************************
   *****************************************************************
*/
extern void Help_Menu_Callback(widget, item_no)
Widget widget;
int item_no;

{

switch (item_no) {

 /* About Mcard */
 case 0: {
   About();
   break;
  }

 /* Help */
 case 1: {
   Create_Error_Prompt("Rabbit");
   break;
  }
}

} /* end Help_Menu_Callback */



/*
  ************************************************************************
  ************************************************************************
  Name:
    About()

  Purpose:
    Pops up a dialog giving information about mcard

  Calling Sequence:
    1. User selects the first button in the "Help" pull down
    2. Help_Menu_Callback is called
    3. Flow is passed here from the first case in the switch

  Description    
    1. Create the Pixmap and message string.
        It was hard coded to avoid fraud. 
    2. Create the Dialog
    3. Set the Pixmap resource for the dialog
    4. Set the OK callback to cancel the dialog

  ************************************************************************
  ************************************************************************
*/
static void About()
{
int i;
static Widget dialog;
Pixmap pixmap;
Pixel fg, bg;
XmString message;
static XImage ximage;

ximage.width = oehler_width;
ximage.height = oehler_height;
ximage.data = oehler_bits;
ximage.xoffset = 0;
ximage.format = XYBitmap;
ximage.byte_order = MSBFirst;
ximage.bitmap_pad=8;
ximage.bitmap_bit_order = LSBFirst;
ximage.bitmap_unit = 8;
ximage.depth = 1;
ximage.bytes_per_line = 8;
ximage.obdata = NULL;


/* Needed only for the pixmap call */
        XtVaGetValues(head_ptr->parent_form,
		XmNforeground,		&fg,
		XmNbackground,		&bg,
		NULL);
/*
  By using XmGetPixmap, Motif caching is implied.
  Not so with XCreateBitmapFrom(Bitmap)Data

   pixmap = XmGetPixmap(XtScreen(head_ptr->parent_form),"xlogo16", fg, bg);
*/
 
/* Create the information dialog about myself */
  dialog = XmCreateInformationDialog(head_ptr->parent_form, "About", NULL, 0);

 XtAddCallback(dialog, XmNokCallback, (XtCallbackProc) XtDestroyWidget, NULL);

#ifdef NOT_NECESSARY

     XtSetSensitive(XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON),False);
     XtSetSensitive(XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON),False);
#endif

/* Set the Pixmap in the dialog, then release the space */
message = XmStringCreateLtoR(
"Yet Another Great Program by\n\
Michael J. Oehler\nMotif CardFile Version 1.3\nmjo@ai.net","charset");

 XmInstallImage(&ximage, "Oehler");
   pixmap = XmGetPixmap(XtScreen(head_ptr->parent_form),"Oehler", fg, bg);

#ifdef MIKEY
pixmap = XCreateBitmapFromData(
			XtDisplay(head_ptr->parent_form),
			RootWindowOfScreen(XtScreen(head_ptr->parent_form)),
			oehler_bits, oehler_width, oehler_height);

if (pixmap)
{
XtVaSetValues(dialog,
		XmNsymbolPixmap,	pixmap,
		XmNmessageString,	message,
		NULL);
/*  XmFreePixmap(pixmap); <- read about Motif pixmap caching first. */
}
else
#endif

XtVaSetValues(dialog,
		XmNsymbolPixmap,	pixmap,
		XmNmessageString,	message,
		NULL);


XmStringFree(message);
        XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON));
        XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON));
        XtManageChild(dialog);

} /* About */