/*
  ************************************************************************
  ************************************************************************

    Copyright (C) 1995   Michael J. Oehler

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Module Description:



  ************************************************************************
  ************************************************************************
*/

#include "crd.h"
#include <string.h>

#ifdef __STDC__
static void Find_Search_Data(Widget, XtPointer, XmSelectionBoxCallbackStruct *);

#else
static void Find_Search_Data();
#endif


/*
  ************************************************************************
  ************************************************************************
  Name:
     Search_Menu_Callback

  Calling Sequence:
     0. Callback is established in Interface_Initialization, see init.c
     1. User selects a pull down button from the "Search" on the menu

  Purpose:
     To call the appropriate routine to perform the selected operation

  Description:
     1. Via a switch and item_no either set up the dialog or go search.

  ************************************************************************
  ************************************************************************
*/
extern void Search_Menu_Callback(widget, item_no, call_data)
Widget widget;
int item_no;
XmAnyCallbackStruct *call_data;
{
 switch (item_no) {
 /* Goto */
 case 0: {
    /* Creates the Dialog, then sets its OK Callback! */
    XtAddCallback(Create_Prompt("Goto_Prompt"), XmNokCallback, (XtCallbackProc) Find_Search_Data,NULL);
    break;
  }
 /* Find */
 case 1: {
    /* Creates the Dialog, then sets its OK Callback! */
    XtAddCallback(Create_Prompt("Find_Prompt"), XmNokCallback, (XtCallbackProc) Find_Search_Data,(XtPointer)1);
    break;
 /* Find Next */
 case 2: {
    /* Don't have to get any info from the user, thus no Dialog is needed */
    Find_Search_Data(NULL, (XtPointer) 2,NULL);
    break;
  }
 }
 }
} /* Search_Menu_Callback */



/*
  ************************************************************************
  ************************************************************************
  Name:
     Find_Search_Data

  Calling Sequence:
     Only from Search_Callback

  Purpose:
     Get user data & find the index and address with that data.

  Description:
     1. If "Goto" or "Find" is selected, get user data
	else, "Find Next" was entered.     

  ************************************************************************
  ************************************************************************
*/
static void Find_Search_Data(widget,data,cbs)
Widget widget;
XtPointer data;
XmSelectionBoxCallbackStruct *cbs;
{
Card_Ptr dummy;
char *in_there, *or_here;
char *search_for;
int which;

/*
  Although "data" is a pointer, we only need to determine
  if its set to know what function to preform.
  0 = "Goto" 1 = "Find" 2 = "FInd Next"
*/
which = (data) ? (int) data : 0;

/*
  Go convert the XmString entered by the user to a character string
  This string must be XtFree()'ed. If "Find Next", then skip.
  If we got here, some data, even just a CR, was entered.
*/
     if ( which !=2 )
     {
	XmStringGetLtoR(cbs->value,XmSTRING_DEFAULT_CHARSET,&search_for);
	/* Dismissed the PromptDialog */
	XtDestroyWidget(widget);

	/* Clear the old data to search for & store the newly entered data */
	XtFree(head_ptr->search_for);
	head_ptr->search_for = search_for;

     }
     else {
     /* Check to see if anything was entered previously for "Find Next" */
     if (!head_ptr->search_for)
	{
	   Create_Error_Prompt("Search_Error");
	   return;
	}
     search_for = head_ptr->search_for;
     }

/* There may have been updates in the primary card widgets. Go check. */
     Grab_Primary_Card_Data(widget);

/* Look for the first close or exact occurence of the entered text */
if ( !which ) {
     for (dummy=head_ptr->primary_card->next; dummy != head_ptr->primary_card; dummy = dummy->next) {
       in_there = strstr(dummy->index, search_for);
       if (in_there)
	 break;
	  }
   }
else {
     for (dummy=head_ptr->primary_card->next; dummy != head_ptr->primary_card; dummy = dummy->next) {
       in_there = strstr(dummy->index, search_for);
       or_here = strstr(dummy->address, search_for);
       if (in_there || or_here)
	 break;
	  }

}

head_ptr->primary_card = dummy;
head_ptr->search_for = search_for;
     Redraw_List();



} /* end Find_Search_Data */
